 //*-- Intel Copyright Notice --
 //* 
 //* 
 //* Copyright (c) 2002-2010 Intel Corporation All Rights Reserved.
 //* 
 //*
 //* The source code contained or described herein and all documents
 //* related to the source code ("Material") are owned by Intel Corporation
 //* or its suppliers or licensors.  Title to the Material remains with
 //* Intel Corporation or its suppliers and licensors.
 //* 
 //*
 //* The Material is protected by worldwide copyright and trade secret laws
 //* and treaty provisions. No part of the Material may be used, copied,
 //* reproduced, modified, published, uploaded, posted, transmitted,
 //* distributed, or disclosed in any way except in accordance with the
 //* applicable license agreement .
 //* 
 //*
 //* No license under any patent, copyright, trade secret or other
 //* intellectual property right is granted to or conferred upon you by
 //* disclosure or delivery of the Materials, either expressly, by
 //* implication, inducement, estoppel, except in accordance with the
 //* applicable license agreement.
 //* 
 //*
 //* Unless otherwise agreed by Intel in writing, you may not remove or
 //* alter this notice or any other notice embedded in Materials by Intel
 //* or Intel's suppliers or licensors in any way.
 //* 
 //* 
 //* For further details, please see the file README.TXT distributed with
 //* this software.
 //* 
 //*
 //* -- End Intel Copyright Notice --/
 //
//                              -*- Mode: Verilog -*-
// Filename        : top.v
// Description     : Top level
// Version         : 0.37
// Description     : Target FAB D1 Little Bay


// Signals that need internal pullups
// All the PWRGD signals.
// OVR_SMC_VCC_VID_N
// OVR_SMC_VNN_VID_N

module top
  (
	// Carrier board signals
	 input CB_RST_BTN_N,       //Reset button. Aka CB_SYS_RESET_N
	 input CB_PWR_BTN_N,       //Power button.
	 input CB_PWROK,           //Power OK from Carrier Board
	 output CB_RESET_N,
	 output CB_WAKE_N,
	
	// Pwr & clock Mgt
	 output [2:0] PWRMODE,
	 input 		  SLPMODE,
	 input 		  SLPRDY_N,
	 input 		  RSTRDY_N,
  	 output 		  RSTWARN,
	 output 		  CPU_RST_N,   //Tunnel Creek reset
	 output 		  RSMRST_N,
	 output 		  PWROK,
	 output 		  CK505_EN,    //Enable or Reset pin for CK505
	 output 		  SLP_S3_N,
	 output 		  SLP_S3,
	 output 		  SLP_S5_N,
  	
	// VID
	 output [6:0] VCC_VID,     //To IMVP6
	 output [6:0] VNN_VID,     //To IMVP6
	 input [6:0]  SMC_VID,
	 input [1:0]  SMC_VIDEN,
	 input 		  OVR_ALL_VID_N,  // Tristates VCC/VNN_VID when asserted

	// VR controls
	 output 		  V3P3_EN,         //S3,S0
	 input 		  V3P3_PWRGD,
	 output 		  V1P8_EN,         //S3,S0
	 input 		  V1P8_PWRGD,
	 output 		  V1P05_EN,        //S3,S0
	 input 		  V1P05_PWRGD,
	 output 		  V3P3_S_EN,       //S0
	 output 		  V3P3_S_PWRGD,
	 output 		  V1P05_S_EN,      //S0
	 input 		  V1P05_S_PWRGD,
	 output 		  VNN_S_EN,        //S0, aka VNN_SHDN_N
	 input 		  VNN_S_PWRGD,
	 output 		  V1P8_S_EN,       //S0
	 output 		  V1P5_S_EN,       //S0
	 input 		  V1P5_S_PWRGD,
	 output 		  VCC_S_EN,        //S0, aka VCC_SHDN_N
	 input 		  VCC_S_PWRGD,
	 output 		  V0P9_S_EN,

	// Interrupts
	 input 		  THERMTRIP_3P3_N,

	//LEDs
	 output 		  CPU_IERR_VALID, // Asserts during M5
	 output 		  THERMTRIP_LED_N,

	//Debug pins
//	 output 		  OVL_TCK,  //TCK   -- Unused pins.
//	 output 		  OVL_TMS,  //TMS   -- Unused pins.
//	 output 		  OVL_TDI,  //TDI   -- Unused pins.
//	 output 		  OVL_TRST_N,   //TRST  -- Unused pins.

//	 output 		  HIGHZ_N,
//	 input 		  XDP_PRSNT_N,     // -- Unused pins.
	 output 		  LVDS_EN_N,     // Isolates LVDS signals from GPIO when asserted
	 input 		  KBD_RST_N,
	 output			HDR_P4,
	 output			HDR_P5
	);

	/* Added below assignments */
         assign HDR_P4 = 1'bz;      //-- Unused pins.
         assign HDR_P5 = 1'bz;      //-- Unused pins.
        /************************/
	

	wire [6:0] vcc_vid_out, vnn_vid_out;
	wire 		  clk_5_56m;
	wire 		  clk_en;
	wire 		  s0_pwrgd, s3_pwrgd;
	reg 		  thermtrip;
	wire 		  reset;
	reg 		  wire_slp_s5_n_d1;
	wire 		  wire_slp_s3_n, wire_slp_s5_n;
	wire 		  slow_clk;
	wire 		  wake_n;

	////////////////////////////////////////////////////////

        wire 		  CB_RST_BTN_N_db;   //Reset button. Aka CB_SYS_RESET_N
        wire 		  CB_PWR_BTN_N_db;       //Power button.

        debouncer cb_rst_btn_n_inst
          (
           .CLK(clk_5_56m),
           .RESET(1'b0),
           .BUTTON_IN(CB_RST_BTN_N),
           .BUTTON_OUT(CB_RST_BTN_N_db)
           );
        debouncer cb_pwr_btn_n_inst
          (
           .CLK(clk_5_56m),
           .RESET(1'b0),
           .BUTTON_IN(CB_PWR_BTN_N),
           .BUTTON_OUT(CB_PWR_BTN_N_db)
           );

// Low pass filter the Punit signals
   //
   reg [2:0] 			  slprdy_n_delay = 3'b0;
   reg [2:0] 			  rstrdy_n_delay = 3'b0;
   reg [2:0] 			  slpmode_delay =  3'b0;
   reg [2:0] 			  s0_pwrgd_delay =  3'b0;
   reg [2:0] 			  s3_pwrgd_delay =  3'b0;
       
   reg 				  slprdy_n_filter = 0;
   reg 				  rstrdy_n_filter = 0;
   reg 				  slpmode_filter  = 0;

   always @( posedge clk_5_56m )
     begin
	s0_pwrgd_delay[0] <= s0_pwrgd;
        s0_pwrgd_delay[1] <= s0_pwrgd_delay[0];
        s0_pwrgd_delay[2] <= s0_pwrgd_delay[1];
     end
   always @( posedge clk_5_56m )
     begin
	s3_pwrgd_delay[0] <= s3_pwrgd;
        s3_pwrgd_delay[1] <= s3_pwrgd_delay[0];
        s3_pwrgd_delay[2] <= s3_pwrgd_delay[1];
     end
   always @( posedge clk_5_56m )
     begin
	slprdy_n_delay[0] <= SLPRDY_N;
        slprdy_n_delay[1] <= slprdy_n_delay[0];
        slprdy_n_delay[2] <= slprdy_n_delay[1];
	if ( &{slprdy_n_delay[2:0]} )
	  slprdy_n_filter <= 1'b1;
	else if (~|{slprdy_n_delay[2:0]} )
	  slprdy_n_filter <= 1'b0;
     end
   
   always @( posedge clk_5_56m )
     begin
	rstrdy_n_delay[0] <= RSTRDY_N;
        rstrdy_n_delay[1] <= rstrdy_n_delay[0];
        rstrdy_n_delay[2] <= rstrdy_n_delay[1];
	if ( &{rstrdy_n_delay[2:0]} ) rstrdy_n_filter <= 1'b1;
	else  if ( ~|{rstrdy_n_delay[2:0]} ) rstrdy_n_filter <= 1'b0;
	
     end
   always @( posedge clk_5_56m )
     begin
	slpmode_delay[0] <= SLPMODE;
        slpmode_delay[1] <= slpmode_delay[0];
        slpmode_delay[2] <= slpmode_delay[1];
	if ( &{slpmode_delay[2:0]} ) slpmode_filter <= 1'b1;
	else
	  if ( ~|{slpmode_delay[2:0]} ) slpmode_filter <= 1'b0;
     end
 
	assign     CB_WAKE_N = wake_n ? 1'bz : 1'b0;
	assign 	  SLP_S3 = !SLP_S3_N;
	assign 	  CB_RESET_N = CPU_RST_N;
//	assign 	  HIGHZ_N = 1'bz;
	assign 	  CPU_IERR_VALID = (PWRMODE[2:0] == 3'b101);
	
	// VCC, VNN demux module
	vid_demux i_vid_demux
	  (
		.RST (reset),
		.CLK(clk_5_56m),
		.VCC_VID(vcc_vid_out),
		.VNN_VID(vnn_vid_out),
		.SMC_VID(SMC_VID),
		.SMC_VIDEN(SMC_VIDEN),
		.PWRMODE(PWRMODE)
		);

	// Tristates VID outputs
	
	assign VCC_VID[6:0] = OVR_ALL_VID_N ? vcc_vid_out[6:0] : 7'hzz;
	assign VNN_VID[6:0] = OVR_ALL_VID_N ? vnn_vid_out[6:0] : 7'hzz;

	// Power management
	pwr_mgt i_pwr_mgt
	  (
		.CLK(clk_5_56m),
		.RST_BTN_N(CB_RST_BTN_N_db),
		.PWR_BTN_N(CB_PWR_BTN_N_db),
		.PWRMODE(PWRMODE),
		.SLPMODE(slpmode_filter),
		.SLPRDY_N(slprdy_n_filter),
		.RSTWARN(RSTWARN),
		.RSTRDY_N(rstrdy_n_filter),
		.CPU_RST_N(CPU_RST_N),
		.RSMRST_N(RSMRST_N),
		.PWROK(PWROK),
		.SLP_S3_N(wire_slp_s3_n),
		.S0_PWRGD(s0_pwrgd_delay[2]),
		.SLP_S5_N(wire_slp_s5_n),
		.S3_PWRGD(s3_pwrgd_delay[2]),
		.CK505_EN(CK505_EN),
//		.XDP_PRSNT_N(XDP_PRSNT_N),
		.LVDS_EN_N (LVDS_EN_N),
		.THERMTRIP (thermtrip),
		.KBD_RST_N (KBD_RST_N),
		.WAKE_N (wake_n)
//		.WAKE_N (CB_WAKE_N),
		);

	// Voltage sequencer
	assign SLP_S3_N = wire_slp_s3_n;
	assign SLP_S5_N = wire_slp_s5_n;
 
	vr_seqcr i_vr_seqcr
	  (
		.CLK (slow_clk),
		.SLP_S3_N(SLP_S3_N),
		.SLP_S5_N(SLP_S5_N),
		.S0_PWRGD(s0_pwrgd),
		.S3_PWRGD(s3_pwrgd),
		.V3P3_EN(V3P3_EN),
		.V3P3_PWRGD(V3P3_PWRGD),
	  	.V1P8_EN(V1P8_EN),
		.V1P8_PWRGD(V1P8_PWRGD),
		.V1P05_EN(V1P05_EN),
		.V1P05_PWRGD(V1P05_PWRGD),
		.V3P3_S_EN(V3P3_S_EN),
		.V3P3_S_PWRGD(V3P3_S_PWRGD),
		.V1P05_S_EN(V1P05_S_EN),
		.V1P05_S_PWRGD(V1P05_S_PWRGD),
		.VNN_S_EN(VNN_S_EN),
		.VNN_S_PWRGD(VNN_S_PWRGD),
		.V1P8_S_EN(V1P8_S_EN),
		.V1P5_S_EN(V1P5_S_EN),
		.V1P5_S_PWRGD(V1P5_S_PWRGD),
		.VCC_S_EN(VCC_S_EN),
		.VCC_S_PWRGD(VCC_S_PWRGD),
		.V0P9_S_EN(V0P9_S_EN),
		.CB_PWROK(CB_PWROK)
		);

	// HPLL fix
/*	hpll_fix i_hpll_fix
	  (
		.CLK (clk_5_56m),
		.PWRMODE(PWRMODE),
		
		.OVL_TRST(OVL_TRST_N),
		.OVL_XXTCK(OVL_TCK),
		.OVL_TDI(OVL_TDI),
		.OVL_TMS(OVL_TMS)
		);
 */

	// Clock and reset unit. Generates 5.56MHz internal clock.
	// Slow clock has 1.466ms period
	cru i_cru
	  (
		.CLK (clk_5_56m),
		.SLOW_CLK (slow_clk)
		);

	// LED indicators. Specific to Little Bay
	always @ (posedge clk_5_56m)
	  begin
		  if (!THERMTRIP_3P3_N && 
				((PWRMODE[2:0] == 3'b101)/* || (PWRMODE[2:0] == 3'b001)*/))
			 thermtrip <= 1'b1;
		  else if (!CB_RST_BTN_N_db || !CB_PWR_BTN_N_db)  // Only power or reset button pressed, LED clears 
			 thermtrip <= 1'b0;
		  else
			 thermtrip <= thermtrip;
	  end
	assign THERMTRIP_LED_N = !thermtrip;

	always @ (posedge clk_5_56m)
	  wire_slp_s5_n_d1 <= SLP_S5_N;
		
	assign reset = !wire_slp_s5_n_d1 && SLP_S5_N;

endmodule // top


	  
		
