 //*-- Intel Copyright Notice --
 //* 
 //* 
 //* Copyright (c) 2002-2010 Intel Corporation All Rights Reserved.
 //* 
 //*
 //* The source code contained or described herein and all documents
 //* related to the source code ("Material") are owned by Intel Corporation
 //* or its suppliers or licensors.  Title to the Material remains with
 //* Intel Corporation or its suppliers and licensors.
 //* 
 //*
 //* The Material is protected by worldwide copyright and trade secret laws
 //* and treaty provisions. No part of the Material may be used, copied,
 //* reproduced, modified, published, uploaded, posted, transmitted,
 //* distributed, or disclosed in any way except in accordance with the
 //* applicable license agreement .
 //* 
 //*
 //* No license under any patent, copyright, trade secret or other
 //* intellectual property right is granted to or conferred upon you by
 //* disclosure or delivery of the Materials, either expressly, by
 //* implication, inducement, estoppel, except in accordance with the
 //* applicable license agreement.
 //* 
 //*
 //* Unless otherwise agreed by Intel in writing, you may not remove or
 //* alter this notice or any other notice embedded in Materials by Intel
 //* or Intel's suppliers or licensors in any way.
 //* 
 //* 
 //* For further details, please see the file README.TXT distributed with
 //* this software.
 //* 
 //*
 //* -- End Intel Copyright Notice --/
 //

//                              -*- Mode: Verilog -*-
// Filename        : vid_demux.v
// Description     : Demuxing of VID values from CPU
// Version         : 0.4


// VID and VIDEN must be de-bounced together(they can change at the same time) for 100ns(min) - 400ns(max).
// From Tunnel Creek side, the VID/VIDEN values will be held constant for 500ns(min) to ensure that the EC will track the change.


module vid_demux
  (
	 input RST,
	 input CLK,
	 input [6:0] SMC_VID,
	 input [1:0] SMC_VIDEN,
	 output reg [6:0] VCC_VID, // MAX8796 outputs 1.1V @ startup
	 output reg [6:0] VNN_VID,  // MAX8796 outputs 0.9V @ startup
	 input [2:0] 		PWRMODE
	);

	reg [1:0] 		  smc_viden_d1, smc_viden_d2;
	
	
	// Synchronizer to avoid metastability issue.
	always @ (posedge CLK)
	  begin
		  smc_viden_d1[1:0] <= SMC_VIDEN[1:0];
		  smc_viden_d2[1:0] <= smc_viden_d1[1:0];
	  end
	
		
	// VIDEN as on TNC EAS
	// 00: VID is invalid
	// 01: VID == Vcc
	// 10: VID == Vnn
	// 11: Unused

	// TNC first presents VNN during M3.
	// TNC then presents VCC during M1.
	// Need >100ns of debouncing before latching in VID, VIDEN

	always @ (posedge CLK, posedge RST)
	  begin
		  if (RST)
			 begin
				 VNN_VID[6:0] <= 7'b0110000;
				 VCC_VID[6:0] <= 7'b0100000;
			 end
		  else
			 begin
				 if ((smc_viden_d2 == 2'b10) && ((PWRMODE[2:0] == 3'b011) || (PWRMODE[2:0] == 3'b101)))
					VNN_VID[6:0] <= SMC_VID[6:0];
				 else if (smc_viden_d2 == 2'b01)
					VCC_VID[6:0] <= SMC_VID[6:0];
				 else
					begin
						VNN_VID <= VNN_VID;
						VCC_VID <= VCC_VID;
					end
			 end // else: !if(RST)
	  end // always @ (posedge CLK)
	

endmodule // vid_demux

