 //*-- Intel Copyright Notice --
 //* 
 //* 
 //* Copyright (c) 2002-2010 Intel Corporation All Rights Reserved.
 //* 
 //*
 //* The source code contained or described herein and all documents
 //* related to the source code ("Material") are owned by Intel Corporation
 //* or its suppliers or licensors.  Title to the Material remains with
 //* Intel Corporation or its suppliers and licensors.
 //* 
 //*
 //* The Material is protected by worldwide copyright and trade secret laws
 //* and treaty provisions. No part of the Material may be used, copied,
 //* reproduced, modified, published, uploaded, posted, transmitted,
 //* distributed, or disclosed in any way except in accordance with the
 //* applicable license agreement .
 //* 
 //*
 //* No license under any patent, copyright, trade secret or other
 //* intellectual property right is granted to or conferred upon you by
 //* disclosure or delivery of the Materials, either expressly, by
 //* implication, inducement, estoppel, except in accordance with the
 //* applicable license agreement.
 //* 
 //*
 //* Unless otherwise agreed by Intel in writing, you may not remove or
 //* alter this notice or any other notice embedded in Materials by Intel
 //* or Intel's suppliers or licensors in any way.
 //* 
 //* 
 //* For further details, please see the file README.TXT distributed with
 //* this software.
 //* 
 //*
 //* -- End Intel Copyright Notice --/
 //

//                              -*- Mode: Verilog -*-
// Filename        : vr_seqcr.v
// Description     : Voltage rail sequencer
// Version         : 0.35
// Description     : Targets FAB D1 Little Bay



module vr_seqcr
  (
	input CLK,   // Slow clock ~1ms period
	input SLP_S3_N,
	input SLP_S5_N,
	output S0_PWRGD,
	output S3_PWRGD,
	output reg V3P3_EN = 0,
	input V3P3_PWRGD,
	output reg V1P8_EN = 0,
	input V1P8_PWRGD,
	output reg V1P05_EN = 0,
	input V1P05_PWRGD,
	output reg V3P3_S_EN = 0,
	output V3P3_S_PWRGD,
	output reg V1P05_S_EN = 0,
	input V1P05_S_PWRGD,
	output reg VNN_S_EN = 0,
	input VNN_S_PWRGD,
	output reg V1P8_S_EN = 0,
	output reg V1P5_S_EN = 0,
	input V1P5_S_PWRGD,
	output reg VCC_S_EN = 0,
	input VCC_S_PWRGD,
	output V0P9_S_EN,
	input CB_PWROK
	);

	reg 	slp_s5_n_d1 = 0, slp_s5_n_d2 = 0, slp_s5_n_d0 = 0;
	reg 	slp_s3_n_d1 = 0, slp_s3_n_d2 = 0, slp_s3_n_d0 = 0;
	wire 	slp_s5_n_redge, slp_s5_n_fedge;
	wire 	slp_s3_n_redge, slp_s3_n_fedge;
	reg [2:0] stby_on_sreg = 0, stby_off_sreg = 0;
	reg [31:0] full_on_sreg = 0;
	reg [5:0] full_off_sreg = 0;
		
	assign V3P3_S_PWRGD = VNN_S_EN;
		
	assign S0_PWRGD = VCC_S_PWRGD & V1P5_S_PWRGD & VNN_S_PWRGD
							& V1P05_S_PWRGD & S3_PWRGD;
	assign S3_PWRGD = V3P3_PWRGD & V1P8_PWRGD & V1P05_PWRGD;

	always @ (posedge CLK)
	  begin
		  slp_s5_n_d0 <= SLP_S5_N;
		  slp_s5_n_d1 <= slp_s5_n_d0;
		  slp_s5_n_d2 <= slp_s5_n_d1;
	  end

	assign slp_s5_n_redge = slp_s5_n_d1 & !slp_s5_n_d2;
	assign slp_s5_n_fedge = !slp_s5_n_d1 & slp_s5_n_d2;
	

	always @ (posedge CLK)
	  begin
		  slp_s3_n_d0 <= SLP_S3_N & CB_PWROK;
		  slp_s3_n_d1 <= slp_s3_n_d0 ;
		  slp_s3_n_d2 <= slp_s3_n_d1;
	  end

	assign slp_s3_n_redge = slp_s3_n_d1 & !slp_s3_n_d2;
	assign slp_s3_n_fedge = !slp_s3_n_d1 & slp_s3_n_d2;

	
	// Sequence voltages S5 to S3
	// TPS51117 ramps 3.3V in about 700us. 
	// TPS51116 ramps 1.8V in 180us. PGOOD in 200us(max). Total ~300us.
	// AS1371 ramps 1.05V in 90us.
	// All will switch off at the same time. Ramp down could be different.

	always @ (posedge CLK)
	  stby_on_sreg[2:0] <= {slp_s5_n_redge, stby_on_sreg[2:1]};
		
	always @ (posedge CLK)
	  stby_off_sreg[2:0] <= {slp_s5_n_fedge, stby_off_sreg[2:1]};

	always @ (posedge CLK)
	  begin
		  if (stby_on_sreg[2])
			 V3P3_EN <= 1;
		  else if (stby_off_sreg[0])
			 V3P3_EN <= 0;
		  else
			 V3P3_EN <= V3P3_EN;
	  end

	always @ (posedge CLK)
	  begin
		  if (stby_on_sreg[1])
			 V1P8_EN <= 1;
		  else if (stby_off_sreg[1])
			 V1P8_EN <= 0;
		  else
			 V1P8_EN <= V3P3_EN;
	  end

	always @ (posedge CLK)
	  begin
		  if (stby_on_sreg[0])
			 V1P05_EN <= 1;
		  else if (stby_off_sreg[2])
			 V1P05_EN <= 0;
		  else
			 V1P05_EN <= V3P3_EN;
	  end
			
	// Sequence voltages S3 to S0
	// V3P3_S. Ton = 45us; Toff = 139us
	// V1P05_S. Ton = 1ms; Toff = 200us
	// VNN_S, VCC_S. Ton = 1.1ms; Toff = 820us
	// V1P8_S. Ton = 78us; Toff = 181us
	// V1P5_S. Ton = 100us; Toff = 200us
	// Ramp up sequence = V3P3_S->V1P5_S->V1P05_S,VNN_S->V1P8_S,V0P9_S->V1P25_S->VCC_S
	
	
	// Shift register
	always @ (posedge CLK)
	  full_on_sreg[31:0] <= {slp_s3_n_redge, full_on_sreg[31:1]};
		
	always @ (posedge CLK)
	  full_off_sreg[5:0] <= {slp_s3_n_fedge, full_off_sreg[5:1]};


	
	always @ (posedge CLK)
	  begin
		  if (full_on_sreg[31])
			 V3P3_S_EN <= 1;
		  else if (full_off_sreg[0])
			 V3P3_S_EN <= 0;
		  else
			 V3P3_S_EN <= V3P3_S_EN;
	  end

	always @ (posedge CLK)
	  begin
		  if (full_on_sreg[30])
			 V1P5_S_EN <= 1;
		  else if (full_off_sreg[3])
			 V1P5_S_EN <= 0;
		  else
			 V1P5_S_EN <= V1P5_S_EN;
	  end
	
	always @ (posedge CLK)
	  begin
		  if (full_on_sreg[7])
			 V1P05_S_EN <= 1;
		  else if (full_off_sreg[1])
			 V1P05_S_EN <= 0;
		  else
			 V1P05_S_EN <= V1P05_S_EN;
	  end

	always @ (posedge CLK)
	  begin
		  if (full_on_sreg[7])
			 VNN_S_EN <= 1;
		  else if (full_off_sreg[2])
			 VNN_S_EN <= 0;
		  else
			 VNN_S_EN <= VNN_S_EN;
	  end
	
	always @ (posedge CLK)
	  begin
		  if (full_on_sreg[5])
			 V1P8_S_EN <= 1;
		  else if (full_off_sreg[4])
			 V1P8_S_EN <= 0;
		  else
			 V1P8_S_EN <= V1P8_S_EN;
	  end
	assign V0P9_S_EN = V1P8_S_EN;
	
	always @ (posedge CLK)
	  begin
		  if (full_on_sreg[0])
			 VCC_S_EN <= 1;
		  else if (full_off_sreg[5])
			 VCC_S_EN <= 0;
		  else
			 VCC_S_EN <= VCC_S_EN;
	  end
	
			
endmodule // vr_seqcr



	
	
		  
	
	
