/**********************************************************************
Copyright 2013 Intel Corporation

All rights reserved. 

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met: 

* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.  

* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the
  distribution. 

* Neither the name of the Intel Corporation nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission. 


THIS SOFTWARE IS PROVIDED BY INTEL CORPORATION "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL INTEL CORPORATION OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************/



#include <stdint.h>

typedef struct _sAesData {
    uint8_t *inbuf;
    uint8_t *outbuf;
    uint8_t *keysched;
    uint8_t *iv;
    uint64_t numblocks;
} sAesData;

typedef struct _sAesData_x8 {
    uint8_t *inbuf[8];
    uint8_t *outbuf[8];
    uint8_t *keysched;
    uint8_t *iv[8];
    uint64_t numblocks;
} sAesData_x8;

// Multi-buffer: The same key is applied to all streams
void aes_cbc_enc_128_x8(sAesData_x8 *args);
void aes_cbc_enc_192_x8(sAesData_x8 *args);
void aes_cbc_enc_256_x8(sAesData_x8 *args);

// Single Buffer:
void iDec128_CBC_by8(sAesData *data);
void iDec192_CBC_by8(sAesData *data);
void iDec256_CBC_by8(sAesData *data);

// Key Expansion:
void aes_keyexp_128_enc(uint8_t *key, uint8_t *enc_exp_keys);
void aes_keyexp_192_enc(uint8_t *key, uint8_t *enc_exp_keys);
void aes_keyexp_256_enc(uint8_t *key, uint8_t *enc_exp_keys);
void aes_keyexp_128_dec(uint8_t *key, uint8_t *dec_exp_keys);
void aes_keyexp_192_dec(uint8_t *key, uint8_t *dec_exp_keys);
void aes_keyexp_256_dec(uint8_t *key, uint8_t *dec_exp_keys);
