# FORCE_EFI_BOOT

echo -off
# +
# + ============================================================== +
#  Copyright (c) 2013, Intel Corporation.

#  This source code and any documentation accompanying it ("Material") is furnished
#  under license and may only be used or copied in accordance with the terms of that
#  license.  No license, express or implied, by estoppel or otherwise, to any
#  intellectual property rights is granted to you by disclosure or delivery of these
#  Materials.  The Materials are subject to change without notice and should not be
#  construed as a commitment by Intel Corporation to market, license, sell or support
#  any product or technology.  Unless otherwise provided for in the license under which
#  this Material is provided, the Material is provided AS IS, with no warranties of
#  any kind, express or implied, including without limitation the implied warranties
#  of fitness, merchantability, or non-infringement.  Except as expressly permitted by
#  the license for the Material, neither Intel Corporation nor its suppliers assumes
#  any responsibility for any errors or inaccuracies that may appear herein.  Except
#  as expressly permitted by the license for the Material, no part of the Material
#  may be reproduced, stored in a retrieval system, transmitted in any form, or
#  distributed by any means without the express written consent of Intel Corporation.

#  Module Name:  startup.nsh

#  Abstract:  Script file for invoking iflash.

# + ============================================================== +
#    Program all blocks of BIOS from capsule file 
# + ============================================================== +

@echo -off
mode 80 25
;foundimage section is simply to locate the correct drive
cls
if exist .\ipmi.efi then
 goto FOUNDIMAGE
endif
if exist fs0:\ipmi.efi then
 fs0:
 echo Found Update Packages on fs0:
 goto FOUNDIMAGE
endif
if exist fs1:\ipmi.efi then
 fs1:
 echo Found Update Packages on fs1:
 goto FOUNDIMAGE
endif
if exist fs2:\ipmi.efi then
 fs2:
 echo Found Update Packages on fs2:
 goto FOUNDIMAGE
endif
 echo "Unable to find Update Packages".  
 echo "Please mount the drive with the update package".
 echo ""
 goto END
:FOUNDIMAGE

echo "==============================================================================="

echo "This script will install BMC, BIOS, ME firmware, and FRUSDR in the"
echo "Intel(R) Server Board S2400EP or Intel(R) Server System R1000EP"
echo ""
echo "You can use other scripts such as BIOS.nsh to update each component separately."
echo ""
echo "================================== IMPORTANT =================================="
echo "Please ensure your server system is on BIOS 01.01.2002, BMC 1.00, ME 2.1.5.69 "
echo "and FRUSDR 09 or above these versions, otherwise the update process may "
echo "render the system not operatable! If you are not sure about the versions,"
echo "hit 'q' and reboot into BIOS to verify."
echo "================================== IMPORTANT =================================="
echo ""

echo "The update process will install following BMC/BIOS/ME/FRUSDR on your system:"
echo "       BMC 1.17;"
echo "       BIOS 01.08.0003;"
echo "       ME Firmware 2.1.7.112;"
echo "       FRUSDR 1.02"
echo ""
echo "Do NOT reboot during this process until you see Updates completed."
echo "==============================================================================="
pause

BMC01174151.nsh

BIOS01080003.nsh

ME020107112.nsh

FRUSDR102.nsh


:END

