#!/bin/sh
# snmpsubagent_uninstall.sh

# unalias following commands from any previous one

unalias echo 2>/dev/null
unalias grep 2>/dev/null
unalias rpm 2>/dev/null
unalias rm 2>/dev/null
unalias uname 2>/dev/null

answer="N"

SNMP_SA=`rpm -q snmpsa`
if [ $? -eq 1 ]; then
	echo "Intel(R) SNMP Subagent is not installed."
	exit 1
fi

function delcronjob
{
   crontab -l | grep -v "/usr/local/snmpsa/snmpsa_watchdog.sh" > /tmp/__snmpsacronjoblist__
   crontab /tmp/__snmpsacronjoblist__
   rm -f /tmp/__snmpsacronjoblist__
}

echo "Uninstalling Intel(R) SNMP Subagent..."

rpm -ev snmpsa
# Dont uninstall CacheRiver if APPCORE is present
# APPCORE is used by MSM and IASC
ASC=`rpm -qa | grep APPCORE`

if [ $? -eq 1 ]; then 
   rpm -ev CacheRiver
fi

NET_SNMP=`rpm -qa | grep "net-snmp-5.1.4-0.1.isms"`
if [ -n "${NET_SNMP}" ]; then
	echo "Found ISMS net-snmp-5.1.4-0.1.isms RPMS."
	echo -n "Would you like to uninstall them? (Enter 'y' to continue or any other key to leave them installed.) "
	read answer
	answer=`echo ${answer} | tr a-z A-Z `
	if [ "${answer}" = "Y" ]; then
		echo "Uninstalling, please wait..."

		if [ -f "/etc/SuSE-release" ]; then
			NET_SNMP_PERL=`rpm -qa | grep -i "perl-SNMP" | grep "isms"`
		else
			NET_SNMP_PERL=`rpm -qa | grep -i "net-snmp-perl" | grep "isms"`
		fi
		NET_SNMP_UTILS=`rpm -qa | grep -i "net-snmp-utils" | grep "isms"`
		NET_SNMP_DEVEL=`rpm -qa | grep -i "net-snmp-devel" | grep "isms"`
		NET_SNMP_LIBS=`rpm -qa | grep -i "net-snmp-libs" | grep "isms" | sort -u`
		if [ -n "${NET_SNMP_PERL}" ]; then
			rpm -e --nodeps ${NET_SNMP_PERL}
			echo "Uninstalled "${NET_SNMP_PERL}
		fi

		if [ -n "${NET_SNMP_DEVEL}" ]; then
			rpm -e --nodeps ${NET_SNMP_DEVEL}
			echo "Uninstalled "${NET_SNMP_DEVEL}
		fi

		if [ -n "${NET_SNMP_UTILS}" ]; then
			rpm -e --nodeps ${NET_SNMP_UTILS}
			echo "Uninstalled "${NET_SNMP_UTILS}
		fi

		if [ -n "${NET_SNMP}" ]; then
			rpm -e --nodeps ${NET_SNMP}
			echo "Uninstalled "${NET_SNMP}
		fi

		if [ -n "${NET_SNMP_LIBS}" ]; then
			rpm -e --nodeps --allmatches ${NET_SNMP_LIBS}
			echo "Uninstalled "${NET_SNMP_LIBS}
		fi
	fi
fi

# Check if RedHat  / SUSE
if [ -f "/etc/SuSE-release" ]  
	then
	## Check for SLES 10
	grep "VERSION *= *10" /etc/SuSE-release > /dev/null 2>&1
	if [ $? -eq 0 ]; then
		## Check for 32 / x64
		uname -m|grep x86_64 > /dev/null 2>&1
		if [ $? -eq 0 ]; then
			## Remove symlinks created during installation.
			if [ -h "/usr/lib64/librpm-4.1.so" ]
				then
				rm -f /usr/lib64/librpm-4.1.so
				rm -f /usr/lib64/librpmdb-4.1.so
				rm -f /usr/lib64/librpmio-4.1.so
			fi
			if [ -h "/usr/lib64/libnetsnmpagent.so.5" ]  
				then
				rm -f /usr/lib64/libnetsnmpagent.so.5
				rm -f /usr/lib64/libnetsnmphelpers.so.5
				rm -f /usr/lib64/libnetsnmpmibs.so.5
				rm -f /usr/lib64/libnetsnmp.so.5				
				rm -f /usr/lib64/libsnmp.so.5
				rm -f /usr/lib64/libnetsnmptrapd.so.5
			fi
		else
			## Remove symlinks created during installation.
			if [ -h "/usr/lib/librpm-4.1.so" ]
				then
				rm -f /usr/lib/librpm-4.1.so
				rm -f /usr/lib/librpmdb-4.1.so
				rm -f /usr/lib/librpmio-4.1.so
			fi
			if [ -h "/usr/lib/libnetsnmpagent.so.5" ]  
				then	
				rm -f /usr/lib/libnetsnmpagent.so.5
				rm -f /usr/lib/libnetsnmphelpers.so.5
				rm -f /usr/lib/libnetsnmpmibs.so.5
				rm -f /usr/lib/libnetsnmp.so.5
				rm -f /usr/lib/libsnmp.so.5
				rm -f /usr/lib/libnetsnmptrapd.so.5
			fi
		fi
	else
		## SLES 9
		uname -m|grep x86_64 > /dev/null 2>&1
		if [ $? -eq 0 ]; then
			## Remove symlinks created during installation.			
			if [ -h "/usr/lib64/libnetsnmpagent.so.5" ] && [ "${answer}" = "Y" ]; then
				rm -f /usr/lib64/libnetsnmpagent.so.5
				rm -f /usr/lib64/libnetsnmphelpers.so.5
				rm -f /usr/lib64/libnetsnmpmibs.so.5
				rm -f /usr/lib64/libnetsnmp.so.5				
				rm -f /usr/lib64/libsnmp.so.5
				rm -f /usr/lib64/libnetsnmptrapd.so.5
			fi
		else
			## Remove symlinks created during installation.
			if [ -h "/usr/lib/libnetsnmpagent.so.5" ] && [ "${answer}" = "Y" ]; then
	
				rm -f /usr/lib/libnetsnmpagent.so.5
				rm -f /usr/lib/libnetsnmphelpers.so.5
				rm -f /usr/lib/libnetsnmpmibs.so.5
				rm -f /usr/lib/libnetsnmp.so.5
				rm -f /usr/lib/libsnmp.so.5
				rm -f /usr/lib/libnetsnmptrapd.so.5
			fi
		fi
	fi
else
	# Check RHEL Version
	RH_RELEASE=`rpm -q redhat-release`
	if [[ $RH_RELEASE == redhat-release-5Server* ]]
		then
		#Check if EM64T
		ARCH=`uname -m|grep x86_64 > /dev/null 2>&1`
		if [ $? = 0 ]
			then
			#remove softlinks for librpm-4.2(64) created during installation
			if [ -h "/usr/lib64/librpm-4.2.so" ]
				then
				rm -f /usr/lib64/librpm-4.2.so
				rm -f /usr/lib64/librpmdb-4.2.so
				rm -f /usr/lib64/librpmio-4.2.so
			fi
			if [ -h "/lib64/libcrypto.so.4" ]
				then
				rm -f /lib64/libcrypto.so.4
			fi
			if [ -h "/usr/lib64/libnetsnmpagent.so.5" ] 
		       		then
				rm -f /usr/lib64/libnetsnmpagent.so.5
				rm -f /usr/lib64/libnetsnmphelpers.so.5
				rm -f /usr/lib64/libnetsnmpmibs.so.5
				rm -f /usr/lib64/libnetsnmp.so.5				
				rm -f /usr/lib64/libsnmp.so.5
				rm -f /usr/lib64/libnetsnmptrapd.so.5

				#Attempt removing softlinks for 32 bit as well.
				rm -f /usr/lib/libnetsnmpagent.so.5
				rm -f /usr/lib/libnetsnmphelpers.so.5
				rm -f /usr/lib/libnetsnmpmibs.so.5
				rm -f /usr/lib/libnetsnmp.so.5
				rm -f /usr/lib/libnetsnmptrapd.so.5
			fi
		else
			#remove softlinks for librpm-4.2(32) created during installation
			if [ -h "/usr/lib/librpm-4.2.so" ]
				then
				rm -f /usr/lib/librpm-4.2.so
				rm -f /usr/lib/librpmdb-4.2.so
				rm -f /usr/lib/librpmio-4.2.so
			fi
			if [ -h "/lib/libcrypto.so.4" ]
				then
				rm -f /lib/libcrypto.so.4
			fi
			if [ -h "/usr/lib/libnetsnmpagent.so.5" ] 
				then	
				rm -f /usr/lib/libnetsnmpagent.so.5
				rm -f /usr/lib/libnetsnmphelpers.so.5
				rm -f /usr/lib/libnetsnmpmibs.so.5
				rm -f /usr/lib/libnetsnmp.so.5
				rm -f /usr/lib/libsnmp.so.5
				rm -f /usr/lib/libnetsnmptrapd.so.5
			fi
		fi
	elif [[ $RH_RELEASE == redhat-release-4AS* ]]
		then
		#Check if EM64T
		ARCH=`uname -m|grep x86_64 > /dev/null 2>&1`
		if [ $? = 0 ]
			then
			#remove softlinks for librpm-4.2(64) created during installation
			if [ -h "/usr/lib64/librpm-4.2.so" ]
				then
				rm -f /usr/lib64/librpm-4.2.so
				rm -f /usr/lib64/librpmdb-4.2.so
				rm -f /usr/lib64/librpmio-4.2.so
			fi
		else
			#remove softlinks for librpm-4.2(32) created during installation
			if [ -h "/usr/lib/librpm-4.2.so" ]
				then
				rm -f /usr/lib/librpm-4.2.so
				rm -f /usr/lib/librpmdb-4.2.so
				rm -f /usr/lib/librpmio-4.2.so
			fi
		fi
	fi
fi

#stop service monitor
#delcronjob

rm -rf /usr/share/snmp/mibs/basebrd7*

rm -rf /usr/local/snmpsa

echo "Intel(R) SNMP Subagent uninstallation complete!"
exit 0
