/******************************************************************************
*
*                   INTEL CORPORATION PROPRIETARY INFORMATION
*       This software is supplied under the terms of a license agreement or
*       nondisclosure agreement with Intel Corporation and may not be copied
*       or disclosed except in accordance with the terms of that agreement.
*
*            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
*
*       All rights reserved.  No part of this program or publication may be
*       reproduced, transmitted, transcribed, stored in a retrieval system,
*       or translated into any language or computer language, in any form or
*       by any means, electronic, mechanical, magnetic, optical, chemical,
*       manual, or otherwise, without the prior written permission of Intel
*       Corporation.
*
*
*******************************************************************************/
/// \ingroup _common_ 
/// \defgroup _types_ Type Definitions
/// \{ 

//The types.h header file will define standard data types and include standard header files.
//The differences in datatypes / header files on different operating systems and platforms
//will be handled through macros.
#ifndef _common_types_h_ //Header Guard
#define _common_types_h_

//////////////////// Common ////////////////////////

//Header Files
#include "boost/shared_ptr.hpp"

#include<vector>
#include<map>

/////////////////// WINDOWS ////////////////////////
//#ifndef CR_WIN
//#define CR_WIN
//#endif

#ifdef CR_WIN

//#ifndef _WINDOWS_
#include <windows.h>
//#endif

#ifdef _CLASSINDLL
#define CLASSINDLL_CLASS_DECL __declspec(dllexport)
#else
#define CLASSINDLL_CLASS_DECL __declspec(dllimport)
#define snprintf sprintf_s 
#endif

//Headers
#include<hash_map>
//Namespaces
using namespace stdext;
#define _CRT_SECURE_NO_DEPRECATE

//Macros
#define DllExport __declspec(dllexport)
#else
#define CLASSINDLL_CLASS_DECL
#endif

/////////////////// LINUX //////////////////////////
#ifdef LINUX

//Headers
#include<ext/hash_map>
#include "sys/mman.h"
#include "sys/ioctl.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dlfcn.h>
#include <sys/io.h>
//Namespaces
namespace __gnu_cxx {
	template <>
		struct hash<std::string> {
			size_t operator() (const std::string & myString) const
			{
				return hash < const char * > ()(myString.c_str());
			}
		};
}
using namespace __gnu_cxx;

//Macros
#define DllExport
typedef void* HANDLE;
#endif

//Namespaces
using namespace std;
using namespace boost;

//Typedefs

#ifndef CR_WIN
typedef unsigned long UINTN;
typedef unsigned long UINT32;	
typedef unsigned short WCHAR ;	
typedef unsigned long long ULONG;
#else
typedef unsigned long UINTN;
#endif
typedef unsigned char UINT8;
typedef unsigned short UINT16;
typedef char CHAR;

typedef wstring UNICODE_STR;
typedef shared_ptr<UINT8> BYTE_PTR;
typedef shared_ptr<void> VOID_PTR;
#ifndef CR_WIN
typedef void VOID;
#endif
typedef std::map<int,string> ErrorStringMap;
typedef unsigned long long ULONGLONG;
typedef std::vector<std::string> StringVector;
typedef enum _NODE_TYPE
{
	NODE_LEAF = 0,
	NODE_NONLEAF
} NODE_TYPE;

struct _XNode;
typedef struct _XNode XNode;
typedef std::string XToken;
typedef std::vector<XToken> XTokenList;
typedef std::map<string, XNode> ResultMap;
typedef std::map<string, string> XSettingMap;

struct _XNode {

	NODE_TYPE mType;
	XTokenList mXNodeList;
	_XNode()
		: mXNodeList()
	{}
	~_XNode()
	{
		mXNodeList.clear();
	}
};


typedef hash_map<string, string> STRING_STRING_MAP;
typedef hash_map<string, vector<string> > STRING_VECTOR_STRING_MAP;
typedef hash_map<string, STRING_STRING_MAP> STRING_STRING_STRING_MAP;
typedef hash_map<string, STRING_VECTOR_STRING_MAP> STRING_STRING_VECTOR_STRING_MAP;

typedef struct _RESULT {
	NODE_TYPE type;
	vector<string> values;
} RESULT;

typedef hash_map<string, RESULT> STRING_RESULT_MAP;

typedef enum _FN_NAME {
	FN_IPMI,
	FN_IPMI_RESPONSE,
	FN_LOOKUP_TABLE,
	FN_XNODE_STORE,
	FN_XNODE_COPY,
	FN_XNODE_APPEND,
	FN_TEMPLATE,
	FN_SET,
	FN_MAP,
	FN_MASK,
	FN_CONDITION,
	FN_LOOP,
	FN_FORMAT_STRING,
	FN_SPLIT,
    FN_JOIN, 
    FN_PAD, 
    FN_CONVERT,
	FN_END
} FN_NAME;

#define _GET_TEMPLATE    "get_template://"
#define _SET_TEMPLATE    "set_template://"
#define _GET_FILTER      "get_filter://"
#define _SET_FILTER      "set_filter://"
#define _GET_TABLE       "get_table://"
#define _SET_TABLE       "set_table://"
#define _GET_IPMI        "get_ipmi://"
#define _SET_IPMI        "set_ipmi://"

#define _STRING_VECTOR_STRING_MAP "string_vector_string://"
#define _STRING_STRING_STRING_MAP "string_string_string://"
#define _VECTOR_STRING            "vector_string://"
#define _TEMPLATE                 "template://"
#define _SYMBOL                   "symbol://"
#define _VALUE                    "value://"
#define _RESULT                   "result://"

#define IPMI_MAX_BUFFER  255
#define DECIMAL_RANGE    "0123456789"
#define _OP_EQUAL_TO     "="
#define _OP_NOTEQUAL_TO  "!="

#define UNSUPPORTED      "UNSUPPORTED"

#define HEX2DEC          "HEX2DEC"
#define DEC2HEX          "DEC2HEX"
#define HEX2STR          "HEX2STR"
#define STR2HEX          "STR2HEX"
#define BIT_OR           "BIT_OR"
#define MASK             "MASK"
#define LEFT_SHIFT   "LEFT_SHIFT"
#define RIGHT_SHIFT   "RIGHT_SHIFT"
#define RIGHT_SHIFT_MASK "RIGHT_SHIFT_MASK"
#define SYMBOL_TO_VECTOR_STRING "SYMBOL_TO_VECTOR_STRING"
#define VECTOR_STRING_TO_SYMBOL "VECTOR_STRING_TO_SYMBOL"

#endif //END OF HEADER GUARD
