#ifndef _CFG_FILE_DATA_H_
#define _CFG_FILE_DATA_H_

#include <modules/bmc/update/UpdateCallBackBase.h>

#ifdef CR_EFI
TYPEDEF_VECTOROF(VECTOROF_STRING, VecStringArrayType);
#endif

struct CFG_var
{
		WCHAR *CfgFilename;
		int proc_no;
		VECTOROF_STRING product;
#ifndef CR_EFI
		VECTOROF_STRING proc_info[10];
		VECTOROF_STRING proc_cores[10];
		VECTOROF_STRING proc_family[10];
		VECTOROF_STRING cpuid[10];
#else
		VecStringArrayType proc_info;
		VecStringArrayType proc_cores;
		VecStringArrayType proc_family;
		VecStringArrayType cpuid;
#endif
		UINT32 hsc_primary_product_id;
		UINT32 hsc_secondary_product_id;
		Module::Update::UpdateCallBackBase *callBackPtr;

#ifdef CR_EFI
		void Initialize(void) {
			callBackPtr = NULL;
			CfgFilename = NULL;
			proc_info.resize(10);
			proc_cores.resize(10);
			cpuid.resize(10);
			proc_family.resize(10);
		}
#endif

		//Constructor
		CFG_var() {
			callBackPtr = NULL;
			CfgFilename = NULL;
		}
};
#endif

