	/******************************************************************************
	*
	*                   INTEL CORPORATION PROPRIETARY INFORMATION
	*       This software is supplied under the terms of a license agreement or
	*       nondisclosure agreement with Intel Corporation and may not be copied
	*       or disclosed except in accordance with the terms of that agreement.
	*
	*            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
	*
	*       All rights reserved.  No part of this program or publication may be
	*       reproduced, transmitted, transcribed, stored in a retrieval system,
	*       or translated into any language or computer language, in any form or
	*       by any means, electronic, mechanical, magnetic, optical, chemical,
	*       manual, or otherwise, without the prior written permission of Intel
	*       Corporation.
	*
	*
	*******************************************************************************/
#ifndef __INTEL_HEX_FILE_H_
#define __INTEL_HEX_FILE_H_

#ifndef CR_EFI
#include <iostream>
#endif

#include <os/include/cr_osal.h>

#include "UpdateCallBackBase.h"

//using namespace Module::BMCConfig;

namespace Module
{
    namespace IntelHexFile_NS
    {

#ifndef MICROCONTROLLER_VSC
#define MICROCONTROLLER_VSC                 "VSC"
#endif

#ifndef MICROCONTROLLER_BMC
#define MICROCONTROLLER_BMC                 "BMC"
#endif

#ifndef MICROCONTROLLER_LCP
#define MICROCONTROLLER_LCP                 "LCP"
#endif

#ifndef MICROCONTROLLER_ME
#define MICROCONTROLLER_ME                 "ME"
#endif

        typedef enum IntelFwControllerDefaultAddress{
            BMC_PRIMARY_DEVICE_ADDRESS      = 0x20,
            ME_PRIMARY_DEVICE_ADDRESS       = 0x2C,
            HSC_PRIMARY_DEVICE_ADDRESS      = 0xC0,
            HSC_SECONDARY_DEVICE_ADDRESS    = 0xC2,
	    LCP_DEVICE_ADDRESS              = 0x22
        } FwControllerDefaultAddress;

        typedef enum IntelFwController {

            FW_CONTROLLER_START = 0,
            BMC_FW_CONTROLLER,
            HSC_FW_CONTROLLER,
            LCP_FW_CONTROLLER,
            ME_FW_CONTROLLER,
            FW_CONTROLLER_END
        } IntelFwController;

        typedef enum IntelFwUpdateOptions{

            FW_UPDATE_START = 0,
            FW_UPDATE_SET_DEFAULTS = (1<<0),
            FW_UPDATE_NO_PLATFORM_CHECK = (1<<1),
            FW_UPDATE_NO_DOWN_REVISION = (1<<2),
            FW_UPDATE_BOOT_AREA = (1<<3),
            FW_UPDATE_OPCODE_AREA = (1<<4),
            FW_UPDATE_PIA_AREA = (1<<5),
            FW_UPDATE_PRIMARY_CONTROLLER = (1<<6),
            FW_UPDATE_SECONDARY_CONTROLLER = (1<<7),
            FW_UPDATE_UPDATE_AND_VERIFY = (1<<8),
            FW_UPDATE_JUST_VERIFY = (1<<9),
            FW_UPDATE_TURBO_MODE = (1<<10),
            FW_UPDATE_SHOW_INVENTORY = (1<<11),
            FW_UPDATE_JUST_UPLOAD = (1<<12),
            FW_UPDATE_BIN_FILE = (1<<13),
			FW_UPDATE_RMM_AREA = (1<<14),
			FW_UPDATE_BY_SEGMENT = (1<<15),
            FW_UPDATE_RESTART_BOOT = (1<<16),
            FW_UPDATE_FORCE_UPDATE = (1<<17)

        }IntelFwUpdateOptions;

        typedef class IntelHexFile {
        //Public member functions go here.
        public:
                IntelHexFile(STRING hexFile = "",
                UINT8 address = 0,
                IntelFwController fwCntrlr = FW_CONTROLLER_START,
                UINT32 fw_update_flags = FW_UPDATE_START,
                UINT16 bufferSize=0)
                :devAddress(address),
                 m_bufferSize(bufferSize)
                {
                    /* Set the FW controller, by default it will
                       be set to BMC FW Controller */
                    this->fwCntrlr = fwCntrlr;
                    if (FW_CONTROLLER_START == this->fwCntrlr)
                        this->fwCntrlr = BMC_FW_CONTROLLER;

                    setFwUpdateFlags(fw_update_flags);

                    intelHexFile = hexFile;

                    ptrCallBackBase = (Module::Update::UpdateCallBackBase*) NULL;
                }

                ~IntelHexFile() {
#ifdef DISPLAY_INFO
                     cout << "IntelHexFile destructor called."<<endl;
#endif
                     defaultsSet                =
                     updateTurboMode            =
                     updateVerify               =
                     justUpdate                 =
                     justVerify                 =
                     platFormCheck              =
                     allowDownRevision          =
                     bootAreaUpdate             = 
                     opCodeAreaUpdate           = 
                     piaAreaUpdate              =
					 rmmAreaUpdate				=
					 updateBySegment			=
                     primaryControllerUpdate    = 
                     platFormCheck              = 
                     showInventory              =
                     binFileUpdate              =
                     restartBoot                =
                     forceUpdate                =
                     secondaryControllerUpdate  = false;

                     fwCntrlr = FW_CONTROLLER_START;
                     m_bufferSize = 0;
                }
				void Init(STRING hexFile = "",UINT8 address = 0,
                IntelFwController fwCntrlr = FW_CONTROLLER_START,
                UINT32 fw_update_flags = FW_UPDATE_START,
                UINT16 bufferSize=0)
                
                {
                    devAddress = address;
                 m_bufferSize= bufferSize;
					/* Set the FW controller, by default it will
                       be set to BMC FW Controller */
                    this->fwCntrlr = fwCntrlr;
                    if (FW_CONTROLLER_START == this->fwCntrlr)
                        this->fwCntrlr = BMC_FW_CONTROLLER;

                    setFwUpdateFlags(fw_update_flags);

                    intelHexFile = hexFile;

                    ptrCallBackBase = (Module::Update::UpdateCallBackBase*) NULL;
                }
               void setDevAddress(UINT8 address) {devAddress = address;}
               void setDefaults(void) { defaultsSet = true; }
               void setUpdateTurboMode(void) { updateTurboMode = true; }
               void setUpdateVerify(void) { updateVerify = true; }
               void setJustUpdate(void) { justUpdate = true; }
               void setJustVerify(void) { justVerify = true; }
               void setBootAreaUpdate(void) {bootAreaUpdate = true;}
               void setOpCodeAreaUpdate(void) {opCodeAreaUpdate = true;}
               void setPiaAreaUpdate(void) {piaAreaUpdate = true;}
               void setShowInventoryFlag(void) {showInventory = true;}
               void setBinFileUpdateFlag(void) {binFileUpdate = true;}
			   void setRmmAreaUpdate(void) {rmmAreaUpdate = true;}
			   void setUpdateBySegment(void) {updateBySegment = true;}
			   void setRestartBootFlag(void) {restartBoot = true;}
			   void setForceUpdateFlag(void) {forceUpdate = true;}

               void setPrimaryControllerUpdate(void)   { primaryControllerUpdate = true; }
               void setSecondaryControllerUpdate(void) { secondaryControllerUpdate = true; }
               void setPlatFormCheck(void) { platFormCheck = true; }
               void setDownRevision(void) { allowDownRevision = true; }
               void setFwController(IntelFwController fwCntrlr) { this->fwCntrlr = fwCntrlr; }
			   void setCallBackClass(Module::Update::UpdateCallBackBase* ptrCallBackBase) {this->ptrCallBackBase = ptrCallBackBase;}

               STRING getHexFileName(void) const { return intelHexFile; }
               UINT8 getDevAddress(void) const {return devAddress;}
               UINT16 getBufferSize(void) const {return m_bufferSize;}
               bool getDefaults(void) const {return defaultsSet;}
               bool getUpdateTurboMode(void) const {return updateTurboMode;}
               bool getUpdateVerify(void) const {return updateVerify;}
               bool getJustUpdate(void) const {return justUpdate;}
               bool getJustVerify(void) const {return justVerify;}
               bool getBootAreaUpdate(void) const {return bootAreaUpdate;}
               bool getOpCodeAreaUpdate(void) const {return opCodeAreaUpdate;}
               bool getPiaAreaUpdate(void) const {return piaAreaUpdate;}
               bool getRmmAreaUpdate(void) const {return rmmAreaUpdate;}
               bool getUpdateBySegment(void) const {return updateBySegment;}
               bool getShowInventoryFlag(void) const {return showInventory;}
               bool getBinFileUpdateFlag(void) const {return binFileUpdate;}
               bool getRestartBootFlag(void) const {return restartBoot;}
               bool getForceUpdateFlag(void) const {return forceUpdate;}

               bool getPrimaryControllerUpdate(void)   const { return primaryControllerUpdate; }
               bool getSecondaryControllerUpdate(void) const { return secondaryControllerUpdate; }
               bool getPlatFormCheck(void) const { return platFormCheck; }
               bool getDownRevision(void) const { return allowDownRevision; }
               IntelFwController getFwController(void) const { return this->fwCntrlr; }
               Module::Update::UpdateCallBackBase* getCallBackClass(void) const { return this->ptrCallBackBase; }

        //Private member functions go here.
        private:
               void setFwUpdateFlags(UINT32 flags) {
                   defaultsSet = 
                   (flags&FW_UPDATE_SET_DEFAULTS) ?  true:false;

                   updateVerify = 
                   (flags&FW_UPDATE_UPDATE_AND_VERIFY) ?  true:false;

                   justUpdate  =
                   (flags&FW_UPDATE_JUST_UPLOAD) ?  true:false;

                   justVerify = 
                   (flags&FW_UPDATE_JUST_VERIFY) ?  true:false;

                   platFormCheck = 
                   (flags&FW_UPDATE_NO_PLATFORM_CHECK) ? false:true;

                   allowDownRevision = 
                   (flags&FW_UPDATE_NO_DOWN_REVISION) ? false:true;

                   bootAreaUpdate = 
                   (flags&FW_UPDATE_BOOT_AREA) ?  true:false;

                   opCodeAreaUpdate = 
                   (flags&FW_UPDATE_OPCODE_AREA) ?  true:false;

                   piaAreaUpdate = 
                   (flags&FW_UPDATE_PIA_AREA) ?  true:false;

				   rmmAreaUpdate = 
                   (flags&FW_UPDATE_RMM_AREA) ?  true:false;

				   updateBySegment = 
                   (flags&FW_UPDATE_BY_SEGMENT) ?  true:false;

                   primaryControllerUpdate = 
                   (flags&FW_UPDATE_PRIMARY_CONTROLLER) ?  true:false;

                   secondaryControllerUpdate = 
                       (flags&FW_UPDATE_SECONDARY_CONTROLLER) ?  true:false;

                   updateTurboMode = 
                       (flags&FW_UPDATE_TURBO_MODE) ?  true:false;

                   showInventory = 
                       (flags&FW_UPDATE_SHOW_INVENTORY) ?  true:false;

                   binFileUpdate = 
                       (flags&FW_UPDATE_BIN_FILE) ?  true:false;

                   restartBoot = 
                       (flags&FW_UPDATE_RESTART_BOOT) ?  true:false;

                   forceUpdate = 
                       (flags&FW_UPDATE_FORCE_UPDATE) ?  true:false;

                   //Make sure if justUpdate is set updateVerify is cleared.
                   if (justUpdate == true)
                   {
                       updateVerify = false;
                   }
               }//end of setFwUpdateFlags()

        //Private member variables go here.
        private:
            STRING intelHexFile;
            UINT8  devAddress;
            UINT16 m_bufferSize;
            bool  updateTurboMode;
            bool  updateVerify;
            bool  justUpdate;
            bool  justVerify;
            bool  defaultsSet;
            bool  bootAreaUpdate;
            bool  opCodeAreaUpdate;
            bool  piaAreaUpdate;
            bool  primaryControllerUpdate;
            bool  secondaryControllerUpdate;
            bool  platFormCheck;
            bool  allowDownRevision;
            bool  showInventory;
            bool  binFileUpdate;
	        bool  rmmAreaUpdate;
	        bool  updateBySegment;
	        bool  restartBoot;
	        bool  forceUpdate;
            IntelFwController fwCntrlr;
            Module::Update::UpdateCallBackBase* ptrCallBackBase;
        }IntelHexFile;
    }//end of namespace IntelHexFile_NS

}//end of namespace Module
 
#endif // __INTEL_HEX_FILE_H_
