/******************************************************************************
*
*                   INTEL CORPORATION PROPRIETARY INFORMATION
*       This software is supplied under the terms of a license agreement or
*       nondisclosure agreement with Intel Corporation and may not be copied
*       or disclosed except in accordance with the terms of that agreement.
*
*            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
*
*       All rights reserved.  No part of this program or publication may be
*       reproduced, transmitted, transcribed, stored in a retrieval system,
*       or translated into any language or computer language, in any form or
*       by any means, electronic, mechanical, magnetic, optical, chemical,
*       manual, or otherwise, without the prior written permission of Intel
*       Corporation.
*
*
*******************************************************************************/
#ifndef __CR_WCSTRING_H_
#define __CR_WCSTRING_H_

//FIXME:: Illyas
#undef NULL
#define NULL (wchar_t*)0

#include <stdlib.h>
#include <wchar.h>
#include <string.h>
#include "cr_allocator.h"

#ifdef EFI
extern "C" {
static size_t wcsnlen(const wchar_t *c, const size_t s) {
      return wcslen(c);
}
}
#endif

namespace osal_stl {


class cr_wcstring {

public:
    const static int WMAX_CR_STRING_LEN=268435454;
    const static int WMIN_CR_STRING_LEN=64;
    const static int WMAX_CR_LINE_LEN=1024;
    const static unsigned int WNPOS_LENGTH=4294967295U;

    typedef wchar_t value_type;
	typedef value_type *pointer;
	typedef const value_type *const_pointer;
	typedef value_type & reference;
	typedef const value_type & const_reference;
	typedef size_t size_type;
	typedef size_t difference_type;

	typedef const value_type *const_iterator;
	typedef value_type *iterator;

	typedef iterator InputIterator;

	typedef class reverse_iterator {
    public:
		typedef  cr_allocator<wchar_t> T;

        typedef cr_wcstring::iterator           iterator;
        typedef const iterator                  const_iterator;
        typedef cr_wcstring::value_type&          reference;
        typedef const cr_wcstring::value_type&    const_reference;
        typedef cr_wcstring::size_type          size_type;
        typedef cr_wcstring::difference_type    difference_type;

        reverse_iterator() {}

        explicit reverse_iterator(iterator& itr) : i(itr) {}

        reverse_iterator(const reverse_iterator& ritr) {
            const iterator itr = ritr.get_itr();
            i = itr;
        }

        ~reverse_iterator() {
        }

        inline reverse_iterator& operator= (const reverse_iterator& ritr) {
            const iterator itr = ritr.get_itr();
            i = itr;
            return *this;
        }
        
        inline reference operator*() const {
            iterator itr = i;
            return *(--itr);
        }

        inline reverse_iterator& operator++() {
            --i;
            return *this;
        }

        inline reverse_iterator operator++(int) {
            reverse_iterator tmp = *this;
            --i;
            return tmp;
        }

        inline reverse_iterator& operator--() {
            ++i;
            return *this;
        }

        inline reverse_iterator operator--(int) {
            reverse_iterator tmp = *this;
            ++i;
            return tmp;
        }

        inline reverse_iterator operator+(difference_type n) const {
            iterator tmp = (i - n);
            return reverse_iterator(tmp); 
        }

        inline reverse_iterator& operator+=(difference_type n) {
            i -= n;
            return *this;
        }

        inline reverse_iterator operator-(difference_type n) const {
            iterator tmp = (i+n);
            return reverse_iterator(tmp);
        }

        inline reverse_iterator& operator-=(difference_type n) {
            i += n;
            return *this;
        }

        inline reference operator[](difference_type n) const {
            return *(i+n);
        }

        inline const iterator get_itr(void) const {
        return (const iterator) i;
        }

    private:
        iterator i;
    }reverse_iterator;

	typedef const reverse_iterator const_reverse_iterator;

	static const size_type npos = (size_type) cr_wcstring::WNPOS_LENGTH;


	/* contructor */
	 cr_wcstring() {
#ifdef CR_USE_ALLOCATOR
	cr_alloc_ptr  = (cr_allocator<wchar_t>*) 0;
#endif
	    c_string = NULL;
	    aloc_capacity = 0;
	}			//default constructor
	/* contructor */ cr_wcstring(const wchar_t c) {
#ifdef CR_USE_ALLOCATOR
	cr_alloc_ptr  = (cr_allocator<wchar_t>*) 0;
#endif
	    c_string = NULL;
	    aloc_capacity = 0;
	    *this = c;
	}			//end of constructor
	/* constructor */
	    cr_wcstring(const cr_wcstring & s, size_t pos = 0, size_t n = npos)
	{
#ifdef CR_USE_ALLOCATOR
	cr_alloc_ptr  = (cr_allocator<wchar_t>*) 0;
#endif
	    c_string = NULL;
	    aloc_capacity = 0;
	    const wchar_t *t = s.c_str();
	    cat_str(t, pos, n);
	}

	/* constructor */
	cr_wcstring(const wchar_t *s, size_t pos = 0, size_t n = npos) {
#ifdef CR_USE_ALLOCATOR
	cr_alloc_ptr  = (cr_allocator<wchar_t>*) 0;
#endif		
	    c_string = NULL;
	    aloc_capacity = 0;
	    cat_str(s, pos, n);
	}

	/* operator += overloading */
	inline cr_wcstring & operator+=(const cr_wcstring & cstr1) {
	    cat_str(cstr1.c_str(), 0, cstr1.length());
	    return *this;
	}			//end of += overloading

	/* operator += overloading */
	inline cr_wcstring & operator+=(const wchar_t *cstr) {
	    cat_str(cstr, 0, npos);
	    return *this;
	}			//end of += overloading

	/* operator += overloading */
	inline cr_wcstring & operator+=(const wchar_t c) {
	    wchar_t t[4] = { 0 };
	    t[0] = c;
	    cat_str(t, 0, 1);
	    return *this;
	}			//end of += overloading

	/* operator = overloading */
	inline cr_wcstring & operator=(wchar_t c) {
	    if (c_string)
		c_string[0] = 0;

	    wchar_t t[4] = { 0 };
	    t[0] = c;
	    cat_str(t, 0, npos);

	    return *this;
	}			//end of = overloading

	/* operator = overloading */
	inline cr_wcstring & operator=(const wchar_t *cstr) {
	    if (c_string)
		c_string[0] = 0;

	    cat_str(cstr, 0, npos);

	    return *this;
	}			//end of = overloading

	/* operator = overloading */
	inline cr_wcstring & operator=(const cr_wcstring & cstr) {
	    if (c_string)
		c_string[0] = 0;

	    cat_str(cstr.c_str(), 0, npos);

	    return *this;
	}			//end of = overloading

	inline reference operator[] (size_t n) {
	    return at(n);
	}

	inline const_reference operator[] (size_type n) const {
	    const_iterator ci = begin();
	    if (c_string) {
		if (n < length()) {
		    return (const_reference) * (ci + n);
		} else {
		    return (const_reference) * ci;
		}
	    }

	    return (const_reference) * ci;
	}

	~cr_wcstring() {
#ifdef CR_USE_ALLOCATOR
			if (cr_alloc_ptr && cr_alloc_ptr->get_refCount() >= 1)
			{
				cr_alloc_ptr->dec_refCount();
			}
#endif
	    if (c_string) {
			#ifdef CR_USE_ALLOCATOR
			if(cr_alloc_ptr && cr_alloc_ptr->get_refCount() == 0)
			{
#endif
				if (!copyable)
				{
            free(c_string);
				}
            c_string = NULL;
            aloc_capacity = 0;
#ifdef CR_USE_ALLOCATOR
		}	
#endif
	}
	    }

	inline reference at(size_type n) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    iterator ci = begin();
	    if (c_string) {
		if (n < length()) {
		    return (reference) * (ci + n);
		} else {
		    return (reference) * ci;
		}
	    }

	    return (reference) * ci;
	}

	inline const wchar_t *c_str(void) const {
	    return c_string;
	} 
    
    inline const wchar_t *data(void) const {
	    return c_string;
	} 
    
    inline size_t size(void) {
	    return length();
	}

	inline size_t length(void) const {
	    size_t len = 0;
	    if (c_string) {
            len = wcsnlen(c_string, cr_wcstring::WMAX_CR_STRING_LEN);
	    }

	    return len;
	}

	inline bool empty(void) {
	    bool res = false;
	    if (length() == 0) {
		res = true;
	    }

	    return res;
	}

	inline const size_t max_size(void) {
	    return (size_t) cr_wcstring::WMAX_CR_STRING_LEN;
	}

	inline const size_t capacity(void) const {
	    return (size_t) ((aloc_capacity == 0) ? 0 : aloc_capacity - 1);
	}
	
    inline cr_wcstring substr(size_t pos = 0, size_t n = npos) const {
	    return cr_wcstring(*this, pos, n);
	}

	inline size_t copy(wchar_t *buf, size_t n = npos, size_t pos = 0) const {
	    size_t tn = 0;
	    if (buf != NULL && c_string != NULL) {
		size_t len = wcsnlen(c_string, cr_wcstring::WMAX_CR_STRING_LEN);
		if (pos <= len) {
		    if ((pos + n) <= len)
			tn = n;
		    else
			tn = len - pos;
		    wmemcpy(buf, c_string + pos, tn);
		}
	    }

	    return tn;
	}

	inline int compare(const wchar_t *s) const {
	    if (s != NULL && c_string != NULL) {
		return wcsncmp(c_string, s, cr_wcstring::WMAX_CR_STRING_LEN);
	    }

	    return -1;
	}

	inline int compare(const cr_wcstring & s) const {
	    return compare(s.c_str());
	}

	inline int compare(size_type pos, size_type n, const cr_wcstring & s) const {
	    cr_wcstring t;
	     t.assign(*this, pos, n);
	     return t.compare(s);
	}

	inline int compare(size_type pos, size_type n,
			   const cr_wcstring & s, size_type pos1,
			   size_type n1) const {
	    cr_wcstring t;
	     t.assign(*this, pos, n);
	    cr_wcstring t1;
	     t1.assign(s, pos1, n1);
	     return t.compare(t1);
	}

	inline int compare(size_type pos, size_type n, const wchar_t *s,
			   size_type len = npos) const {
	    cr_wcstring t;
	     t.assign(*this, pos, n);
	    cr_wcstring t1(s);
	    if (len > t1.length())
		 len = t1.length();
	     t1.resize(len);
	     return t.compare(t1);
	} 
    
    inline cr_wcstring & erase(size_t pos = 0, size_t n = npos) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    size_t len = 0;
	    if (c_string != NULL) {
		len = wcsnlen(c_string, cr_wcstring::WMAX_CR_STRING_LEN);
	    }

	    size_t rem;

	    if (pos <= len) {
		if ((pos + n) > len)
		    n = len - pos;

		rem = len - (pos + n);

		if (rem) {
		    wmemmove(c_string + pos, c_string + pos + n, rem);
		}

		c_string[(pos + rem)] = 0;
#ifdef CR_USE_ALLOCATOR
	 if(cr_alloc_ptr->get_refCount() == 1)
	    {
		    /* set the vector pointer */
		    cr_alloc_ptr->set_pointer(c_string);
	    }
#endif
	    }

	    return *this;
	}

	inline void clear(void) {
	    erase(0, npos);
	}

	inline size_t find(const wchar_t *str, size_t pos = 0) const {
	    size_t ret = npos;
	    if (str != NULL && c_string != NULL) {
		wchar_t *rptr = wcsstr(c_string + pos, str);

		if (rptr != NULL)
		     ret = (rptr - c_string);
	    }
	    return ret;
	}

	inline size_t find(const cr_wcstring & s, size_t pos = 0) const {
	    return find(s.c_str(), pos);
	} 
    
    inline size_type find(const wchar_t *s, size_type pos, size_type n) const {
	    cr_wcstring t(s);
	     t.resize(n);
	     return find(t.c_str(), pos);
	} 
    
    inline size_type find(wchar_t c, size_type pos = 0) const {
	    cr_wcstring t(c);
	     return find(t.c_str(), pos);
	} 

    inline size_type rfind(const wchar_t* s, size_type pos, size_type n) const{
        cr_wcstring t;
        for (const_iterator i = end() - 1; i != begin() - 1; i--) {
            t += *i;
        } 
        
        if (pos > t.size()) {
            pos = 0;
        } else {
            pos = t.size() - pos;
        }

        cr_wcstring ts;
        size_type sn = wcsnlen(s, cr_wcstring::WMAX_CR_STRING_LEN);
        sn = sn - (sn-n);
        for(size_type i = sn; i != -1; i--) {
            ts += s[i];
        }

        size_type pos1 = t.find(ts.c_str(), pos);
        if (pos1 != npos) {
            pos1 = length() - pos1 - sn;
        }

        return pos1;
    }

    inline size_type rfind(const cr_wcstring& s, size_type pos = npos) const {
        return rfind(s.c_str(), pos, s.length());
    }

    inline size_type rfind(const wchar_t* s, size_type pos = npos) const {
        return rfind(s, pos, wcsnlen(s, cr_wcstring::WMAX_CR_STRING_LEN));
    }

    inline size_type rfind(wchar_t c, size_type pos = npos) const {
        cr_wcstring t = c;
        return rfind(t.c_str(), pos, t.length());
    }
    
    inline size_type find_first_of(const wchar_t *s, size_type pos,
					 size_type n) const {
	    size_type pos1 = npos;
	    if (c_string != NULL && pos <= length()) {
		cr_wcstring t;
		 t.assign(s, n);
		wchar_t *c = wcspbrk(c_string + pos, t.c_str());
		if (c != NULL) {
		    pos1 = (c - begin());
		}
	    }
	    return pos1;
	}

	inline size_type find_first_of(const cr_wcstring & s, size_type pos =
				       0) const {
	    return find_first_of(s.c_str(), pos, s.length());
	} 
    
    inline size_type find_first_of(const wchar_t *s, size_type pos = 0) const {
	    return find_first_of(s, pos, wcsnlen(s, cr_wcstring::WMAX_CR_STRING_LEN));
	} 
    
    inline size_type find_first_of(wchar_t c, size_type pos = 0) const {
	    size_type pos1 = npos;
	    if (c_string != NULL && pos <= length()) {
		wchar_t *t = wcschr(c_string + pos, c);
		if (t != NULL) {
		    pos1 = (t - begin());
		}
	    }
	    return pos1;
	}

	inline size_type find_first_not_of(const wchar_t *s, size_type pos,
					   size_type n) const {
	    size_type pos1 = npos;
	    if (c_string != NULL && pos <= length()) {
             cr_wcstring t;
             t.assign(s, n);
			 size_type i=0;
             for(; i < (length()-pos);i++) 
             {
                 bool matched = false;
                 for(size_type j=0; j < wcsnlen(s, cr_wcstring::WMAX_CR_STRING_LEN); j++)
                 {
                    if(*(c_string+pos+i) != *(s+j))
                        continue;

                    matched=true;
                    break;
                 }

                if (matched == false)
                    break;
             }

			if (i != (length()-pos))
				pos1 = pos + i;
	    }

	    return pos1;
	}

	inline size_type find_first_not_of(const wchar_t *s, size_type pos =
					   0) const {
	    return find_first_not_of(s, pos,
				     wcsnlen(s, cr_wcstring::WMAX_CR_STRING_LEN));
	} 
    
    inline size_type find_first_not_of(const cr_wcstring & s,
					     size_type pos = 0) const {
	    return find_first_not_of(s.c_str(), pos, s.length());
	} 
    
    inline size_type find_first_not_of(wchar_t c, size_type pos = 0) const {
	    cr_wcstring t;
	     t = c;
	     return find_first_not_of(t.c_str(), pos, 1);
	} 
    
    inline size_type find_last_of(const wchar_t *s, size_type pos,
					size_type n) const {
	    cr_wcstring t;
	    for (const_iterator i = end() - 1; i != begin() - 1; i--) {
		t += *i;
	    } if (pos > t.size()) {
		pos = 0;
	    } else {
		pos = t.size() - pos;
	    }

	    size_type pos1 = t.find_first_of(s, pos, n);
	    if (pos1 != npos) {
		pos1 = length() - (pos1 + 1);
	    }
	    return pos1;
	}

	inline size_type find_last_of(const wchar_t *s, size_type pos = npos) const {
	    return find_last_of(s, pos, wcsnlen(s, cr_wcstring::WMAX_CR_STRING_LEN));
	} 
    
    inline size_type find_last_of(wchar_t c, size_type pos = npos) const {
	    cr_wcstring t;
	     t = c;
	     return find_last_of(t.c_str(), pos, 1);
	} 
    
    inline size_type find_last_of(const cr_wcstring & s,
					size_type pos = npos) const {
	    return find_last_of(s.c_str(), pos, s.length());
	} 
    
    inline size_type find_last_not_of(const wchar_t *s, size_type pos,
					    size_type n) const {
	    cr_wcstring t;
	    for (const_iterator i = end() - 1; i != begin() - 1; i--) {
		t += *i;
	    } if (pos > t.size()) {
		pos = 0;
	    } else {
		pos = t.size() - pos;
	    }

	    size_type pos1 = t.find_first_not_of(s, pos, n);
	    if (pos1 != npos) {
		pos1 = length() - (pos1 + 1);
	    }
	    return pos1;
	}

	inline size_type find_last_not_of(const wchar_t *s, size_type pos =
					  npos) const {
	    return find_last_not_of(s, pos, wcsnlen(s, cr_wcstring::WMAX_CR_STRING_LEN));
	} 
    
    inline size_type find_last_not_of(wchar_t c, size_type pos = npos) const {
	    cr_wcstring t;
	     t = c;
	     return find_last_not_of(t.c_str(), pos, 1);
	} 
    
    inline size_type find_last_not_of(const cr_wcstring & s,
					    size_type pos = npos) const {
	    return find_last_not_of(s.c_str(), pos, s.length());
	} 
    
    inline iterator begin(void) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    if (c_string)
		return &c_string[0];
	    else
		return NULL;
	}

	inline iterator end(void) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    if (c_string)
		return &c_string[length()];
	    else
		return NULL;
	}

	inline const_iterator begin(void) const {
	    if (c_string)
		return (const_iterator) & c_string[0];
	    else
		return (const_iterator) NULL;
	} 
    
    inline const_iterator end(void) const {
	    if (c_string)
		return (const_iterator) & c_string[length() + 1];
	    else
		return (const_iterator) NULL;
	} 

    reverse_iterator rbegin(void) {
        iterator tmp = end();
        return reverse_iterator(tmp);
    }

    reverse_iterator rend(void) {
        iterator tmp = begin();
        return reverse_iterator(tmp);
    }

    const_reverse_iterator rbegin(void) const {
        return (const_reverse_iterator) rbegin();
    }

    const_reverse_iterator rend(void) const {
        return (const_reverse_iterator) rend();
    }
    
    inline void reserve(size_t n) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    if ((n > 0) && (n < max_size())) {
        n = (n < WMIN_CR_STRING_LEN)?WMIN_CR_STRING_LEN+1:n;
		if (capacity() > n) {
		    size_t len = length();
		    if (n < len)
			n = len;
		}

		c_string = (wchar_t *) realloc(c_string, ((n + 1) * sizeof(wchar_t)));
		if (aloc_capacity == 0)
		    c_string[0] = 0;
		aloc_capacity = n + 1;
	    } else {
		//cout << "Error:: n value asked is > than max string size."
		//    << endl;
			#ifdef CR_USE_ALLOCATOR
 if(cr_alloc_ptr->get_refCount() == 1)
	    {
		    /* set the vector pointer */
		    cr_alloc_ptr->set_pointer(c_string);
	    }
#endif
	    }
	}

	inline void swap(cr_wcstring & s) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    cr_wcstring t = s;
	    s = c_string;
	    *this = t;
	}

	inline void push_back(value_type c) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    *this += c;
	}

	inline void resize(size_type n, wchar_t c = wchar_t ()) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
        size_type len = size();

        if ((len!=n) && (n <= cr_wcstring::WMAX_CR_STRING_LEN)) {

            if (len < n) {
                size_type aloc = (n+1) * sizeof(wchar_t);

                c_string = (pointer) realloc(c_string, aloc);
                aloc_capacity = (n+1);

                pointer tmp = c_string+len;
                for (size_type i = len; i < n; i++) {
                    memcpy(tmp, &c, sizeof(wchar_t));
                    tmp++;
                }
                c_string[n] = (value_type)0;
            } else {

                if (n == 0) {
                    if (c_string) {
                        free(c_string);
                    }

                    c_string = NULL;
                    aloc_capacity = 0;
                }
                else {
                    if ((len == 0) || (n > (cr_wcstring::WMIN_CR_STRING_LEN + 1))) {
                        size_type p = n;
                        p++;
                        p = p + ((cr_wcstring::WMIN_CR_STRING_LEN + 1) -
                             p % (cr_wcstring::WMIN_CR_STRING_LEN + 1));
                        c_string = (pointer) realloc(c_string, ((p + 1)*sizeof(wchar_t)));
                        aloc_capacity = (p + 1);
                    }

                    c_string[n] = 0;
                }
           }
			#ifdef CR_USE_ALLOCATOR
	 if(cr_alloc_ptr->get_refCount() == 1)
	    {
		    /* set the vector pointer */
		    cr_alloc_ptr->set_pointer(c_string);
	    }
#endif
        }
	}

	inline cr_wcstring & assign(const cr_wcstring & s) {
	    *this = s;

	    return *this;
	}

	inline cr_wcstring & assign(const cr_wcstring & s, size_type pos,
				  size_type n) {
	    cr_wcstring t(s, pos, n);
	    *this = t;

	    return *this;
	}

	inline cr_wcstring & assign(const wchar_t *s, size_type n) {
	    cr_wcstring t(s, 0, n);
	    *this = t;
	    return *this;
	}

	inline cr_wcstring & assign(const wchar_t *s) {
	    cr_wcstring t(s);
	    *this = t;
	    return *this;
	}

	inline cr_wcstring & assign(size_type n, wchar_t c) {
	    resize(0);
	    resize(n, c);
	    return *this;
	}

	inline cr_wcstring & assign(InputIterator first, InputIterator last) {
	    resize(0);
	    for (InputIterator i = first; i != last; i++) {
		*this += *i;
	    }

	    return *this;
	}

	inline cr_wcstring & insert(size_type pos, const wchar_t *s) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    if (pos >= 0 && pos <= length()) {
		cr_wcstring t;
		t.assign(begin(), begin() + pos);
		t += s;

		if (pos < length()) {
		    t.cat_str(c_string + pos, 0, (length() - pos));
		}
		*this = t;
#ifdef CR_USE_ALLOCATOR
	    if(cr_alloc_ptr->get_refCount() == 1)
	    {
		    /* set the vector pointer */
		    cr_alloc_ptr->set_pointer(c_string);
	    }
#endif
	    }

	    return *this;
	}

	inline cr_wcstring & insert(size_type pos, const wchar_t *s,
				  size_type n) {
	    if (pos >= 0 && pos <= length()) {
		cr_wcstring t;
		t.assign(begin(), begin() + pos);

		t.cat_str(s, 0, n);

		if (pos < length()) {
		    t.cat_str(begin() + pos, 0, (length() - pos));
		}
		*this = t;
	    }

	    return *this;
	}

	inline cr_wcstring & insert(size_type pos, const cr_wcstring & s) {
	    return insert(pos, s.c_str());
	}

	inline cr_wcstring & insert(size_type pos, const cr_wcstring & s,
				  size_type pos1, size_type n) {
	    if (pos >= 0 && pos <= length()) {
		cr_wcstring t;
		t.assign(begin(), begin() + pos);

		t.cat_str(s.begin() + pos1, 0, n);

		if (pos < length()) {
		    t.cat_str(begin() + pos, 0, (length() - pos));
		}
		*this = t;
	    }

	    return *this;
	}

	inline cr_wcstring & insert(size_type pos, size_type n, wchar_t c) {
	    cr_wcstring t;
	    t.resize(n, c);
	    return insert(pos, t.c_str());
	}

	inline cr_wcstring & append(const wchar_t *s) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    *this += s;
#ifdef CR_USE_ALLOCATOR
	    if(cr_alloc_ptr->get_refCount() == 1)
	    {
		    /* set the vector pointer */
		    cr_alloc_ptr->set_pointer(c_string);
	    }
#endif
	    return *this;
	}

	inline cr_wcstring & append(const wchar_t *s, size_type n) {
	    size_type len = length();
	    *this += s;
	    resize(len + n);
	    return *this;
	}

	inline cr_wcstring & append(const cr_wcstring & s) {
	    return append(s.c_str());
	}

	inline cr_wcstring & append(const cr_wcstring & s, size_type pos,
				  size_type n) {
	    return append((s.c_str() + pos), n);
	}

	inline cr_wcstring & append(size_type n, wchar_t c) {
	    cr_wcstring t;
	    t.resize(n, c);
	    return append(t.c_str());
	}

	inline cr_wcstring & append(InputIterator first, InputIterator last) {
	    cr_wcstring t;
	    t.assign(first, last);
	    return append(t.c_str());
	}

	inline cr_wcstring & replace(size_type pos, size_type n,
				   const wchar_t *s, size_type n1) {
 #ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	 
	    cr_wcstring t;
	    t.assign(c_str() + pos + n);
	    resize(pos);
	    append(s, n1);
	    append(t);
	    return *this;
	}

	inline cr_wcstring & replace(size_type pos, size_type n,
				   const cr_wcstring & s) {
	    return replace(pos, n, s.c_str(), s.length());
	}

	inline cr_wcstring & replace(size_type pos, size_type n,
				   const cr_wcstring & s, size_type pos1,
				   size_type n1) {
	    cr_wcstring t;
	    t.assign(c_str() + pos + n);
	    resize(pos);
	    append(s, pos1, n1);
	    append(t);
	    return *this;
	}

	inline cr_wcstring & replace(size_type pos, size_type n,
				   const wchar_t *s) {
	    return replace(pos, n, s, wcsnlen(s, cr_wcstring::WMAX_CR_STRING_LEN));
	}

	inline cr_wcstring & replace(size_type pos, size_type n,
				   size_type n1, wchar_t c) {
	    cr_wcstring t;
	    t.resize(n1, c);
	    return replace(pos, n, t);
	}

	inline cr_wcstring & replace(iterator first, iterator last,
				   const wchar_t *s, size_type n) {
	    cr_wcstring t;
	    t.assign(begin(), first);
	    resize(t.length());
	    append(s, n);
	    append(t);
	    return *this;
	}

	inline cr_wcstring & replace(iterator first, iterator last,
				   const cr_wcstring & s) {
	    return replace(first, last, s.c_str(), s.length());
	}

	inline cr_wcstring & replace(iterator first, iterator last,
				   const wchar_t *s) {
	    return replace(first, last, s, wcsnlen(s, cr_wcstring::WMAX_CR_STRING_LEN));
	}

	inline cr_wcstring & replace(iterator first, iterator last,
				   size_type n, wchar_t c) {
	    cr_wcstring t;
	    t.resize(n, c);
	    return replace(first, last, t);
	}

private:

	inline size_t copy_str(wchar_t *c, size_t pos, size_t n) {
	    size_t tn = 0;
	    size_t len = 0;
	    if (c != NULL && c_string != NULL) {
		len = wcsnlen(c_string, cr_wcstring::WMAX_CR_STRING_LEN);

		if (pos <= len) {
		    if ((pos + n) <= len)
			tn = n;
		    else
			tn = len - pos;
		    wmemcpy(c, c_string + pos, tn);
		}
	    }

	    return tn;
	}			//end of copy_str()

	inline void cat_str(const wchar_t *c, size_t pos, size_t n) {
#ifdef CR_USE_ALLOCATOR
	check_modify_allocator();
#endif
	    if (c != NULL) {
            size_t oldlen = size();
            size_t len1 = wcsnlen(c, cr_wcstring::WMAX_CR_STRING_LEN);

            if (n == npos) {
                n = len1;
            }

            if (pos <= len1) {
                size_t tn;
                if ((pos + n) <= len1)
                tn = n;
                else
                tn = len1 - pos;

                size_t alloc = (oldlen + tn);

                if (alloc < cr_wcstring::WMIN_CR_STRING_LEN) {
                    alloc = (cr_wcstring::WMIN_CR_STRING_LEN + 1);
                }


                if (alloc > capacity()) {

                if (alloc > (cr_wcstring::WMIN_CR_STRING_LEN + 1)) {
                    alloc++;
                    alloc =
                    alloc + ((cr_wcstring::WMIN_CR_STRING_LEN + 1) -
                         alloc % (cr_wcstring::WMIN_CR_STRING_LEN + 1));
                    alloc--;
                }

                c_string = (wchar_t *) realloc(c_string, ((alloc+1)*sizeof(wchar_t)));

                aloc_capacity = (alloc+1);
                }

                wmemcpy(c_string + oldlen, c + pos, tn);
                c_string[(oldlen + tn)] = 0;
            }
#ifdef CR_USE_ALLOCATOR
	    if(cr_alloc_ptr->get_refCount() == 1)
	    {
		    /* set the vector pointer */
		    cr_alloc_ptr->set_pointer(c_string);
	    }
#endif
	    }
	}			//end of cat_str()
private: 
#ifdef CR_USE_ALLOCATOR
	void check_modify_allocator(void) {
		typedef  cr_allocator<wchar_t> T;
		/* check if allocator is already malloc'd */
		if (cr_alloc_ptr != 0)
		{
			/* allocator already malloc'd */
			if (cr_alloc_ptr->get_refCount() < 0)
			{
				printf("Error: refCount is < 0\n");
				exit(0);
			}

			/* check if more than one reference is present */
			if (cr_alloc_ptr->get_refCount() > 1)
			{
				/* create a new alloc_ptr, copy the contents and 
				 * decrement the old reference and increment the new
				 * reference count */
				cr_allocator<wchar_t>* tmp = cr_allocator<wchar_t>::create_node();

				/* malloc the size of vector and copy */
				pointer tmpPtr = (pointer) malloc((size()+1) * sizeof(T));
				if (tmpPtr == NULL)
				{
					printf("Error: unable to malloc.\n");
					exit(0);
				}

				pointer oldPtr = cr_alloc_ptr->get_pointer();

				/* copy old memory to new */
				memcpy( (void*)tmpPtr, (void*)oldPtr, ((size()+1)*sizeof(T)) );

				cr_alloc_ptr->dec_refCount();
				tmp->incr_refCount();

				/* set the copied memory as the new pointer */
				tmp->set_pointer(tmpPtr);

				/* use the tmp as the new aloc_ptr */
				cr_alloc_ptr = tmp;

				/* set the vector pointer to the new ptr */
				c_string = cr_alloc_ptr->get_pointer();

			}
		}
		else
		{
			/* allocator is not malloc'd */
			cr_alloc_ptr = cr_allocator<wchar_t>::create_node();

			/* This will set refCount to 1 */
			cr_alloc_ptr->incr_refCount();
		}
	}
	/*end of check_modify_allocator()*/
#endif

	private:
 size_type   aloc_size;
  bool copyable;

 

#ifdef CR_USE_ALLOCATOR
protected:
    cr_allocator<wchar_t>* cr_alloc_ptr;  

#endif

private:
	wchar_t *c_string;
	size_type aloc_capacity;

};

typedef class cr_wcstring cr_wcstring;

//static inline wostream& operator<<(wostream & os, const cr_wcstring & s) {
//return os << s.c_str();
//}

//static inline wistream& operator>>(wistream & is, cr_wcstring& s) {
//wchar_t c[cr_wcstring::WMAX_CR_LINE_LEN] = { 0 };
//s = c;
//cr_wcstring::iterator cstr = s.begin();
//is >> cstr;
//return is;
//}

//static inline wistream & getline(wistream & is, cr_wcstring & s) {
//wchar_t c[cr_wcstring::WMAX_CR_LINE_LEN] = { 0 };
//
//is.getline(c, cr_wcstring::WMAX_CR_LINE_LEN);
//s = c;
//
//return is;
//}

static inline cr_wcstring operator+(const cr_wcstring & s1,
                  const cr_wcstring & s2) {
cr_wcstring t(s1);
t += s2;
return t;
}

static inline cr_wcstring operator+(const wchar_t *s1, const cr_wcstring & s2) {
cr_wcstring t(s1);
t += s2;
return t;
}

static inline cr_wcstring operator+(const cr_wcstring & s1, const wchar_t *s2) {
cr_wcstring t(s1);
t += s2;
return t;
}

static inline cr_wcstring operator+(wchar_t c, const cr_wcstring & s2) {
wchar_t tt[4] = { 0 };
tt[0] = c;
cr_wcstring t(tt);
t += s2;
return t;
}

static inline cr_wcstring operator+(const cr_wcstring & s1, wchar_t c) {
wchar_t tt[4] = { 0 };
tt[0] = c;
cr_wcstring t(s1);
t += tt;
return t;
}

static inline bool operator==(const cr_wcstring & s1,
              const cr_wcstring & s2) {
return ((wcsncmp(s1.c_str(), s2.c_str(), cr_wcstring::WMAX_CR_STRING_LEN) ==
     0) ? true : false);
}

static inline bool operator==(const wchar_t *s1, const cr_wcstring & s2) {
return ((wcsncmp(s1, s2.c_str(), cr_wcstring::WMAX_CR_STRING_LEN) ==
     0) ? true : false);
}

static inline bool operator==(const cr_wcstring & s1, const wchar_t *s2) {
return ((wcsncmp(s1.c_str(), s2, cr_wcstring::WMAX_CR_STRING_LEN) ==
     0) ? true : false);
}

static inline bool operator!=(const cr_wcstring & s1,
              const cr_wcstring & s2) {
return ((wcsncmp(s1.c_str(), s2.c_str(), cr_wcstring::WMAX_CR_STRING_LEN) !=
     0) ? true : false);
}

static inline bool operator!=(const wchar_t *s1, const cr_wcstring & s2) {
return ((wcsncmp(s1, s2.c_str(), cr_wcstring::WMAX_CR_STRING_LEN) !=
     0) ? true : false);
}

static inline bool operator!=(const cr_wcstring & s1, const wchar_t *s2) {
return ((wcsncmp(s1.c_str(), s2, cr_wcstring::WMAX_CR_STRING_LEN) !=
     0) ? true : false);
}

static inline bool operator<(const cr_wcstring & s1,
             const cr_wcstring & s2) {
return ((wcsncmp(s1.c_str(), s2.c_str(), cr_wcstring::WMAX_CR_STRING_LEN) <
     0) ? true : false);
}

static inline bool operator<=(const cr_wcstring & s1,
             const cr_wcstring & s2) {
return ((wcsncmp(s1.c_str(), s2.c_str(), cr_wcstring::WMAX_CR_STRING_LEN) <=
     0) ? true : false);
}

static inline bool operator<(const wchar_t *s1, const cr_wcstring & s2) {
return ((wcsncmp(s1, s2.c_str(), cr_wcstring::WMAX_CR_STRING_LEN) <
     0) ? true : false);
}

static inline bool operator<=(const wchar_t *s1, const cr_wcstring & s2) {
return ((wcsncmp(s1, s2.c_str(), cr_wcstring::WMAX_CR_STRING_LEN) <=
     0) ? true : false);
}

static inline bool operator<(const cr_wcstring & s1, const wchar_t *s2) {
return ((wcsncmp(s1.c_str(), s2, cr_wcstring::WMAX_CR_STRING_LEN) <
     0) ? true : false);
}

static inline bool operator<=(const cr_wcstring & s1, const wchar_t *s2) {
return ((wcsncmp(s1.c_str(), s2, cr_wcstring::WMAX_CR_STRING_LEN) <=
     0) ? true : false);
}

static inline bool operator>(const cr_wcstring & s1,
             const cr_wcstring & s2) {
return ((wcsncmp(s1.c_str(), s2.c_str(), cr_wcstring::WMAX_CR_STRING_LEN) >
     0) ? true : false);
}

static inline bool operator>(const wchar_t *s1, const cr_wcstring & s2) {
return ((wcsncmp(s1, s2.c_str(), cr_wcstring::WMAX_CR_STRING_LEN) >
     0) ? true : false);
}

static inline bool operator>(const cr_wcstring & s1, const wchar_t *s2) {
return ((wcsncmp(s1.c_str(), s2, cr_wcstring::WMAX_CR_STRING_LEN) >
     0) ? true : false);
}

static inline bool operator>=(const cr_wcstring & s1,
             const cr_wcstring & s2) {
return ((wcsncmp(s1.c_str(), s2.c_str(), cr_wcstring::WMAX_CR_STRING_LEN) >=
     0) ? true : false);
}

static inline bool operator>=(const wchar_t *s1, const cr_wcstring & s2) {
return ((wcsncmp(s1, s2.c_str(), cr_wcstring::WMAX_CR_STRING_LEN) >=
     0) ? true : false);
}

static inline bool operator>=(const cr_wcstring & s1, const wchar_t *s2) {
return ((wcsncmp(s1.c_str(), s2, cr_wcstring::WMAX_CR_STRING_LEN) >=
     0) ? true : false);
}

static inline bool operator==(const cr_wcstring::reverse_iterator& x, const cr_wcstring::reverse_iterator& y) {
    return (x.get_itr()==y.get_itr());
}

static inline bool operator!=(const cr_wcstring::reverse_iterator& x, const cr_wcstring::reverse_iterator& y) {
    return (x.get_itr()!=y.get_itr());
}

static inline bool operator<(const cr_wcstring::reverse_iterator& x, const cr_wcstring::reverse_iterator& y) {
    return (x.get_itr()<y.get_itr());
}

static inline bool operator>(const cr_wcstring::reverse_iterator& x, const cr_wcstring::reverse_iterator& y) {
    return (x.get_itr()>y.get_itr());
}

}				//end of namespace osal_stl

#endif				//__CR_WCSTRING_H_
