/****************************************************************************
*      _   _  ___  ____                                        
*     | \ | |/ _ \/ ___|                            N.A.Software Ltd
*     |  \| | |_| \___ \                            1 Prospect Road
*     | |\  |  _  |___) |                           Prenton
*     |_| \_|_| |_|____/                            CH42 8LE
* 
*     Created by NASoftware Ltd                     +44 (0) 151 609 1911
*
*****************************************************************************
*  
*  Project      :  2D Compression benchmark
*  Created      :  Sep 25 2009
*  Version      :  1.0.0
*
*****************************************************************************

****************************************************************************/

#include <sys/time.h>
#include <sys/resource.h>
#define BENCH_ITS 1000

#ifndef __INTEL__
#define __INTEL__
#endif
#ifndef __LINUX__
#define __LINUX__
#endif

/* Define cycle variable data type.                                       */
#if defined(__INTEL__)

/* Platform: Intel  OS: linux.                                            */
/* Platform: Intel  OS: vxWorks.                                          */
typedef unsigned long long int time_val;

#elif defined(__PPC__)

#if defined(__VXWORKS__)

/* Platform: PowerPC  OS: vxWorks.                                        */
typedef unsigned long time_val;

#elif defined(__LINUX__)

/* Platform: PowerPC  OS: linux.                                          */
typedef unsigned long long time_val;
#else
#error You must define either __VXWORKS__ or __LINUX__
#endif
#else
#error You must define either __INTEL__ or __PPC__
#endif

#ifdef __INTEL__

/**************************************************************************/
/*                                                                        */
/*                    get_cycles()                                        */
/*                                                                        */
/* This function returns the cycle count from the system clock. This is   */
/* used to calculate the time between calls to this function.             */
/*                                                                        */
/**************************************************************************/
static inline time_val get_cycles(void)
{
   unsigned int now_hi, now_lo;
   time_val now;


   /* get timer value.                                                    */
   __asm__ __volatile__(".byte 0x0f,0x31":"=a"(now_lo), "=d"(now_hi));

   now = ((time_val) now_hi << 32) | now_lo;

   return (now);

} /* End of get_cycles.                                                   */

#endif
