#ifndef _VEC_PRINT_H
#define _VEC_PRINT_H

#ifndef __ch

typedef union {
    vector unsigned char v;
    unsigned char s[16];
} mix_u8;

typedef union {
    vector unsigned short v;
    unsigned short s[8];
} mix_u16;

typedef union {
    vector unsigned int v;
    unsigned int s[4];
} mix_u32;

typedef union {
    vector signed char v;
    signed char s[16];
} mix_s8;

typedef union {
    vector signed short v;
    signed short s[8];
} mix_s16;

typedef union {
    vector signed int v;
    signed int s[4];
} mix_s32;

typedef union {
    vector float v;
    float s[4];
} mix_f32;

extern int __ERROR_INVALID_ARGUMENT();
#endif


inline void 
vec_print_u8(vector unsigned char va)
{
  mix_u8 a;
  a.v = va;
#ifdef HEXCHAR
  printf("%02x, %02x, %02x, %02x, %02x, %02x, %02x, %02x, %02x, %02x, %02x, %02x, %02x, %02x, %02x, %02x\n",
	 a.s[0], a.s[1], a.s[2], a.s[3], 
	 a.s[4], a.s[5], a.s[6], a.s[7], 
	 a.s[8], a.s[9], a.s[10], a.s[11], 
	 a.s[12], a.s[13], a.s[14], a.s[15]);
#else
  printf("%3d, %3d, %3d, %3d, %3d, %3d, %3d, %3d, %3d, %3d, %3d, %3d, %3d, %3d, %3d, %3d\n",
	 a.s[0], a.s[1], a.s[2], a.s[3], 
	 a.s[4], a.s[5], a.s[6], a.s[7], 
	 a.s[8], a.s[9], a.s[10], a.s[11], 
	 a.s[12], a.s[13], a.s[14], a.s[15]);
#endif
}

inline void 
vec_print_s8(vector signed char va)
{
  mix_s8 a;
  a.v = va;
  printf("%d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d\n",
	 a.s[0], a.s[1], a.s[2], a.s[3], 
	 a.s[4], a.s[5], a.s[6], a.s[7], 
	 a.s[8], a.s[9], a.s[10], a.s[11], 
	 a.s[12], a.s[13], a.s[14], a.s[15]);
}

inline void 
vec_print_u16(vector unsigned short va)
{
  mix_u16 a;
  a.v = va;
  printf("%d, %d, %d, %d, %d, %d, %d, %d\n",
	 a.s[0], a.s[1], a.s[2], a.s[3], 
	 a.s[4], a.s[5], a.s[6], a.s[7]);
}

inline void 
vec_print_s16(vector signed short va)
{
  mix_s16 a;
  a.v = va;
  printf("%d, %d, %d, %d, %d, %d, %d, %d\n",
	 a.s[0], a.s[1], a.s[2], a.s[3], 
	 a.s[4], a.s[5], a.s[6], a.s[7]);
}

inline void 
vec_print_u32(vector unsigned int va)
{
  mix_u32 a;
  a.v = va;
  printf("%uU, %uU, %uU, %uU\n", a.s[0], a.s[1], a.s[2], a.s[3]);
}

inline void 
vec_print_s32(vector signed int va)
{
  mix_s32 a;
  a.v = va;
  printf("%d, %d, %d, %d\n", a.s[0], a.s[1], a.s[2], a.s[3]);
}


inline void 
vec_print_f32(vector float va)
{
  mix_f32 a;
  a.v = va;
  // printf("%g, %g, %g, %g\n", a.s[0], a.s[1], a.s[2], a.s[3]);
  // printf("0x%0x, 0x%0x, 0x%0x, 0x%0x\n", *(int*)&a.s[0], *(int*)&a.s[1], *(int*)&a.s[2], *(int*)&a.s[3]);
  printf("%a, %a, %a, %a\n", a.s[0], a.s[1], a.s[2], a.s[3]);
}

inline void 
vec_print_int(int a)
{
  printf("%d\n", a);
}

inline void 
vec_print_ptr(void *a)
{
  printf("%p\n", a);
}


#ifdef __cplusplus
inline void vec_print(vector unsigned char va) { vec_print_u8(va); }
inline void vec_print(vector signed char va) { vec_print_s8(va); }
inline void vec_print(vector unsigned short va) { vec_print_u16(va); }
inline void vec_print(vector signed short va) { vec_print_s16(va); }
inline void vec_print(vector unsigned int va) { vec_print_u32(va); }
inline void vec_print(vector signed int va) { vec_print_s32(va); }
inline void vec_print(vector float va) { vec_print_f32(va); }
inline void vec_print(int a) { vec_print_int(a); }
inline void vec_print(void *p) { vec_print_ptr(p); }

#else

#define __ch(x, y, z)	__builtin_choose_expr (x, y, z)
#define __un_args_eq(xtype, x)				\
	__builtin_types_compatible_p (xtype, typeof (x))

#define vec_print(a) \
  __ch (__un_args_eq (vector unsigned char, (a)),	\
	vec_print_u8(a),				\
  __ch (__un_args_eq (vector signed char, (a)),	        \
	vec_print_s8(a),				\
  __ch (__un_args_eq (vector unsigned short, (a)),	\
	vec_print_u16(a),				\
  __ch (__un_args_eq (vector signed short, (a)),	\
	vec_print_s16(a),				\
  __ch (__un_args_eq (vector unsigned int, (a)),	\
	vec_print_u32(a),				\
  __ch (__un_args_eq (vector signed int, (a)),	        \
	vec_print_s32(a),				\
__ERROR_INVALID_ARGUMENT ()))))))

#endif	/* __cplusplus */

#endif
