/**********************************************************************
Copyright (c) 2013, Intel Corporation 

All rights reserved. 

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met: 

* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.  

* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the
  distribution. 

* Neither the name of the Intel Corporation nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission. 


THIS SOFTWARE IS PROVIDED BY INTEL CORPORATION "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL INTEL CORPORATION OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************/


// 64-bit code requiring YASM to build
//

#include <stdio.h>

typedef unsigned char           UINT8;
typedef unsigned short int      UINT16;
typedef unsigned long long int  UINT64;


//function computes the 16-bit CRC, as defined in the T10 DIF Standard (http://www.t10.org/)
//function assumes that the length of the buffer is a multiple of 128 bytes for efficiency.
//buffer length will be rounded down to a multiple of 128
//for example, if len is 130, crc on a 128 Byte buffer will be computed.

UINT16  crc16_T10DIF_128x(	
UINT16  init_crc,               //initial CRC value, 16 bits
const   UINT8 *buf,             //buffer pointer to calculate CRC on
UINT64  len                     //buffer length in bytes (64-bit data)
);



int main()
{
        int     i;
        UINT8   p_buf[1024];
        UINT16  init_crc_16;
        UINT16  clmul_crc_16;

        UINT16  expected_result = 0xB3C4;

        for(i=0; i<1024; i++)
                p_buf[i] = i+1;

        init_crc_16 = 0;
        clmul_crc_16 = crc16_T10DIF_128x(init_crc_16, p_buf, 1024);

        if (clmul_crc_16 != expected_result)
        {
                printf("Wrong Result \n");
                printf("Expected CRC value: %x\n",expected_result);
                printf("Computed CRC value: %x\n",clmul_crc_16);
        }
        else
                printf("Correct Result \n");

        return 0;
}
