//Namespace("Root.component.arp", function()
new function()
{
    //###############################################################
    var ns_installer = Namespace("Root.installer");
    var ns_dump      = Namespace("Root.dumper");

    var base_script_dir = Origin.Directory();
    var load = function(name) {return required(FileSystem.MakePath(name, base_script_dir));};

    var ns_component = load("component.js");
    var ns_registry  = load("dumper_registry.js");
    var ns_prc       = load("component_processor.js");

    var ns = this;
    //###############################################################
    // ComponentARP constructor
    //###############################################################
    this.Create = this.Create || function(info, guid, install_type, ex_init)
    {
        if(!info)
            return null;

        var inf = info.GetInfo();
        if(!inf)
            return null;

        var cmp = ns_installer.Installer.Components[inf.Id()];

        if(!cmp)
        {
            cmp = new ns.ComponentARP();
            if(!cmp.Init(inf, guid, install_type))
                return null;
        }

        var cln = cmp.Clone();

        if(ex_init)
            ex_init.call(cln);

        return cln;
    }
    //###############################################################
    // ComponentARP constructor from RestorePoint
    //###############################################################
    this.CreateFromRP = this.CreateFromRP || function(rp)
    {
        if(!rp || rp("id").value == "")
            return null;

        var cmp = ns_installer.Installer.Components[rp("id").value];

        if(!cmp)
        {
            cmp = new ns.ComponentARP();
            if(!cmp.InitFromRP(rp))
                return null;
        }

        return cmp.Clone();
    }
    //###############################################################
    // ComponentARP class definition
    // 
    // id
    // ARP hive id  - GUID
    // install_type - value of this.install_scope_t type (per user/machine)
    //###############################################################
    this.ComponentARP = this.ComponentARP || function()
    {
        arguments.callee.superclass.constructor.call(this);
        this.obj_type = "arp_component";
    }
    //###############################################################
    // ComponentARP is inheritted from Component
    extend(this.ComponentARP, ns_component.Component);
    //###############################################################
    // Init method definition
    //###############################################################
    this.ComponentARP.prototype.Init = function(inf, guid, install_type)
    {
        this.Log = log_helper("ComponentARP id = " + inf.Id() + ": ");
        ns.ComponentARP.superclass.Init.call(this, inf);

        this.pure = false;

        this.guid = guid ? guid : inf.Id();
        if(install_type)
            this.install_type = this.install_scope_t.per_machine;
        else
        {
            if(System.IsAdmin())
                this.install_type = this.install_scope_t.per_machine;
            else
                this.install_type = this.install_scope_t.per_user;
        }
        this.root  = (this.install_type == this.install_scope_t.per_user) ? "HKCU" : "HKLM";
        this.key   = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + this.guid;
        this.create_arp = true;

        if(Registry.Key(this.root, this.key).Exists())
            this.SetState(this.state_t.installed);

        

        this.properties =
        {
            DisplayIcon : "",
            DisplayName : "",
            DisplayVersion : "",
            EstimatedSize : 0,
            InstallLocation : "",
            Language : 1033,
            Publisher : "",
            UninstallString : "",
            Version : 0,
            VersionMinor : 0,
            VersionMajor : 0,
            HelpLink : "",
            URLInfoAbout :"",
            URLUpdateInfo :"",
            InstallSource : FileSystem.exe_dir
       };

       return true;
    }
    //###############################################################
    // InitFromRP method definition
    //###############################################################
    this.ComponentARP.prototype.InitFromRP = function(rp)
    {
        if(!rp || rp("id").value == undefined || rp("guid").value == undefined || 
            rp("root").value == undefined || rp("key").value == undefined)
            return false;

        var id = rp("id").value;

        this.Log = log_helper("ComponentARP id = " + id + ": ");
        ns.ComponentARP.superclass.InitFromRP.call(this, rp);

        this.pure = false;

        this.guid = rp("guid").value;
        //this.install_type = rp("install_type").value ;
        this.root  = rp("root").value;
        this.key   = rp("key").value;
        //this.create_arp = true;

        if(Registry.Key(this.root, this.key).Exists())
            this.SetState(this.state_t.installed);

        return true;
    }
    //###############################################################
    this.ComponentARP.prototype.NotCreate = function () { this.create_arp = false; }
    //###############################################################
    this.ComponentARP.prototype.Name = function (value) { return this.Property("DisplayName", value); }
    this.ComponentARP.prototype.Version = function (value) { return this.Property("DisplayVersion", value); }
    this.ComponentARP.prototype.UninstallString = function (value) { return this.Property("UninstallString", value); }
    //###############################################################
    // SetProperty method definition
    //###############################################################
    this.ComponentARP.prototype.Property = function (name, value)
    {
        if(name && value)
            this.properties[name] = value;

        return this.properties[name];
    }
    //###############################################################
    // following method is called on installdirbase change
    //###############################################################
    this.ComponentARP.prototype.DoInstallDirBaseChange = function (val)
    {
        this.Property("InstallLocation", this.InstallDir());
        return true;
    }
    //###############################################################
    // following method is called on installdirown change
    //###############################################################
    this.ComponentARP.prototype.DoInstallDirOwnChange = function (val)
    {
        this.Property("InstallLocation", this.InstallDir());
        return true;
    }
    //###############################################################
    // DoApplyRemove method definition
    //###############################################################
    this.ComponentARP.prototype.DoApplyRemove = function (dmp)
    {
        this.Log("DoApplyRemove action = " + this.m_action );
        if(this.Action() == this.action_t.remove && this.TestRemove()) // check that there isn't any other clients for this component and it can be removed
        {
            this.Log("guid = " + this.guid + " will be removed");

            var reg = ns_registry.CreateAction();
            reg.DeleteKey(this.root, this.key);
            this.dumper.AddAction(reg, this.Id() + " Removing ARP");

            if(dmp && dmp.IsDumper)
                dmp.AddAction(this.dumper,"dmpr_" + this.Name());
            else
            {
                this.Log("DoApplyRemove: Can't schedule actions - input dumper is undefined or not a dumper (!dmp.IsDumper)");
                return false;
            }
        }

        return true;
    }
    //###############################################################
    // DoApplyInstall method definition
    //###############################################################
    this.ComponentARP.prototype.DoApplyInstall = function (dmp)
    {
        this.Log("DoApplyInstall action = " + this.m_action );
        if( this.Action() == this.action_t.install && this.create_arp )
        {
            this.Log("guid = " + this.guid + " will be installed");

            var reg = ns_registry.CreateAction();
            reg.CreateKey(this.root, this.key);
            
            this.dumper.AddAction(reg, this.Id() + " Creating ARP");

            for (var prop in this.properties)
            {
                reg.SetValue(this.root, this.key, prop, this.properties[prop]);
            }

            if(dmp && dmp.IsDumper)
                dmp.AddAction(this.dumper,"dmpr_" + this.Name());
            else
            {
                this.Log("DoApplyInstall: Can't schedule actions - input dumper is undefined or not a dumper (!dmp.IsDumper)");
                return false;
            }
        }

        return true;
    }
    //###############################################################
    // DoCommit method definition
    //###############################################################
    this.ComponentARP.prototype.DoCommit = function (){return true;}
    //###############################################################
    // RestorePoint method definition
    //###############################################################
    this.ComponentARP.prototype.RestorePoint = function (st)
    {
        var rp = st ? st : Storage("*");

        rp("guid").value = this.guid;
        rp("root").value = this.root;
        rp("key").value = this.key;

        ns.ComponentARP.superclass.RestorePoint.call(this, rp);

        return rp;
    }
}// namespace Root.component.arp

