new function()
{
    var ns = this;

    var transform_code = {
        "ProductCode":"id",
        "ProductName":"name",
        "ProductVersion":"version",
        "Description":"description",
        "UpgradeCode":"upgrade"
    };

    var transform_property = function(id)
    {
        if(id)
        {
            if(transform_code[id])
                return transform_code[id];
        }

        return null;
    }

    var Info = function()
    {
        var info = {};

        var properties = {};
        var actual = false;
        var priority = 0;

        info.Property = function(name, value)
        {
            if(name)
            {
                if(arguments.length > 1)
                {
                    properties[name] = value;
                    Log("  Info: property " + name + " = " + value);
                }
                else
                    return properties[name];
            }
        }

        info.Properties = function() {return properties;}

        info.Actual = function(act)
        {
            if(arguments.length)
                actual = act;
            else
                return actual;
        }

        info.Priority = function(p)
        {
            if(arguments.length)
                priority = p;
            else
                return priority;
        }

        info.Id = function() {return info.Property("id");}
        info.Name = function() {return info.Property("name");}
        info.Version = function() {return info.Property("version");}
        info.Description = function() {return info.Property("description");}
        info.Size = function()
        {
            var s = info.Property("size");
            if(s)
                return parseInt(s);
            return 0;
        }

        info.GetInfo = function(){ return info; }

        info.Copy = function()
        {
            var inf = Info();
            inf.Actual(actual);
            inf.Priority(priority);

            var pro = info.Properties();
            for(var i in pro)
                inf.Property(i, pro[i]);
            return inf;
        }

        return info;
    }

    this.InfoPure = function(id, nm, dscr, vr, sz)
    {
        if(!id)
            return null;
        
        var info = Info();
        info.Property("id", id);
        info.Property("name", nm ? nm : id);
        info.Property("description", dscr);
        info.Property("version", vr);
        info.Property("size", sz);
        
        return info;
    }
        
    this.InfoXML = function(path)
    {
        Log("Processing XML component info file: " + path);
        if(path && FileSystem.Exists(path))
        {
            var xml = XML(path);
            if(xml)
                return ns.InfoXMLNode(xml);
        }
        return null;
    }

    this.InfoXMLNode = function(node)
    {
        if(node)
        {
            var nodes = node.select("property[@name]");
            if(nodes && nodes.length)
            {
                var info = Info();
                info.Priority(100);

                for(var i in nodes)
                {
                    info.Actual(true);

                    var n = nodes[i];
                    var name = n.attributes.name;
                    var value = n.text;
                    info.Property(name, value);
                    var tr = transform_property(name);
                    if(tr && !info.Property(tr))
                        info.Property(tr, value);
                }
                
                // node attributes also need to be stored
                for(var i in node.attributes)
                {
                    if(!info.Property(i))
                    {
                        //Log("Add attribute " + i + " as property into Info val = " + node.attributes[i]);
                        info.Property(i, node.attributes[i]);
                    }
                    else
                        Log("Can't add attribute " + i + " as property into Info due to proeprty with the same name already exists");
                }
                return info;
            }
            else
                Log(Log.l_warning, "InfoXML: no info (or incorrect format)");
        }

        return null;
    }

    var InfoWIBased = function(msi)
    {
        if(msi)
        {
            var query = msi.Query("select * from Property");
            if(query && query.length)
            {
                var info = Info();

                var size_calculated = false;
                var original_size = info.Size;

                info.Size = function()
                {
                    if(!size_calculated)
                    {
                        size_calculated = true;
                        var squery = msi.Query("select FileSize from File");
                        if(squery && squery.length)
                        {
                            var size = 0;
                            for(var i in squery)
                                size += parseInt(squery[i].FileSize);
                            info.Property("size", size);
                        }
                    }

                    return original_size();
                }

                for(var i in query)
                {
                    info.Actual(true);

                    var record = query[i];

                    var name = record.Property;
                    var value = record.Value;

                    info.Property(name, value);
                    var tr = transform_property(name);
                    if(tr)
                        info.Property(tr, value);
                }
                return info;
            }
            else
                Log(Log.l_warning, "InfoWindowsInstaller: could not execute query");
        }
        else
            Log(Log.l_warning, "InfoWindowsInstaller: could not process MSI database: " + path);

        return null;
    }

    this.InfoMSI = function(path)
    {
        if(path && FileSystem.Exists(path))
        {
            var msi = MSIDatabase(path);
            if(msi)
            {
                var info = InfoWIBased(msi);
                if(info)
                    info.Priority(50);
                return info;
            }
            else
                Log(Log.l_warning, "InfoMSI: could not open MSI database: " + path);
        }
        else
            Log(Log.l_warning, "InfoMSI: file doesn't exists: " + path);

        return null;
    }

    this.InfoWI = function(id)
    {
        if(id)
        {
            var msi = WI.Product(id);
            if(msi)
            {
                var info = InfoWIBased(msi);
                if(info)
                    info.Priority(0);
                return info;
            }
            else
                Log(Log.l_warning, "InfoWI: could not open product database: " + id);
        }

        return null;
    }

    this.ComponentInfo = function()
    {
        var info = {};
        var sources = [];

        info.AddInfo = function(src)
        {
            if(src)
            {
                Log("Adding info");
                sources.push(src);
            }
        }

        info.GetInfo = function()
        {
            sources.sort(function(a, b)
                {
                    var p1 = (a && a.Priority) ? a.Priority() : 0;
                    var p2 = (b && b.Priority) ? b.Priority() : 0;
                    return p1 < p2 ? -1 : (p1 > p2 ? 1 : 0);
                });

            for(var i in sources)
            {
                var s = sources[i];
                if(s && s.Actual && s.Actual())
                    return s;
            }

            Log("ComponentInfo: could not find any actual info object");
            return null;
        }

        return info;
    }
}

