/*
isource - config source directory which will be copied into cache during install to target system
*/

new function()
{
    //###############################################################
    var ns_installer = Namespace("Root.installer");
    var ns_dump      = Namespace("Root.dumper");

    var base_script_dir = Origin.Directory();
    var load = function(name) {return required(FileSystem.MakePath(name, base_script_dir));};

    var ns_component = load("component.js");
    var ns_d_file    = load("dumper_file.js");

    var ns = this;

    //###############################################################
    // ComponentISource constructor
    //###############################################################
    this.Create = this.Create || function(info, is_folder_name, ex_init)
    {
        if(!info)
            return null;

        var inf = info.GetInfo();
        if(!inf)
            return null;

        var cmp = ns_installer.Installer.Components[inf.Id()];
        
        if(!cmp)
        {
            cmp = new ns.ComponentISource();
            if(!cmp.Init(inf, is_folder_name))
                return null;
        }

        var cln = cmp.Clone();
        
        if(ex_init)
            ex_init.call(cln);

        return cln;
    }
    //###############################################################
    // ComponentISource constructor from RestorePoint
    //###############################################################
    this.CreateFromRP = this.CreateFromRP || function(rp)
    {
        if(!rp || rp("id").value == "")
            return null;

        var cmp = ns_installer.Installer.Components[rp("id").value];
        
        if(!cmp)
        {
            cmp = new ns.ComponentISource();
            if(!cmp.InitFromRP(rp))
                return null;
        }
            
        return cmp.Clone();
    }
    //###############################################################
    // ComponentISource class definition
    //###############################################################
    this.ComponentISource = this.ComponentISource || function()
    {
        arguments.callee.superclass.constructor.call(this);
        this.obj_type = "isource_component";
    }
    //###############################################################
    // ComponentISource is inheritted from Component
    extend(this.ComponentISource, ns_component.Component);

    //###############################################################
    // Init method definition
    //###############################################################
    this.ComponentISource.prototype.Init = function(inf, is_folder_name)
    {
        this.Log = log_helper("ComponentISource id = " + inf.Id() + ": ");
        ns.ComponentISource.superclass.Init.call(this, inf);

        //this.Log("Component ISource constructor ");
        if(!is_folder_name || is_folder_name == "")
        {   
            this.is_folder = this.Id();
        }
        else
        {
            this.is_folder = is_folder_name;
        }
        this.pure = false; // virtual component, like general product
        
        this.binaries = [];
        //this.binaries.push(FileSystem.Parent(Origin.Directory()));
        this.target_dir = FileSystem.MakePath(this.is_folder, Cache.CacheDir());

        this.Log(" ISource  component target folder = " + this.target_dir);

        if( FileSystem.Exists(this.target_dir) )
            this.SetState(this.state_t.installed);
    
        return true;
    }
    //###############################################################
    // InitFromRP method definition
    //###############################################################
    this.ComponentISource.prototype.InitFromRP = function(rp)
    {
        if(!rp || rp("id").value == undefined || rp("target_dir").value == undefined )
            return false;
        
        var id = rp("id").value; 
        
        this.Log = log_helper("ComponentISource id = " + id + ": ");
        ns.ComponentISource.superclass.InitFromRP.call(this, rp);
                
        this.pure = false; // virtual component, like general product

        this.binaries = [];        
        this.target_dir = rp("target_dir").value;

        this.Log(" ISource  component target folder = " + this.target_dir);

        if( FileSystem.Exists(this.target_dir) )
            this.SetState(this.state_t.installed);
    
        return true;
    }
    //###############################################################
    // TargetDir method definition
    //###############################################################
    this.ComponentISource.prototype.TargetDir = function ()
    {
        return this.target_dir;
    }
    //###############################################################
    // AddSource method definition
    //###############################################################
    this.ComponentISource.prototype.AddSource = function (source)
    {
        if(source)
        {
            this.Log("Adding Source \"" + source);

            this.binaries.push(source);

            if(this.GetState() != this.state_t.installed)
            {
                this.Log("Component isn't installed");
                return;
            }
            
            if(FileSystem.IsDirectory(source))
            {                
                var source_files = FileSystem.FindFilesRecursive(source, "*.*");
                for(var i in source_files)
                {
                    this.Log("Checking existence of the file \"" + source_files[i]);
                    if(!FileSystem.Exists(FileSystem.MakePath(source_files[i], this.TargetDir())))
                    {
                        this.Log("File doesn't exist -> State will be set to absent");
                        this.SetState(this.state_t.absent);
                        return;
                    }
                }
            }
            else
            {
                if(!FileSystem.Exists(FileSystem.MakePath(FileSystem.FileName(source), this.TargetDir())))
                {
                    this.SetState(this.state_t.absent);
                    return;
                }
            }
        }
    }
    //###############################################################
    // DoApplyRemove method definition
    //###############################################################
    this.ComponentISource.prototype.DoApplyRemove = function (dmp)
    {        
        if(this.Action() == this.action_t.remove && this.TestRemove()) // check that there isn't any other clients for this component and it can be removed
        {
            this.Log("will be removed");

            var dir = ns_d_file.Directory();
            dir.DelayedRemove(this.target_dir);
            this.dumper.AddAction(dir, "delayed remove of installer src dir " + this.target_dir);
            
            if(dmp && dmp.IsDumper)
                dmp.AddAction(this.dumper,"dmpr_" + this.Name());
            else
            {
                this.Log("DoApplyRemove: Can't schedule actions - input dumper is undefined or not a dumper (!dmp.IsDumper)");
                return false;
            }

            //ns_installer.Installer.Dumper.AddAction(this.dumper);
        }

        return true;
    }
    //###############################################################
    // DoApplyInstall method definition
    //###############################################################
    this.ComponentISource.prototype.DoApplyInstall = function (dmp)
    {        
        if( this.GetAction() == this.action_t.install )
        {
            if(this.binaries.length == 0)
            {
                this.Log("nothing to install");
                return true;
            }
            
            this.Log("will be installed");

            var dir = ns_d_file.Directory();
            dir.Create(this.target_dir);

            var file = null;

            for(var i in this.binaries)
            {
                if(FileSystem.IsDirectory(this.binaries[i]))
                    dir.CopyContent(this.binaries[i], this.target_dir);
                else
                {
                    file = file ? file : ns_d_file.File();
                    file.Copy(this.binaries[i], this.target_dir);
                }
            }

            this.dumper.AddAction(dir, "copying_installer_src_dir " + this.target_dir);

            if(file)
                this.dumper.AddAction(file, "copying_installer_src_files");

            if(dmp && dmp.IsDumper)
                dmp.AddAction(this.dumper,"dmpr_" + this.Name());
            else
            {
                this.Log("DoApplyInstall: Can't schedule actions - input dumper is undefined or not a dumper (!dmp.IsDumper)");
                return false;
            }
        }

        return true;
    }
    //###############################################################
    // DoCommit method definition
    //###############################################################
    this.ComponentISource.prototype.DoCommit = function (){return true;}
    //###############################################################
    // RestorePoint method definition
    //###############################################################
    this.ComponentISource.prototype.RestorePoint = function (st)
    { 
        var rp = st ? st : Storage("*");

        rp("target_dir").value = this.target_dir;

        ns.ComponentISource.superclass.RestorePoint.call(this, rp);

        return rp;
    }
}// namespace Root.component.isource