/*
micl - binaries (+ additional low level config files, like cache.xml & micl.js) copied into target system
*/

new function()
{    
    var ns_installer = Namespace("Root.installer");
    var ns_dump      = Namespace("Root.dumper");

    var base_script_dir = Origin.Directory();
    var load = function(name) {return required(FileSystem.MakePath(name, base_script_dir));};

    var ns_component = load("component.js");
    var ns_d_file    = load("dumper_file.js");
    
    var ns = this;
    //###############################################################
    // ComponentMICL constructor
    //###############################################################
    this.Create = this.Create || function(info, ex_init)
    {
        if(!info)
            return null;

        var inf = info.GetInfo();
        if(!inf)
            return null;

        var cmp = ns_installer.Installer.Components[inf.Id()];

        if(!cmp)
        {
            cmp = new ns.ComponentMICL();
            if(!cmp.Init(inf))
                return null;
        }   

        var cln = cmp.Clone();
        
        if(ex_init)
            ex_init.call(cln);

        return cln;
    }
    //###############################################################
    // ComponentMICL constructor from RestorePoint
    //###############################################################
    this.CreateFromRP = this.CreateFromRP || function(rp)
    {
        if(!rp || rp("id").value == "")
            return null;

        var cmp = ns_installer.Installer.Components[rp("id").value];
        
        if(!cmp)
        {
            cmp = new ns.ComponentMICL();
            if(!cmp.InitFromRP(rp))
                return null;
        }
            
        return cmp.Clone();
    }
    //###############################################################
    // ComponentMICL class definition
    //###############################################################
    this.ComponentMICL = this.ComponentMICL || function()
    {
        arguments.callee.superclass.constructor.call(this);
        this.obj_type = "micl_component";
    }
    //###############################################################
    // ComponentMICL is inherited from Component
    extend(this.ComponentMICL, ns_component.Component);
    //###############################################################
    // Init method definition
    //###############################################################
    this.ComponentMICL.prototype.Init = function(inf)
    {
        this.Log = log_helper("ComponentMICL id = " + inf.Id() + ": ");

        ns.ComponentMICL.superclass.Init.call(this, inf);

        this.pure = false; // virtual component, like general product
        
        this.binaries = [];
        this.target_dir = FileSystem.MakePath(inf.Id(), Cache.CacheDir());

        this.Log("target folder = " + this.target_dir);

        if( FileSystem.Exists(this.target_dir) )
            this.p_state(this.state_t.installed);
    
        return true;
    }
    //###############################################################
    // InitFromRP method definition
    //###############################################################
    this.ComponentMICL.prototype.InitFromRP = function(rp)
    {
        if(!rp || rp("id").value == undefined || rp("target_dir").value == undefined ) 
            return false;
        
        var id = rp("id").value;
        
        this.Log = log_helper("ComponentMICL id = " + id + ": ");
        ns.ComponentMICL.superclass.InitFromRP.call(this, rp);

        this.pure = false; // virtual component, like general product

        this.binaries = [];
        this.target_dir = rp("target_dir").value;

        this.Log("target folder = " + this.target_dir);

        if( FileSystem.Exists(this.target_dir) )
            this.p_state(this.state_t.installed);

        return true;
    }
    //###############################################################
    // AddSource method definition
    //###############################################################
    this.ComponentMICL.prototype.AddSource = function (source, mask)
    {
        if(!mask)
        { // add single entry
            if(source)
                this.binaries.push(source);
        }
        else
        { // add entries by mask
            var files = FileSystem.FindFiles(source, mask);
            for(var i in files)
                this.binaries.push(FileSystem.MakePath(files[i], source));
        }
    }
    //###############################################################
    // DoApplyRemove method definition
    //###############################################################
    this.ComponentMICL.prototype.DoApplyRemove = function (dmp)
    {    
        this.Log("DoApplyRemove action = " + this.GetAction() );

        if(this.Action() == this.action_t.remove && this.TestRemove()) // check that there isn't any other clients for this component and it can be removed
        {
            this.Log("will be removed");

            var dir = ns_d_file.Directory();
            dir.DelayedRemove(this.target_dir);
            this.dumper.AddAction(dir, "delayed remove of installer core dir " + this.target_dir);
            
            if(dmp && dmp.IsDumper)
                dmp.AddAction(this.dumper,"dmpr_" + this.Name());
            else
            {
                this.Log("DoApplyRemove: Can't schedule actions - input dumper is undefined or not a dumper (!dmp.IsDumper)");
                return false;
            }
        }
        else
            this.Log("will not be removed");

        return true;
    }
    //###############################################################
    // DoApplyInstall method definition
    //###############################################################
    this.ComponentMICL.prototype.DoApplyInstall = function (dmp)
    {    
        this.Log("DoApplyInstall action = " + this.GetAction() );

        if( this.GetAction() == this.action_t.install )
        {
            if(this.binaries.length == 0)
            {
                this.Log("nothing to install");
                return true;
            }

            this.Log("will be installed");

            var dir = ns_d_file.Directory();
            dir.Create(this.target_dir);
            
            var file = null;
            
            for(var i in this.binaries)
            {
                if(FileSystem.IsDirectory(this.binaries[i]))
                {
                    dir.Copy(this.binaries[i], this.target_dir);
                    dir.Upgrade(true);
                }
                else
                {
                    file = file ? file : ns_d_file.File();
                    file.Copy(this.binaries[i], this.target_dir);
                    file.Upgrade(true);
                }
            }
            
            this.dumper.AddAction(dir, "target dir " + this.target_dir + " configuring");
            if(file)
                this.dumper.AddAction(file, "copy_core_installer_files");

            if(dmp && dmp.IsDumper)
                dmp.AddAction(this.dumper,"dmpr_" + this.Name());
            else
            {
                this.Log("DoApplyInstall: Can't schedule actions - input dumper is undefined or not a dumper (!dmp.IsDumper)");
                return false;
            }

            this.Log("DoApplyInstall action = completed" );
        }

        return true;
    }
    //###############################################################
    // DoCommit method definition
    //###############################################################
    this.ComponentMICL.prototype.DoCommit = function (){return true;}
    //###############################################################
    // RestorePoint method definition
    //###############################################################
    this.ComponentMICL.prototype.RestorePoint = function (st)
    { 
        var rp = st ? st : Storage("*");

        rp("target_dir").value = this.target_dir;

        ns.ComponentMICL.superclass.RestorePoint.call(this, rp);

        return rp;
    }
}// namespace Root.component.micl