new function () {
    var ns_installer = Namespace("Root.installer");
    var ns_dump = Namespace("Root.dumper");
    
    var base_script_dir = Origin.Directory();
    var load = function(name) {return required(FileSystem.MakePath(name, base_script_dir));};

    var ns_component = load("component.js");
    var ns_cmp_src = load("component_source.js");

    var ns = this;
    //###############################################################
    // ComponentMSI constructor
    //###############################################################
    this.Create = this.Create || function (info, source, ex_init) 
    {
        if(!info)
            return null;

        var r_info = info.GetInfo();
        if(!r_info)
            return null;

        var cmp = ns_installer.Installer.Components[r_info.Id()];

        if (!cmp) {
            cmp = new ns.ComponentMSI();
            if (!cmp.Init(r_info, source))
                return null;
        }

        var cln = cmp.Clone();
        
        if(ex_init)
            ex_init.call(cln);

        return cln;
    }
    //###############################################################
    // ComponentMSI class definition
    //###############################################################
    this.ComponentMSI = this.ComponentMSI || function () {
        arguments.callee.superclass.constructor.call(this);
        this.obj_type = "msi_component";
    }
    //###############################################################
    // ComponentMSI is inheritted from Component
    extend(this.ComponentMSI, ns_component.Component);
    //###############################################################
    // Init method definition
    //###############################################################
    this.ComponentMSI.prototype.Init = function (inf, src) 
    {
        this.Log = log_helper("CmpMSI id = " + (inf.Name() ? inf.Name() : inf.Id())  + ": ");
        ns.ComponentMSI.superclass.Init.call(this, inf);

        this.pure = false; // virtual component, like general product

        this.m_src = src;
        this.m_msi_pcode = inf.Id();
        this.m_msi_path = (this.m_src && this.m_src.File) ? this.m_src.File() : "";
        
        this.Log("Init: msi_pcode = " + inf.Id() + " msi_path = \"" + this.m_msi_path + "\"");

        if(this.m_msi_path != "")
            Splash.Status(StringList.Format("[loading]", FileSystem.FileName(this.m_msi_path)));
        else
            Splash.Status(StringList.Format("[loading]"));

        this.m_product = WI.Product(this.m_msi_pcode, this.m_msi_path);

        if (this.m_product.IsInstalled()) 
            this.SetState(this.state_t.installed);
        
        this.Log("Extracting ProductName and ProductVersion");
        var tbl = this.m_product.Query("select * from Property where Property = 'ProductName' or Property = 'ProductVersion'");
        for (var i in tbl)
        {
            this.Log("Property Name = " + tbl[i].Property + " Value = " + tbl[i].Value);

            if (tbl[i].Property == "ProductName") 
            {
                //this.msi_pname  = tbl[i].Value;
                this.Name(tbl[i].Value);
            }
            else if (tbl[i].Property == "ProductVersion") 
            {
                //this.msi_pversion  = tbl[i].Value;
                this.Version(tbl[i].Value);
            }
        }
        this.Log("Extracting ProductName and ProductVersion completed");
        return true;
    }
    //###############################################################
    this.ComponentMSI.prototype.DoSourceRenew = function()
    {
        this.Log("Renew msi source");
        this.m_msi_path = (this.m_src && this.m_src.File) ? this.m_src.File() : "";

        this.m_product = WI.Product(this.m_msi_pcode, this.m_msi_path);

        if (this.m_product.IsInstalled()) 
            this.SetState(this.state_t.installed);
        
        this.Log("Extracting ProductName and ProductVersion");
        var tbl = this.m_product.Query("select * from Property where Property = 'ProductName' or Property = 'ProductVersion'");
        for (var i in tbl)
        {
            this.Log("Property Name = " + tbl[i].Property + " Value = " + tbl[i].Value);

            if (tbl[i].Property == "ProductName") 
            {
                //this.msi_pname  = tbl[i].Value;
                this.Name(tbl[i].Value);
            }
            else if (tbl[i].Property == "ProductVersion") 
            {
                //this.msi_pversion  = tbl[i].Value;
                this.Version(tbl[i].Value);
            }
        }
        this.Log("Extracting ProductName and ProductVersion completed");
    }
    /*
    this.ComponentMSI.prototype.Init = function (msi_pcode, msi_path) 
    {
        this.Log = log_helper("CmpMSI id = " + msi_pcode + ": ");
        ns.ComponentMSI.superclass.Init.call(this, msi_pcode);

        this.Log("Init: msi_pcode = " + msi_pcode + " msi_path = \"" + msi_path + "\"");

        this.pure = false; // virtual component, like general product

        //this.msi_pname  = "";
        //this.msi_pversion  = "";

        this.m_msi_pcode = msi_pcode;
        this.m_msi_path = msi_path;

        if(msi_path != "")
            Splash.Status(StringList.Format("[loading]", FileSystem.FileName(msi_path)));
        else
            Splash.Status(StringList.Format("[loading]"));

        this.m_product = WI.Product(this.m_msi_pcode, this.m_msi_path);

        if (this.m_product.IsInstalled()) 
            this.SetState(this.state_t.installed);
        
        this.Log("Extracting ProductName and ProductVersion");
        var tbl = this.m_product.Query("select * from Property where Property = 'ProductName' or Property = 'ProductVersion'");
        for (var i in tbl)
        {
            this.Log("Property Name = " + tbl[i].Property + " Value = " + tbl[i].Value);

            if (tbl[i].Property == "ProductName") 
            {
                //this.msi_pname  = tbl[i].Value;
                this.Name(tbl[i].Value);
            }
            else if (tbl[i].Property == "ProductVersion") 
            {
                //this.msi_pversion  = tbl[i].Value;
                this.Version(tbl[i].Value);
            }
        }
        this.Log("Extracting ProductName and ProductVersion completed");
        return true;
    }
    */
    //###############################################################
    // Size method definition
    //###############################################################
    this.ComponentMSI.prototype.Size = function (val)
    {
        if(val)
            this.m_size = val;
        else if(!this.m_size)
            this.m_size = this.m_product.Size();

        return this.m_size;
    }
    //###############################################################
    // DoApplyRemove method definition
    //###############################################################
    this.ComponentMSI.prototype.DoApplyRemove = function (dmp) 
    {
        this.Log("DoApplyRemove begin, Action: " + this.Action());
        if(this.Action() == this.action_t.remove && this.TestRemove()) // check that there isn't any other clients for this component and it can be removed
        {
            this.Log(this.Name()  + " will be removed");
            var dunit_msi = DumperAction.MSI({ Path: ((this.m_src && this.m_src.File) ? this.m_src.File() : ""), 
                                               ProductCode: this.m_msi_pcode, 
                                               Remove: true });
            this.dumper.AddAction(dunit_msi, "remove " + this.Name()).Attribute("countable", true);

            if(dmp && dmp.IsDumper)
                dmp.AddAction(this.dumper,"dmpr_" + this.Name());
            else
            {
                this.Log("DoApplyRemove: Can't schedule actions - input dumper is undefined or not a dumper (!dmp.IsDumper)");
                return false;
            }
        }

        this.Log("DoApplyRemove end");
        return true;
    }
    //###############################################################
    // DoApplyResolveSrc method definition
    //###############################################################
    this.ComponentMSI.prototype.DoApplyResolveSrc = function (dmp)
    {
        if (this.Action() == this.action_t.install) 
        {
            //this.Log(this.Name()  + " is going to be installed -> adding actions for source resolution");
            if(!this.m_src)
            {
                this.Log(Log.l_error, "DoApplyResolveSrc: Source is undefined - nothing to resolve!");
                return false;
            }

            var pre_build_op = this.m_src.Resolve();

            if(pre_build_op)
            {
                //pre_build_op.Group("Download");
                //this.src_dumper.AddAction(pre_build_op, "download_for" + this.Name());
                //if(dmp && dmp.IsDumper)
                //    dmp.AddAction(this.src_dumper,"src_dmpr_" + this.Name());

                pre_build_op.Group("Download");
                if(dmp && dmp.IsDumper)
                    dmp.AddAction(pre_build_op, "resolving_sources_for" + this.Name());
                else
                {
                    this.Log("DoApplyResolveSrc: Can't schedule actions - input dumper is undefined or not a dumper (!dmp.IsDumper)");
                    return false;
                }
            }
            else
            {
                this.Log("DoApplyResolveSrc: Nothing actions required for sources resolution");
            }
        }
        return true;
    }
    //###############################################################
    // DoApplyInstall method definition
    //###############################################################
    this.ComponentMSI.prototype.DoApplyInstall = function (dmp)
    {
        //if(this.GetAction() != this.action_t.remove) 
        if(this.Action() == this.action_t.install) 
        {
            this.Log(" will be installed");
            //BASEINSTALLDIR="C:\Program Files (x86)\Intel\" EXTERNALUI=PSET TOTAL_COST=1670104 PSETSETUP="F:\w_ccompxe_ia32_2013.1.111\Setup.exe" PSET_UI_MODE=Full PSET_INSTALL_MODE=Install EVAL=0
            var params = "INSTALLDIR=\"" + this.InstallDir() + "\" ";
            
            if(!this.m_src || !this.m_src.File || !this.m_src.File())
            {
                this.Log(Log.l_error, "Source is undefined - component can't be installed!");
                return false;
            }

            for(var opt in this.CnfgOpts)
                params += opt + "=" + this.CnfgOpts[opt] + " ";
            
            var dunit_msi = DumperAction.MSI(
                { Path: this.m_src.File(),
                    ProductCode: this.m_msi_pcode,
                    Parameters: params,
                    Install: true
                });

            this.dumper.AddAction(dunit_msi, "install " + this.Name()).Attribute("countable", true);
            
            //DoApplyResolveSrc is done befor DoApplyInstall
            //if(!this.src_dumper.IsEmpty()) // if required actions for source resolution then regular dumper should depend on it
            //{
                //this.Log("source required resolution -> install dumper depend on resolution dumper");
                //this.dumper.Dependencies.Add(this.src_dumper);
            //}
            
            if(dmp && dmp.IsDumper)
            {
                //this.DoApplyResolveSrcH(dmp);
                dmp.AddAction(this.dumper,"dmpr_" + this.Name());
            }
            else
            {
                this.Log("DoApplyInstall: Can't schedule actions - input dumper is undefined or not a dumper (!dmp.IsDumper)");
                return false;
            }

            //ns_installer.Installer.Dumper.AddAction(this.dumper, "dmpr_" + this.Name());
        }
        return true;
    }
    //###############################################################
    // DoCommit method definition
    //###############################################################
    this.ComponentMSI.prototype.DoCommit = function (){return true;}
    //###############################################################
    // RestorePoint method definition
    //###############################################################
    this.ComponentMSI.prototype.RestorePoint = function (st) 
    {
        var rp = st ? st : Storage("*");

        rp("msi_pcode").value = this.m_msi_pcode;
        rp("msi_path").value = ((this.m_src && this.m_src.File) ? this.m_src.File() : "");

        ns.ComponentMSI.superclass.RestorePoint.call(this, rp);

        return rp;
    }
} // namespace Root.component.msi

//##########################################################
// Backup
//##########################################################
/*
    //###############################################################
    // ComponentMSI constructor from RestorePoint
    //###############################################################
    this.CreateFromRP = this.CreateFromRP || function (rp) {
        if (!rp || rp("msi_pcode").value == "")
            return null;

        var cmp = ns_installer.Installer.Components[rp("msi_pcode").value];

        if (!cmp) {
            cmp = new ns.ComponentMSI();
            if (!cmp.InitFromRP(rp))
                return null;
        }

        return cmp.Clone();
    }
*/
/*
    //###############################################################
    // InitFromRP method definition
    //###############################################################
    this.ComponentMSI.prototype.InitFromRP = function (rp) 
    {
        if (!rp || rp("msi_pcode").value == undefined)
            return false;

        var id = rp("msi_pcode").value;

        this.Log = log_helper("ComponentMSI id = " + id + ": ");
        ns.ComponentMSI.superclass.InitFromRP.call(this, rp);
        this.Log("InitFromRP");

        this.pure = false; // virtual component, like general product
        this.msi_pname  = "";
        this.msi_pversion  = "";

        this.m_msi_pcode = rp("msi_pcode").value;
        this.m_msi_path = "";

        this.m_product = WI.Product(this.m_msi_pcode, this.m_msi_path);

        if (this.m_product.IsInstalled())
            this.SetState(this.state_t.installed);
        
        var tbl = this.m_product.Query("select * from Property where Property = 'ProductName' or Property = 'ProductVersion'");
        for (var i in tbl) 
        {
            this.Log("Property Name = " + tbl[i].Property + " Value = " + tbl[i].Value);

            if (tbl[i].Property == "ProductName") 
            {
                this.msi_pname  = tbl[i].Value;
            }
            else if (tbl[i].Property == "ProductVersion") 
            {
                this.msi_pversion  = tbl[i].Value;
                this.Version(this.msi_pversion);
            }
        }

        return true;
    }
*/