new function () {
    var base_script_dir = Origin.Directory();
    var load = function(name) {return required(FileSystem.MakePath(name, base_script_dir));};

    var ns_installer = load("installer.js");
    var ns_base_cmp  = load("component3.js");
    var ns_prc       = load("component_processor_msi.js");

    var ns = this;
    //###############################################################
    // ComponentMSI constructor
    //###############################################################
    //###############################################################
    // Component constructor
    // input hash object has following fields:
    //  Mandatory:
    //      Info
    //  Optional:
    //      Source
    //      Processor
    //      StateManager
    //      ExInit - callback which is called for created component for additional initialization
    //               as ExInit.call(component); 
    //###############################################################
    this.Create = function (_in) 
    {
        if(!_in)
            return null;
        
        if(!_in.Info)
            return null;

        var r_info = _in.Info.GetInfo();
        if(!r_info || !r_info.Id || !r_info.Id())
        {
            Log(Log.l_error, "Attempt to create component with undefined Id - input info isn't defined or doesn't have Id or Id() is empty");
            return null;
        }

        var cmp = ns_installer.Installer.Components[r_info.Id()];

        var args = {};
        
        for(var i in _in)
            args[i] = _in[i];

        args.Info = r_info;

        if (!cmp)
        {
            cmp = ns.Component(args);

            if(!cmp)
                return null;
        }

        var cln = cmp.Clone();
        
        //if(_in.ExInit)
        //    _in.ExInit.call(cln);

        return cln;
    }
    //###############################################################
    // 
    //###############################################################
    this.Component = function(_in)
    {
        if(!_in.Processor)
            _in.Processor = ns_prc.ProcessorMSI();

        var cmp = ns_base_cmp.Component(_in);

        cmp.Log = log_helper("ComponentMSI id = " + cmp.Id() + ": ");

        cmp.Type("msi_component");

        return cmp;
    }
} // ComponentMSI