new function ()
{
    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};

    var ns_enums = load("enums.js");
    var ns = this;

    var db_only = function() {return GetOpt.Exists("db-processor");}

    this.Processor = function()
    {
        var proc = {};
        var m_owner = null;

        ns_enums.BindTo(proc);

        proc.Owner = function(obj)
        {
            if(obj)
                m_owner = obj;

            return m_owner;
        }
        proc.IsInstalled = function() { return false; }
        proc.InstallParams = function() {return m_owner ? m_owner.InstallConfigurationOptions().String() : "";}
        proc.RemoveParams = function() {return m_owner ? m_owner.RemoveConfigurationOptions().String() : "";}
        proc.State = function ()
        {
            if(proc.IsInstalled())
                return proc.state_t.installed;

            return this.state_t.absent;
        }
        proc.Commit = function(){return true;}
        proc.RemoveAct = function (){return {};}
        proc.InstallAct = function (){return {};}
        proc.RepairAct = function (){return {};}

        return proc;
    }
    //######################################################################
    var cmp_hive = "ComponentDBStore::";
    this.ProcessorDB = function()
    {
        var db_proc = ns.Processor();
        var self = db_proc;
        var st = Storage(cmp_hive + "*");

        db_proc.IsInstalled = function()
        {
            st("initialized").value = 1;
            st.Read(cmp_hive + db_proc.Owner().Id());
            if(st("installed").value == "1")
                return true;

            return false;
        }

        db_proc.RemoveAct = function() 
        {
            var prg = Progress();
            prg.total = 1;
            prg.message = StringList.Format("[removing]", db_proc.Owner().Info().Name());
        
            var db = {};

            db.Apply = function()
            {
                Log("RemoveAct: apply, id = " + db_proc.Owner().Id());
                Storage("*").Write(cmp_hive + db_proc.Owner().Id());

                return Action.r_ok;
            }

            db.ProgressApply = function() {return prg;}

            return db;
        }

        db_proc.InstallAct = function()
        {
            var prg = Progress();
            prg.total = 1;
            prg.message = StringList.Format("[installing]", db_proc.Owner().Info().Name());

            var db = {};

            db.Apply = function()
            {
                Log("InstallAct: apply, id = " + db_proc.Owner().Id());
                st("id").value = db_proc.Owner().Id();
                st("name").value = db_proc.Owner().Name();
                st("installed").value = "1";
                st("parameters").value = db_proc.Owner().ConfigurationOptions().String();
                st.Write(cmp_hive + db_proc.Owner().Id());

                return Action.r_ok;
            }

            db.Rollback = function()
            {
                var rmact = self.RemoveAct();
                if(rmact.Apply)
                    return rmact.Apply();

                return Action.r_ok;
            }

            db.ProgressApply = function() {return prg;}

            return db;
        }
        
        db_proc.RepairAct = function()
        {
            var prg = Progress();
            prg.total = 1;
            prg.message = StringList.Format("[installing]", db_proc.Owner().Info().Name());

            var db = {};

            db.Apply = function()
            {
                Log("RepairAct: apply, id = " + db_proc.Owner().Id());
                st("id").value = db_proc.Owner().Id();
                st("name").value = db_proc.Owner().Name();
                st("installed").value = "1";
                st("repaired").value = "1";
                st("parameters").value = db_proc.Owner().ConfigurationOptions().String();
                st.Write(cmp_hive + db_proc.Owner().Id());

                return Action.r_ok;
            }

            db.Rollback = function()
            {
                return Action.r_ok;
            }

            db.ProgressApply = function() {return prg;}

            return db;
        }
        
        return db_proc;
    }
}

