new function ()
{
    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};

    var ns_proc = load("component_processor.js");

    var db_only = function() {return GetOpt.Exists("db-processor");}

    
    /*
        registry version
        registry uninstall string
        registry existence - key/value/type (filesystem, none)
        exit codes
        ignore errors
        --------------------------
        RegRoot == 'HKLM'
        RegWow  == true/1
        RegKey   - no default value
        RegValue - no default value

        Version**
        UninstallString**
        Exists**+type (type == file/none)

    */
    
    //###################################################################################
    // EXE processor
    //###################################################################################
    this.ProcessorExe = function()
    {
        if(db_only())
            return ns_proc.ProcessorDB();

        var exe_proc = ns_proc.Processor();
        var self = exe_proc;

        var get_value = function(name)
        {
            if(name && exe_proc.Owner() && exe_proc.Owner().Info())
            {
                var info = exe_proc.Owner().Info();

                var get_val = function(name)
                {
                    if(typeof(info.Property(name + "RegValue")) != "undefined")
                        return info.Property(name + "RegValue");
                    return null;
                }

                var get_reg = function(name)
                {
                    if(info.Property(name + "RegKey"))
                        var key_name = info.Property(name + "RegKey");
                    else if(info.Property("RegKey")) // using default reg key
                        var key_name = info.Property("RegKey");
                    else
                        return null;

                    if(info.Property(name + "RegRoot"))
                        var root_name = info.Property(name + "RegRoot");
                    else if(info.Property("RegRoot"))
                        var root_name = info.Property("RegRoot")
                    else
                        var root_name = "HKLM";

                    if(info.Property(name + "RegWow"))
                        var wow = info.Property(name + "RegWow");
                    else if(info.Property("RegWow"))
                        var wow = info.Property("RegWow")
                    else
                        var wow = true;

                    var reg = Registry(root_name, key_name);
                    if(wow == "false" || wow == "0")
                        reg.WowRedirect(false);
                    return reg;
                }

                var value_name = get_val(name);
                if(value_name)
                {
                    var reg = get_reg(name);
                    if(reg && reg.Exists())
                        return reg.Value(value_name);
                }
            }

            return null;
        }

        exe_proc.IsInstalled = function()
        {
            Log("Exe component: check for existence");
            var owner = exe_proc.Owner();
            if(owner && owner.Info())
            {
                Log("Exe component: " + owner.Name());
                var info = owner.Info();

                var ex = get_value("Exists");
                if(ex)
                {
                    var ex_file = info.Property("ExistsFile");
                    if(ex_file)
                    {
                        var p = FileSystem.AbsPath(ex, ex_file);
                        if(!FileSystem.Exists(p))
                            return false;
                    }

                    var ver = get_value("Version");
                    if(ver)
                        return owner.Version().eq(ver);
                }
            }

            return false;
        }

        exe_proc.ActualVersion = function()
        {
            return get_value("Version");
        }

        var install_cmd = function() {return '"' + exe_proc.Owner().Source().File() + '" ' + exe_proc.InstallParams();}
        var remove_cmd = function()
        {
            var cmd = get_value("UninstallString");
            if(cmd)
            {
                var args = exe_proc.RemoveParams();
                if(args)
                    cmd = cmd + " " + args;
                return cmd;
            }
            return null;
        }

        var failed = function(code, ignore_codes_txt)
        {
            if(code)
            {
                Log("Process exit code: " + code);
                var ignore = [];
                var ar = ignore_codes_txt.split(/\D+/);
                for(var i in ar)
                    ignore.push(parseInt(ar[i]));

                for(var i in ignore)
                    if(code == ignore[i])
                    {
                        Log("  Ignored due to config");
                        return false;
                    }
                return true;
            }
            return false;
        }


        exe_proc.InstallAct = function()
        {
            var cmd_params = exe_proc.InstallParams();

            var cmd_exe = '"' + exe_proc.Owner().Source().File() + '" ' + cmd_params;

            var prg = Progress();
            prg.total = -1;
            prg.message = StringList.Format("[installing]", exe_proc.Owner().Info().Name());

            var exe = {};

            exe.Apply = function()
            {
                Log("Install launch cmd: " + install_cmd());
                var res = CreateProcess(null, cmd_exe, true);
                Log("   res.output = " + res.output);
                Log("   res.exitcode = " + res.exitcode);
                Log("   res.failed = " + res.failed);

                if(exe_proc.Owner() && exe_proc.Owner().Info())
                {
                    var info = exe_proc.Owner().Info();
                    if(info.Property("InstallIgnoreErrors"))
                        var ignore_errors = (info.Property("InstallIgnoreErrors") == "true");
                    else if(info.Property("IgnoreErrors"))
                        var ignore_errors = (info.Property("IgnoreErrors") == "true");
                    else
                        var ignore_errors = false;

                    var ignore_codes_txt = "";
                    if(info.Property("InstallIgnoreCodes"))
                        var ignore_codes = info.Property("InstallIgnoreCodes");
                    else if(info.Property("IgnoreCodes"))
                        var ignore_codes = info.Property("IgnoreCodes");
                }

                if(!ignore_errors && (res.failed || failed(res.exitcode, ignore_codes)))
                {
                    GlobalErrors.Add("[exe_failed]");
                    GlobalErrors.Add(StringList.Format("[exe_failed_name]", FileSystem.FileName(exe_proc.Owner().Source().File())));

                    if(res.failed)
                        GlobalErrors.Add("[exe_failed_to_start]");

                    if(res.exitcode)
                        GlobalErrors.Add(StringList.Format("[exe_failed_result]", res.exitcode));

                    this.Rollback();
                    return Action.r_error;
                }

                return Action.r_ok;
            }

            exe.Rollback = function()
            {
                if(exe_proc.IsInstalled())
                {
                    Log("Rollback launch cmd: " + remove_cmd());
                    var res = CreateProcess(null, cmd_exe, true);
                    Log("   res.output = " + res.output);
                    Log("   res.exitcode = " + res.exitcode);
                    Log("   res.failed = " + res.failed);
                }
                else
                    Log("Rollback: component is not installed. Skip.");

                return Action.r_ok;
            }

            exe.ProgressApply = function() {return prg;}

            return exe;
        }

        exe_proc.RemoveAct = function ()
        {
            var cmd_exe = remove_cmd();

            var prg = Progress();
            prg.total = -1;
            prg.message = StringList.Format("[removing]", exe_proc.Owner().Info().Name());

            var exe = {};

            exe.Apply = function()
            {
                if(exe_proc.IsInstalled())
                {
                    Log("Remove launch cmd: " + cmd_exe);
                    var res = CreateProcess(null, cmd_exe, true);
                    Log("   res.output = " + res.output);
                    Log("   res.exitcode = " + res.exitcode);
                    Log("   res.failed = " + res.failed);

                    if(exe_proc.Owner() && exe_proc.Owner().Info())
                    {
                        var info = exe_proc.Owner().Info();
                        if(info.Property("RemoveIgnoreErrors"))
                            var ignore_errors = (info.Property("RemoveIgnoreErrors") == "true");
                        else if(info.Property("IgnoreErrors"))
                            var ignore_errors = (info.Property("IgnoreErrors") == "true");
                        else
                            var ignore_errors = false;

                        var ignore_codes_txt = "";
                        if(info.Property("RemoveIgnoreCodes"))
                            var ignore_codes = info.Property("RemoveIgnoreCodes");
                        else if(info.Property("IgnoreCodes"))
                            var ignore_codes = info.Property("IgnoreCodes");
                    }

                    if(!ignore_errors && (res.failed || failed(res.exitcode, ignore_codes)))
                    {
                        GlobalErrors.Add("[exe_failed]");
                        GlobalErrors.Add(StringList.Format("[exe_failed_name]", cmd_exe));

                        if(res.failed)
                            GlobalErrors.Add("[exe_failed_to_start]");

                        if(res.exitcode)
                            GlobalErrors.Add(StringList.Format("[exe_failed_result]", res.exitcode));

                        this.Rollback();
                        return Action.r_error;
                    }
                }

                return Action.r_ok;
            }

            exe.ProgressApply = function() {return prg;}

            return exe;
        }

        return exe_proc;
    }
}



