new function ()
{
    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};

    var ns_proc = load("component_processor.js");

    var db_only = function() {return GetOpt.Exists("db-processor");}

    //###################################################################################
    // MSI processor
    //###################################################################################
    this.ProcessorMSI = function()
    {
        if(db_only())
            return ns_proc.ProcessorDB();

        var msi_proc = ns_proc.Processor();
        var self = msi_proc;
        var feature_name = null;

        var feature_map = null;

        msi_proc.InstallDirPropertyName = "INSTALLDIR";

        var orig_owner_func = msi_proc.Owner;
        msi_proc.Owner = function(obj)
        {
            if(obj)
            {
                Log("Register InstallDirPropertyName for: " + obj.Name());
                obj.ConfigurationOptions().Add(msi_proc.InstallDirPropertyName, function(){return obj.InstallDir();});

                feature_name = obj.Info().Property("HeadFeature");
                if(feature_name)
                    Log("Head feature: " + feature_name);
            }
            return orig_owner_func.apply(this, arguments);
        }
        
        var fea_list = function()
        {
            if(feature_map && feature_map.Get(feature_name))
            {
                var c = feature_name;
                var childs = feature_map.Get(feature_name).Deep.Childs(function(f) {c = c + "," + f.Id(); return false;});
                return c;
            }
            else if(feature_name)
                return feature_name;
            else
                return undefined;
        }
        
        msi_proc.RemoveAct = function ()
        {
            Log("ProcessorMSI: getting RemoveAct");

            if(feature_name)
            {
                msi_proc.Owner().RemoveConfigurationOptions().Add("REMOVE", fea_list);
                Log("ProcessorMSI-configure: parameters: " + msi_proc.RemoveParams());
                var dunit_msi = DumperAction.MSI({ Path: ((msi_proc.Owner().Source() && msi_proc.Owner().Source().File && msi_proc.Owner().Source().File()) ? msi_proc.Owner().Source().File() : ""), 
                                                   ProductCode: msi_proc.Owner().Info().Property("ProductCode"),
                                                   Parameters: msi_proc.RemoveParams(),
                                                   Configure: true });
            }
            else
            {
                msi_proc.Owner().RemoveConfigurationOptions().Delete("REMOVE");
                Log("ProcessorMSI-remove: parameters: " + msi_proc.RemoveParams());
                var dunit_msi = DumperAction.MSI({ Path: ((msi_proc.Owner().Source() && msi_proc.Owner().Source().File && msi_proc.Owner().Source().File()) ? msi_proc.Owner().Source().File() : ""), 
                                                   ProductCode: msi_proc.Owner().Info().Property("ProductCode"),
                                                   Parameters: msi_proc.RemoveParams(),
                                                   Remove: true });
            }


            return dunit_msi;
        }

        var product = function()
        {
            if(msi_proc.Owner() && msi_proc.Owner().Info())
            {
                return WI.Product(msi_proc.Owner().Info().Property("ProductCode"), 
                                 (msi_proc.Owner().Source() && msi_proc.Owner().Source().File &&
                                  msi_proc.Owner().Source().File()) ? msi_proc.Owner().Source().File() : "");
            }
            return null;
        }

        msi_proc.InstallAct = function()
        {
            Log("ProcessorMSI: getting InstallAct");

            if(!msi_proc.Owner())
            {
                Log("Could not detect component to process: no owner");
                return null;
            }

            if(feature_name)
                msi_proc.Owner().ConfigurationOptions().Add("ADDLOCAL", fea_list());
            else
                msi_proc.Owner().ConfigurationOptions().Delete("ADDLOCAL");

            var cmd_params = msi_proc.InstallParams();
            
            if(!(msi_proc.Owner().Source() && msi_proc.Owner().Source().File && msi_proc.Owner().Source().File()))
            {
                Log(Log.l_error, "Source is undefined - component can't be installed!");
                return null;
            }
            
            if(feature_name && feature_map && feature_map.Get(feature_name))
            {
                var pro = product();
                if(pro)
                {
                    var fea = "";
                    feature_map.Get(feature_name).Deep.Tree(function(f)
                    {
                        if(f && !pro.IsFeatureInstalled(f.Id()))
                            fea = fea + (fea ? "," : "") + f.Id();
                    });
                    if(fea)
                        msi_proc.Owner().RemoveConfigurationOptions().Add("REMOVE", fea);
                }
            }
            else if(msi_proc.Owner().RemoveConfigurationOptions().String())
                msi_proc.Owner().RemoveConfigurationOptions().Add("REMOVE", "ALL");

            Log("ProcessorMSI: parameters: " + cmd_params);
            Log("ProcessorMSI: rollback parameters: " + msi_proc.Owner().RemoveConfigurationOptions().String());

            var dunit_msi = DumperAction.MSI(
                { Path: msi_proc.Owner().Source().File(),
                  ProductCode: msi_proc.Owner().Info().Property("ProductCode"),
                  Parameters: cmd_params,
                  RollbackParameters: msi_proc.Owner().RemoveConfigurationOptions().String(),
                  EvaluateSignature: msi_proc.Owner().Signed ? msi_proc.Owner().Signed() : false,
                  Install: true
                });
            
            return dunit_msi;
        }

        msi_proc.RepairAct = function()
        {
            Log("ProcessorMSI: getting RepairAct");

            if(!msi_proc.Owner())
            {
                Log("Could not detect component to process: no owner");
                return null;
            }

            if(!(msi_proc.Owner().Source() && msi_proc.Owner().Source().File && msi_proc.Owner().Source().File()))
            {
                Log(Log.l_error, "Source is undefined - component can't be reinstalled!");
                return null;
            }
            
            var dunit_msi = DumperAction.MSI({ Path: msi_proc.Owner().Source().File(), Reinstall: true });
            
            return dunit_msi;
        }

        var installed = undefined;

        msi_proc.IsInstalled = function() 
        {
            if(typeof(installed) == "undefined")
            {
                installed = false;

                var pro = product();
                if(pro)
                {
                    if(pro.IsInstalled())
                    {
                        if(!feature_name)
                            installed = true;
                        else if(pro.IsFeatureInstalled(feature_name))
                            installed = true;
                    }
                }
            }
            return installed;
        }

        msi_proc.InstallDirProperty = function(name)
        {
            if(arguments.length)
            {
                Log("Update: Register InstallDirPropertyName for: " + this.Owner().Name());
                if(msi_proc.InstallDirPropertyName)
                    msi_proc.Owner().ConfigurationOptions().Delete(msi_proc.InstallDirPropertyName);
                if(name && msi_proc.Owner())
                    msi_proc.Owner().ConfigurationOptions().Add(name, function(){return msi_proc.Owner().InstallDir();});
                msi_proc.InstallDirPropertyName = name;
            }
            return msi_proc.InstallDirPropertyName;
        }

        msi_proc.FeatureName = function(fname)
        {
            if(arguments.length)
                feature_name = fname;
            return feature_name;
        }

        msi_proc.FeatureMap = function(map)
        {
            if(arguments.length)
            {
                feature_map = map;
                Log("FeatureMap: new map obtained");
            }
            return feature_map;
        }

        return msi_proc;
    }
}

