new function ()
{
    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};

    var ns_proc = load("component_processor.js");
    var ns_dmp  = load("dumper.js");
    var ns_fdmp = load("dumper_file.js");
    var ns_ddmp = load("dumper_db.js");

    var db_only = function() {return GetOpt.Exists("db-processor");}

    //###################################################################################
    // MSI processor
    //###################################################################################
    this.ProcessorZip = function()
    {
        if(db_only())
            return ns_proc.ProcessorDB();

        var db_key_name = "Component::ZIP"
        var files_key = "Files";

        var proc = ns_proc.Processor();

        var foreach = function(collection, cb)
        {
            for(var i in collection)
                if(cb(collection[i]))
                    return true;
            return false;
        }
        
        proc.InstallAct = function()
        {
            Log("ProcessorZIP: getting InstallAct");

            var dumper_file = ns_fdmp.File();
            var dumper_db = ns_ddmp.CreateAction();

            var dumper_config = {};
            var dumper_zip = {};

            var zip = undefined;
            var zip_path = undefined;
            var files = [];
            var storage = Storage("Zip::Processing::*");

            var get_zip = function()
            {
                if(zip)
                    return;

                Log("Opening Zip archive...");
                var owner = proc.Owner ? proc.Owner() : null;
                if(owner)
                {
                    var f = (owner.Source && owner.Source()) ? owner.Source().File() : null;
                    zip_path = f;
                    if(f)
                    {
                        Log("  File name: " + f);
                        if(FileSystem.Exists(f))
                        {
                            var z = Zip(f);
                            if(z && z.Valid())
                            {
                                Log("  Opened & valid");
                                foreach(z.FileList(), function(l)
                                {
                                    if(l)
                                    {
                                        l.path = FileSystem.AbsPath(owner.InstallDir(), l.name);
                                        files.push(l);
                                        Log("Zipped file: " + l.name);
                                    }
                                    return false;
                                });
                                files.push({path:owner.InstallDir(), directory:true});
                                zip = z;
                            }
                        }
                    }
                }
            }

            dumper_config.Apply = function()
            {
                Log("dumper_config.Apply started...");
                get_zip();
                if(!zip)
                {
                    GlobalErrors.Add(StringList.Format("[failed_to_open_archive]", FileSystem.FileName(zip_path)));
                    return Action.r_error;
                }

                if(zip && files.length)
                {
                    foreach(files, function(f)
                    {
                        Log("Processing item: " + f.path);
                        storage("files::*").value = f.path;
                        if(!f.directory)
                            dumper_file.Create(f.path);
                    });
                    storage("installed").value = 1;
                    dumper_db.Save(db_key_name + "::" + proc.Owner().Id(), storage);
                }

                return Action.r_ok;
            }

            dumper_zip.Apply = function()
            {
                if(zip)
                    zip.Extract(proc.Owner().InstallDir());

                return Action.r_ok;
            }

            dumper_zip.InstallProgress = function()
            {
                get_zip();
                if(zip)
                    return zip.Progress();
                return null;
            }

            var owner = proc.Owner ? proc.Owner() : null;
            if(owner)
            {
                var dumper = ns_dmp.Dumper("ZIP dumper: " + owner.Id());
                var act = dumper.AddAction(dumper_config, "ZIP configuration: " + owner.Id());
                dumper.AddAction(dumper_file, "ZIP file: " + owner.Id());
                dumper.AddAction(dumper_zip, "ZIP action: " + owner.Id());
                dumper.AddAction(dumper_db, "ZIP action: " + owner.Id());

                act.Attribute("countable", true);
                dumper.Attribute("name", owner.Name());

                dumper.hidden = true;

                return dumper;
            }

            return null;
        }

        proc.RepairAct = proc.InstallAct;

        proc.RemoveAct = function ()
        {
            Log("ProcessorZIP: getting RemoveAct");

            var dumper_file = ns_fdmp.File();
            var dumper_dir = ns_fdmp.Directory();
            var dumper_db = ns_ddmp.CreateAction();

            var owner = proc.Owner ? proc.Owner() : null;
            if(owner)
            {
                var storage = Storage("Zip::Processing::*");
                storage.Read(db_key_name + "::" + owner.Id());
                foreach(storage("files").childs, function(ch)
                {
                    var c = storage("files")(ch).value;
                    if(FileSystem.Exists(c))
                    {
                        if(FileSystem.IsDirectory(c))
                            dumper_dir.Remove(c, true);
                        else
                            dumper_file.Remove(c);
                    }
                });

                dumper_db.Delete(db_key_name + "::" + owner.Id());

                var dumper = ns_dmp.Dumper("ZIP dumper: " + owner.Id());
                var act = dumper.AddAction(dumper_file, "ZIP file: " + owner.Id());
                dumper.AddAction(dumper_dir, "ZIP directory: " + owner.Id());
                dumper.AddAction(dumper_db, "ZIP action: " + owner.Id());

                act.Attribute("countable", true);
                act.Attribute("name", owner.Name());

                dumper.hidden = true;

                return dumper;
            }

            return null;
        }

        var installed = undefined;

        proc.IsInstalled = function(refresh) 
        {
            if(typeof(installed) == "undefined" || refresh)
            {
                var owner = proc.Owner ? proc.Owner() : null;
                if(owner)
                {
                    installed = false;
                    var id = owner.Id();

                    if(id)
                    {
                        var stor = Storage("*::" + db_key_name);
                        stor.Read(db_key_name + "::" + id);
                        if(stor("installed").value)
                            installed = true;
                    }
                }
                else // owner not defined???
                    return false;
            }
            return installed;
        }

        return proc;
    }
}

