//###############################################################
// This file contains definition for:
//  enum ftr_state_t
//  class Feature
//###############################################################
//Namespace("Root.feature", function () 
new function ()
{
    var base_script_dir = Origin.Directory();
    var load = function(name) {return required(FileSystem.MakePath(name, base_script_dir));};

    var ns_event     = load("event.js");

    var blank_f = function(){return ""};
        
    var ns = this;

    function SortByOrder(a,b){ return (a.Order ? a.Order() : 100) - (b.Order ? b.Order() : 100);}
    //###############################################################
    // elements
    //###############################################################
    this.Container = function()
    {
        var cont = {};
        var items = {};
        var items_order = [];
        var on_add = ns_event.FEvent();
        var on_rm  = ns_event.FEvent();

        cont.Log = log_helper("Container: ");
        
        cont.Number = function() {return items_order.length;}

        cont.Order = function() { var arr = items_order.concat([]); return arr.sort(SortByOrder);}
        cont.Items = function() 
        { 
            var r = {};
            for(var i in items)
                r[i] = items[i].obj;

            return r;
        }
        cont.Item = function(id)
        {
            if(id)
                return items[id] ? items[id].obj : undefined;
        }
        cont.Exists = function(id){ return items[id] ? true : false; }

        cont.Transform = function(args)
        { 
            if(args.length == 1)
                return {id : args[0].Id(), obj : args[0]};

            if(args.length == 2)
                return {id : args[0], obj : args[1]};

            Log("Container: Transform: incorrect function call - more then 2 input parameters");
            return undefined;
        }

        cont.Add = function()
        {
            var args = arguments;

            var el = cont.Transform(args);
            
            if(!el)
            {
                cont.Log("attempt to add undefined item");
                return false;
            }
        
            if(el.id)
            {
                if(items[el.id])
                {
                    cont.Log("element with id = " + el.id + " already exists");
                    return true;
                }

                cont.Log("add element with id " + el.id);
                items_order.push(el.obj);
                items[el.id] = {obj : el.obj, ind : items_order.length - 1};

                var _args = arguments;
                on_add.apply(cont, _args);
            }
            else
            {
                cont.Log("can't add element with undefined id");
                return false;
            }

            return true;
        }

        cont.Add.Subscribe = function(cb) {on_add.Connect(cb);}

        cont.Remove = function(id)
        {
            if(!id)
            {
                cont.Log("attempt to remove item with undefined id");
                return false;
            }

            if(items[id])
            {
                items_order.splice(items[id].ind,1); // removing element from array
                var rem_el = items[id].obj;
                delete items[id];

                on_rm(rem_el);
                cont.Log("item with id = " + id + " was removed");
            }
            else
            {
                cont.Log("item with id = " + id + " doesn't present");
            }
        
            return true;
        }
        
        cont.Remove.Subscribe = function(cb) {on_rm.Connect(cb);}

        // iterate all items, with applying cb (callback function to call) until items end or cb returns false
        // returns true if all items were completed successfully and false otherwise
        cont.Apply = function(cb)
        {
            var self = arguments.callee;
            self.FailedItem = undefined;

            var arr = cont.Order();
            for(var i in arr)
                if(!cb(arr[i]))
                {
                    self.FailedItem = arr[i];
                    return false;
                }

            return true;
        }
        
        // iterate all items in reverse mode, with applying cb (callback function to call) until items end or cb returns false
        // returns true if all items were completed successfully and false otherwise
        cont.ApplyReverse = function(cb)
        {
            var self = arguments.callee;
            self.FailedItem = undefined;

            var arr = cont.Order();
            arr.reverse();
            
            for(var i in arr)
                if(!cb(arr[i]))
                {
                    self.FailedItem = arr[i];
                    return false;
                }

            return true;
        }

        // iterate all items, with applying cb (callback function to call) until items end or cb returns true
        cont.Filter = function(cb)
        {
            if(cb)
                for(var i in items_order)
                    if(cb(items_order[i]))
                        return true;

            return false;
        }

        return cont;
    }
}