new function()
{
    var ns = this;

    this.next = function(txt)
    {
        Wizard.Notify("next", "set text", txt);
    }

    this.prev = function(txt)
    {
        Wizard.Notify("prev", "set text", txt);
    }

    this.cancel = function(txt)
    {
        Wizard.Notify("cancel", "set text", txt);
    }

    this.button4 = function(txt)
    {
        Wizard.Notify("button4", "set text", txt);
    }

    this.stage = function(s)
    {
        var file = Origin.Directory() + "../Banners/" + s;
        Wizard.Notify("background", "set text", file);
    }

    this.buttons = function(n, p, c, b4)
    {
        if(n)
            this.next(n);

        if(p)
            this.prev(p);

        if(c)
            this.cancel(c);

        if(b4)
            this.button4(b4);
    }
    this.Buttons = this.buttons;

    //###############################################################
    // Title
    //###############################################################
    this.Title = function(product_title)
    {
        Wizard.Notify("title", "set text", product_title);
    }
    this.Title.BigIcon = function( icon_path )
    {
        if(icon_path)
            Wizard.Notify("title", "set big icon", icon_path);
    }
    this.Title.SmallIcon = function( icon_path )
    {
        if(icon_path)
            Wizard.Notify("title", "set small icon", icon_path);
    }
    //###############################################################
    // Header
    //###############################################################
    var header_template = FileSystem.ReadFileUTF8(FileSystem.MakePath("../Templates/header.rtf", Origin.Directory()));
    var header = "";
    var subheader = "";

    this.HeaderTemplate = function(path)
    {
        if(FileSystem.Exists(path))
        {
            if(!FileSystem.IsDirectory(path))
            {
                header_template = FileSystem.ReadFileUTF8(path);
            }
            else
                Log(Log.l_error, "HeaderTemplate: target path is directory: " + path);
        }
        else
            Log(Log.l_error, "HeaderTemplate: target file doesn't exist: " + path);
    }

    var update = function()
    {
        Wizard.Notify("header", "set rtf text", StringList.Format(header_template, header, subheader));
    }

    this.Header = function(str)
    {
        header = str;
        update();
    }

    this.SubHeader = function(str)
    {
        subheader = str;
        update();
    }

    var headers = {};

    this.DialogHeader = function(dialog, header, subheader)
    {
        if(dialog)
        {
            if(header || subheader)
            {
                if(!headers[dialog])
                    headers[dialog] = {};
                if(header)
                    headers[dialog].header = header;
                if(subheader)
                    headers[dialog].subheader = subheader;
            }
            else
            {
                if(headers[dialog])
                {
                    ns.Header(headers[dialog].header);
                    ns.SubHeader(headers[dialog].subheader);
                }
            }
        }
    }

    //###############################################################
    // Load
    //###############################################################
    this.Load = function(dir)
    {
        Log("Loading dialog scripts");
        if(!dir)
        {
            dir = FileSystem.MakePath("../dialogs", Origin.Directory());
        }
        Log("Loading dialog scripts, using directory: ", dir);

        var files = FileSystem.FindFiles(dir, "*.js");

        for(var i in files)
        {
            var item = files[i];
            var file = FileSystem.MakePath(item, dir);
            var dialog = required(file);

            if(dialog)
                dialog.Init.call(ns);
        }
    }
    //###############################################################
    // Stage
    //###############################################################
    var stage_directory = FileSystem.MakePath("../Banners/", Origin.Directory());

    this.Stage = function(file)
    {
        var file = FileSystem.MakePath(file, stage_directory);
        Wizard.Notify("background", "set text", file);
    }

    this.Stage.Directory = function(dir)
    {
        stage_directory = dir;
    }
    //###############################################################
    // Installer
    //###############################################################
    var installer;

    this.Installer = function(inst)
    {
        if(inst)
            installer = inst;
        else
            return installer;
    }

    var product;

    this.Product = function(prod)
    {
        if(prod)
            product = prod;
        else
            return product;
    }
}
