//###############################################################
// This file contains definition for:
//  class Dumper
//###############################################################
new function()
{
    var ns = this;

    var DLog = function(msg1, msg2)
    {
        //Log(msg1, msg2);
    }

    var DAction = function(obj, nm)
    {
        if(obj)
        {
            var name = nm ? nm : Guid();
            var holder = obj;
            var group = "";
            var attributes = {};

            var action = {};
            action.Apply = function()
            {
                return safecall(function(){return holder.Apply ? holder.Apply() : Action.r_ok;},
                                function(){Log(Log.l_error, "Exception handled calling Apply method of " + name); return Action.r_error;});
            }

            action.Rollback = function()
            {
                return safecall(function(){return holder.Rollback ? holder.Rollback() : Action.r_ok;},
                                function(){Log(Log.l_error, "Exception handled calling Rollback method of " + name); return Action.r_ok;});
            }

            action.Commit = function()
            {
                return safecall(function(){return holder.Commit ? holder.Commit() : Action.r_ok;},
                                function(){Log(Log.l_error, "Exception handled calling Commit method of " + name); return Action.r_ok;});
            }

            action.ProgressApply = function() {return holder.ProgressApply ? holder.ProgressApply() : null;}
            action.ProgressRollback = function() {return holder.ProgressRollback ? holder.ProgressRollback() : null;}
            action.ProgressCommit = function() {return holder.ProgressCommit ? holder.ProgressCommit() : null;}

            action.Skip = function()
            {
                return safecall(function(){return holder.Skip ? holder.Skip() : false;},
                                function(){Log(Log.l_error, "Exception handled calling Skip method of " + name + ". Action skipped"); return true;});
            }

            action.Group = function(grp)
            {
                if(arguments.length)
                    group = grp;
                else
                    return group;
            }

            action.Attribute = function(name, val)
            {
                if(arguments.length)
                {
                    if(arguments.length > 1)
                        attributes[name] = val;
                    else
                        return attributes[name];
                }

                return null;
            }

            action.Holder = function() {return holder;}

            action.Name = function() {return name;}

            return action;
        }

        return null;
    }

    this.Dumper = function(nm)
    {
        //###############################################################
        // Dumper class
        //###############################################################
        var dumper = {};

        dumper.IsDumper = true;

        var actions = [];

        var pre_act_dmp = null;
        var post_act_dmp = null;

        var m_id = Guid();
        var m_name = nm ? nm : m_id;

        //###############################################################
        dumper.Id = function(){return m_id;}
        //###############################################################
        dumper.Name = function(val)
        {
            if(val)
                m_name = val;
        
            return m_name;
        }
        //###############################################################
        dumper.AddAction = function(_act, nm)
        {
            if(!_act)
            {
                DLog(DLog.l_warning, "an attempt to add undefined DAction!");
                return;
            }
            if(!_act.IsDumper)
            {
                var a = DAction(_act, nm);
                actions.push(a);
                Log("Add action: " + dumper.Name() + " <= " + a.Name());
                return a;
            }
            else
            {
                actions.push(_act);
                Log("Add dumper: " + dumper.Name() + " <= " + _act.Name());
                return _act;
            }
        }

        dumper.Elements = function()
        {
            var el = dumper.Serialize();

            var elem = {};

            var index = 0;
            var reset = true;
            var reverse = false;

            elem.Reset = function() {index = 0; reset = true;}
            elem.Reverse = function(r) {if(arguments.length) {reverse = r; elem.Reset();} else return reverse;}

            elem.Next = function()
            {
                if(!el.length)
                    return false;
                else if(el.length && index >= el.length - 1 && !reset)
                {
                    DLog("  actions number: " + el.length);
                    DLog("  index: " + index);
                    DLog("  reset: " + reset);
                    index = el.length;
                    return false;
                }
                else
                {
                    if(reset)
                    {
                        reset = false;
                        index = 0;
                        return true;
                    }
                    else
                    {
                        index++;
                        return true;
                    }
                }
            }

            elem.Get = function()
            {
                DLog("  actions number: " + el.length);
                DLog("  index: " + index);
                DLog("  reset: " + reset);
                if(index >= el.length || !el.length || reset)
                    return null;
                if(!reverse)
                    return el[index];
                else
                    return el[el.length - index - 1];
            }

            return elem;
        }

        dumper.Serialize = function(deep)
        {
            if(!deep)
            {
                if(pre_act_dmp && pre_act_dmp.IsDumper)
                    v = [pre_act_dmp];
                else
                    v = [];

                if(actions)
                    v = v.concat(actions);

                if(post_act_dmp && post_act_dmp.IsDumper)
                    v.push(post_act_dmp);

                return v;
            }
            else
            { // return all actions (not dumpers) including all child elements
                if(pre_act_dmp && pre_act_dmp.IsDumper)
                    v = pre_act_dmp.Serialize(deep);
                else
                    v = [];

                if(actions)
                {
                    for(var i in actions)
                        if(actions[i].IsDumper)
                            v = v.concat(actions[i].Serialize(deep));
                        else
                            v.push(actions[i]);
                }

                if(post_act_dmp && post_act_dmp.IsDumper)
                    v = v.concat(post_act_dmp.Serialize(deep));

                return v;
            }
        }

        dumper.IsEmpty = function() {return dumper.Serialize(true).length == 0;}

        dumper.PreAction = function()
        {
            if(!pre_act_dmp)
                pre_act_dmp = ns.Dumper("Pre Action Dumper");

            return pre_act_dmp;
        }

        dumper.PostAction = function()
        {
            if(!post_act_dmp)
                post_act_dmp = ns.Dumper("Post Action Dumper");

            return post_act_dmp;
        }

        dumper.Group = function(grp)
        {
            for(var i in actions)
                actions[i].Group(grp);
            if(pre_act_dmp && pre_act_dmp.IsDumper)
                pre_act_dmp.Group(grp);
            if(post_act_dmp && post_act_dmp.IsDumper)
                post_act_dmp.Group(grp);
        }

        dumper.Attribute = function(attr, val)
        {
            for(var i in actions)
                actions[i].Attribute(attr, val);
            if(pre_act_dmp && pre_act_dmp.IsDumper)
                pre_act_dmp.Attribute(attr, val);
            if(post_act_dmp && post_act_dmp.IsDumper)
                post_act_dmp.Attribute(attr, val);
        }

        return dumper;
    }

    this.Iterator = function(_dumper)
    {
        var self = arguments.callee;

        var iterator = {};
        var dumper = _dumper;

        var name = dumper.Name();

        var elements = dumper.Elements();
        
        var def_functor = function(elem) {return elem.Apply();}
        var functor = def_functor;

        var def_filter = function() {return true;}
        var filter = def_filter;

        var transfer = null;

        var reset = true;

        iterator.Name = function() {return name;}

        iterator.Next = function()
        {
            DLog("Next to " + name);

            if(reset)
            { // start initialization
                DLog("  clean reset flag in " + name);
                reset = false;
                elements.Reset();
                transfer = null;
            }

            while(1)
            {
                if(transfer)
                {
                    DLog("  jump to transfer from " + name + " to " + transfer.Name());
                    var r = transfer.Next();
                    if(r)
                    {
                        DLog("  found element in transfer for " + name);
                        return r;
                    }
                    transfer = null;
                }

                if(!elements.Next()) // no more elements
                {
                    DLog("  no more elements in " + name);
                    transfer = null;
                    return false;
                }

                var item = elements.Get();
                if(item)
                {
                    if(item.IsDumper)
                    { // process nested dumper
                        DLog("  creating transfer element in " + name);
                        transfer = self(item);
                        transfer.Reverse(elements.Reverse());
                        transfer.Filter(filter);
                        transfer.Functor(functor);
                    }
                    else
                    {
                        DLog("  native element found in " + name);
                        transfer = null;
                        if(filter(item))
                            return true;
                        else
                            DLog("  native element is filtered " + name);
                    }
                }
                else
                { // failed to get element... just return
                    DLog("  ERROR: failed to get element in " + name);
                    transfer = null;
                    return false;
                }
            }
        }

        iterator.Reset = function()
        {
            reset = true;
            elements.Reset();
            transfer = null;
        }

        iterator.Reverse = function(r)
        {
            if(arguments.length)
                elements.Reverse(r);
            else
                elements.Reverse(true);
            iterator.Reset();
        }

        iterator.Call = function(f)
        {
            if(transfer)
            {
                if(f)
                    return transfer.Call(f);
                var res = transfer.Call(f);
            }
            else
            {
                if(f)
                    return f(elements.Get());
                var elem = elements.Get();
                DLog("Calling functor with element: " + elem);
                var res = functor(elem);
            }

            if(res != Action.r_ok && res != true)
            {
                Log("  error detected in " + name);
                Log("  error code: " + res + ". expected: " + Action.r_ok);
                if(dumper.OnError)
                {
                    Log("  calling error handler");
                    return dumper.OnError(iterator, res);
                }
            }
            return res;
        }

        iterator.Functor = function(func)
        {
            if(func)
                functor = func;
            else
                functor = def_functor;
        }

        iterator.Filter = function(f)
        {
            if(f)
                filter = f;
            else
                filter = def_filter;
        }

        iterator.Get = function()
        {
            if(transfer)
                return transfer.Get();
            else
                return elements.Get();
        }

        iterator.Dumper = function() {return dumper;}

        return iterator;
    }

    this.Trace = function(dmp)
    {
        Log("Tracing dumper: " + dmp.Name());
        var iter = ns.Iterator(dmp);
        while(iter.Next())
            Log("Trace action: " + iter.Get().Name() + " countable: " + (iter.Get().Attribute("countable") ? "true" : "false"));
    }
}

