
new function()
{
    this.File = function()
    {
        var act = DumperAction.File();

        act.Upgrade = function(upg)
        {
            if(upg)
                return act.Configure("upgrade");
            else
                return act.Configure("process_all");
        }

        act.Create = function(path)
        {
            return act.Configure({action:"file_create", path:path});
        }

        act.Copy = function(src, dst)
        {
            return act.Configure({action:"file_copy", source:src, target:dst});
        }

        act.Move = function(src, dst)
        {
            return act.Configure({action:"file_move", source:src, target:dst});
        }

        act.Remove = function(path)
        {
            return act.Configure({action:"file_delete", path:path});
        }

        act.DelayedRemove = function(path)
        {
            return act.Configure({action:"delete_delayed", path:path});
        }

        act.DelayedReboot = function()
        {
            return act.Configure({action:"delayed_reboot"});
        }

        act.IgnoreErrors = function(ignore)
        {
            if(ignore)
                return act.Configure("ignore_error");
            else
                return act.Configure("process_error");
        }

        return act;
    }

    this.Directory = function()
    {
        var act = DumperAction.File();

        act.Upgrade = function(upg)
        {
            if(upg)
                return act.Configure("upgrade");
            else
                return act.Configure("process_all");
        }

        act.Copy = function(src, dst)
        {
            return act.Configure({action:"dir_copy", source:src, target:dst});
        }

        act.CopyContent = function(src, dst)
        {
            return act.Configure({action:"dir_copy_content", source:src, target:dst});
        }

        act.Create = function(path)
        {
            return act.Configure({action:"dir_create", path:path});
        }

        act.Remove = function(path, not_empty)
        {
            return act.Configure({action:"dir_delete", path:path, not_empty:not_empty});
        }

        act.DelayedRemove = function(path)
        {
            return act.Configure({action:"delete_delayed", path:path});
        }

        act.DelayedReboot = function()
        {
            return act.Configure({action:"delayed_reboot"});
        }

        act.IgnoreErrors = function(ignore)
        {
            if(ignore)
                return act.Configure("ignore_error");
            else
                return act.Configure("process_error");
        }

        return act;
    }
}
