/** @file enums.js
 *  @brief Implementation of enumeration for installable objects states/action/etc
 *  @see product.js component.js
 */
new function()
{
    var ns = this;
    this.BindTo = function (obj)
    {
        if(!obj)
            return false;
        
        for(var key in ns)
        {
            if(key == "BindTo")
                continue;

            obj[key] = ns[key];
        }
        
        return true;
    }
    //###############################################################
    this.BelongToEnum = function(val, e)
    {
        if(!e)
            return false;

        for(var i in e)
            if(val == e[i])
                return true;

        return false;
    }
    //###############################################################
    /** @enum action_t
     *  @brief action_t -- actions enumeration
     *  @details Includes set of values to evaluate action applied to
     *    Component or Product object
     *  @item none    - do not apply any action to object
     *  @item install - install Component/Product
     *  @item remove  - uninstall Component/Product
     *  @item mix     - partially install Component/Product, applicable for Feature objects only
     *  @usage
     *    if(component.GetAction() == component.action_t.install)
     *    {
     *        // do something here
     *    }
     *  @see state_t
     */
    this.action_t = this.action_t || new function ()
    {
      this.none             = "none";
      this.install          = "install";
      this.reinstall        = "reinstall";
      this.remove           = "remove";
      this.repair           = "repair";
      this.mix              = "mix"; // for features - which can be partially installed
    }
    //###############################################################
    /** @enum state_t
     *  @brief state_t -- object's state enumeration
     *  @details Includes set of values to evaluate state applied to Component or Product object
     *  @item absent    - object is not installed
     *  @item installed - object is installed
     *  @usage
     *    if(component.GetState() == component.state_t.absent)
     *    {
     *        // do something here
     *    }
     *  @see action_t
     */
    this.state_t = this.state_t || new function ()
    {
      this.absent = "absent";
      this.installed = "installed";
    }
    //###############################################################    
    /** @enum install_scope_t
     *  @brief install_scope_t -- installation type enumeration
     *  @details Includes set of values to specify installation type
     *  @item per_machine - per-machine installation
     *  @item per_user    - per-user installation
     *  @see action_t state_t
     */
    this.install_scope_t = this.install_scope_t || new function ()
    {        
        this.per_machine    = "per_machine";
        this.per_user       = "per_user";
    }
    //###############################################################    
    /** @enum setup_type_t
     *  @brief setup_type_t -- GUI wizard type
     *  @details Includes set of values to specify GUI wizard type (default or custom)
     *  @item setup_default - default installation wizard
     *  @item setup_custom  - advanced/custom installation wizard
     *  @see action_t state_t
     */
    this.setup_type_t = this.setup_type_t || new function ()
    {        
        this.setup_default    = "default";
        this.setup_custom     = "custom";
    }
    //###############################################################
    // enum install_mode_t
    //###############################################################
    /** @enum install_mode_t
     *  @brief install_mode_t -- GUI wizard installation mode
     *  @details Includes set of values to specify GUI wizard installation mode
     *  @item install - install product wizard
     *  @item modify  - modify installed components wizard
     *  @item repair  - repair installed components wizard
     *  @item remove  - remove product wizard
     *  @see action_t state_t
     */
    this.install_mode_t = this.install_mode_t || new function () 
    {        
        this.install    = "install";
        this.modify     = "modify";
        this.repair     = "repair";
        this.remove     = "remove";
    }
    //###############################################################
    // enum upgrade_state_t
    //###############################################################
    this.upgrade_state_t = this.upgrade_state_t || new function () 
    {        
        this.none      = "nothing_installed";
        this.same      = "same_installed";
        this.upgrade   = "older_installed";
        this.downgrade = "newer_installed";
        this.mix       = "targets_with_diff_state_installed";
    }
    //###############################################################
    // enum upgrade_type_t
    //###############################################################
    this.upgrade_type_t  = this.upgrade_type_t  || new function () 
    {        
        this.optional    = "optional_upgrade";
        this.mandatory   = "mandatory_upgrade";
    }
    //###############################################################
    // enum upgrade_state_t
    //###############################################################
    this.disabled_t = this.disabled_t || new function () 
    {        
        this.yes = true;
        this.no  = false;
        this.mix = "mix";
    }
    /*
    //###############################################################
    // enum upgrade_action_t
    //###############################################################
    this.upgrade_state_t= this.upgrade_state_t|| new function () 
    {        
        this.allowed   = "allowed";
        this.forbidden = "forbidden";
    }
    */
}