new function()
{
    //###############################################################
    //class Event
    //###############################################################
    this.Event = function(owner)
    {
        this.owner = owner;
        this.processors = [];
    }
    //###############################################################
    // Connect method allows adding processor for current event
    //###############################################################
    this.Event.prototype.Connect = function (proc, obj)
    {
        if(!proc)
            return false;

        if(!obj)
            this.processors.push(proc);
        else
            this.processors.push(function(event_owner){proc.call(obj,event_owner);});

        return true;
    }
    //###############################################################
    // Clear method removes all processors for this event
    //###############################################################
    this.Event.prototype.Clear = function () { this.processors = []; }
    //###############################################################
    // Call method calling all processors with this defined with owner object
    //###############################################################
    this.Event.prototype.Call = function ()
    {
        var ns = this;
        for(var i in this.processors)
            safecall(function(){ns.processors[i](ns.owner);});
    }

    //###############################################################
    // FEvent - functor to be used as function
    //###############################################################
    this.FEvent = function()
    {
        var subscribers = [];

        var f = function()
        {
            for(var i in subscribers)
                if(subscribers[i])
                {
                    var ns = this;
                    var args = arguments;
                    safecall(function(){subscribers[i].apply(ns, args);},
                             function(){Log("Exception catched on calling FEvent: " + subscribers[i]);});
                }
        }

        f.Connect = function(func)
        {
            if(func)
                subscribers.push(func);
        }

        f.Call = function() {return f.apply(this, arguments);}

        f.Empty = function() {return subscribers.length == 0;}

        return f;
    }
}
