new function()
{
    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};

    var ns = this;
    var queue = load("queue.js");

    this.Executor = function()
    {
        var exec = {};

        var threads = [];
        var running = 0;
        var abort = false;

        var finished = queue.Queue();

        exec.AddThread = function(func)
        {
            if(func)
            {
                var thr = {};
                thr.queue = queue.Queue();
                thr.func = func;
                thr.tasks = 0;
                threads.push(thr);
            }
        }

        var thread_func = function(q, id)
        {
            if(q)
            {
                Log("Executor thread started to work: ", id);
                while(1)
                {
                    var task = q.Pop();
                    if(!task)
                    {
                        Log("Executor thread finished to work");
                        return 0;
                    }

                    safecall(function(){task();});
                    finished.Push(id);
                }
            }
        }
        
        exec.Start = function()
        {
            for(var i in threads)
            {
                var tf = function(){thread_func(threads[i].queue, i);};
                threads[i].thr = Thread(tf);
            }

            while(1)
            {
                if(abort)
                    break;

                for(var i in threads)
                {
                    if(abort)
                        break;
                    if(threads[i].tasks)
                        continue;
                    var task = threads[i].func();
                    if(task)
                    {
                        //Log("Executor got new task");
                        running++;
                        threads[i].tasks++;
                        threads[i].queue.Push(task);
                    }
                }

                if(abort || !running)
                    break;

                var id = finished.Pop();
                if(threads[id])
                    threads[id].tasks--;
                running--;
            }

            exec.Abort();

            for(var i in threads)
                threads[i].thr.Join();
        }

        exec.Abort = function()
        {
            for(var i in threads)
            {
                threads[i].queue.Clear();
                threads[i].queue.Push(null);
            }
        }

        return exec;
    }
}