//###############################################################
// This file contains definition for:
//  enum ftr_state_t
//  class Feature
//###############################################################
//Namespace("Root.feature", function () 
new function ()
{
    var base_script_dir = Origin.Directory();
    var load = function(name) {return required(FileSystem.MakePath(name, base_script_dir));};

    //var ns_component = Namespace("Root.component");
    var ns_installer = Namespace("Root.installer");
    var ns_component = load("component3.js");
    var ns_ftr_gui   = load("feature_gui.js");
    var ns_container = load("container.js");
    var ns_event     = load("event.js");
    var ns_enums     = load("enums.js");
    var ns_upgrade   = load("upgrade3.js");
    var ns_version   = load("version.js");
    var ns_dumper    = load("dumper.js");
    var ns_dir       = load("cascade_dir.js");
    var ns_prop_set  = load("property_set.js");
    var ns_prop      = load("property.js");
    var ns_cnfg      = load("configurator.js");

    var icons_dir = FileSystem.MakePath("Icons", FileSystem.Parent(Origin.Directory()));
    Node.icon_broken_menu = "icon_broken_menu";
    Action.FeatureTreeNodeIcon({image:icons_dir + "\\broken.png", id: "icon_broken_menu"});
    //###############################################################
    var P = function(val){return ns_prop.Property(val);}
    var ConstP = function(val){return ns_prop.Constant(val);}
    var PBool = function(val)
    {
      var p = ns_prop.Property(val);
      p.Transform = function(val){ return val ? true : false; }  
      return p;
    }

    var FilterNotEmpty = function(val)
    {
        if(typeof(val) == undefined || val == null) 
            return false;
        
        return true;
    }

    var PNotEmpty = function(val)
    {
      var p = ns_prop.Property(val);
      p.Filter = FilterNotEmpty;
      return p;
    }

    var PNumber = function(val)
    {
      var p = ns_prop.Property(val);
      p.Filter = function(val){ return (typeof(val) == "number" ? true : false); }
      return p;
    }

    var blank_f = function(){return ""};

    var ns = this;
    //###############################################################
    // Feature class
    //###############################################################
    var Feature = function(inf)
    {
        var ftr = {};
        ns_enums.BindTo(ftr);
        ns_ftr_gui.BindTo(ftr);

        ftr.Info = ConstP(inf);

        var m_size = 0;
        var m_error = ""; // error description
        //var m_prev_act = ftr.action_t.none;
        
        var m_action_update_in_prgrs = false; // for preventing cicle call of SetAction.
        var m_action_to_set = null;           // store info regarding new action to set

        //###############################################################
        ftr.ErrorHandler = P(function(){return false;})
        ftr.ErrorHandler.Filter = FilterNotEmpty;

        var p_action = P(ftr.action_t.none); // just for identifying implicit action change (i.e. when one of sub features' action was changed)
        var p_own_action = P(ftr.action_t.none); // just for identifying implicit action change (i.e. when one of sub features' action was changed)

        ftr.Dependencies = ConstP(ns_container.Container());
        //ftr.CustomObjects = ConstP(ns_container.Container());
        ftr.Parent = P();
        ftr.Type = P("feature");
        //var m_cnfg_opts = ns_prop_set.PropertySet();
        ftr.ConfigurationOptions = ConstP(ns_prop_set.PropertySet());

        ftr.Components = ConstP(ns_container.Container());
        ftr.Components().Add.Subscribe(function(cmp)
            {
                ftr.InstallDir.Cascade(cmp.InstallDir);
                ftr.Disabled.Cascade(cmp.Disabled);
                ftr.ConfigurationOptions().Cascade(cmp.ConfigurationOptions());
                cmp.InstallDir.Base(ftr.InstallDir());
                cmp.Parent(ftr);
                cmp.Action.Subscribe(ftr.ProcessChildActionChange);
            });

        ftr.Features = ConstP(ns_container.Container());
        ftr.Features().Add.Subscribe(function(iftr)
            {
                ftr.InstallDir.Cascade(iftr.InstallDir);
                ftr.ConfigurationOptions().Cascade(iftr.ConfigurationOptions());
                ftr.Disabled.Cascade(iftr.Disabled);
                iftr.InstallDir.Base(ftr.InstallDir());
                iftr.Parent(ftr);
                if(iftr.Visible() && !ftr.Visible())
                    iftr.Visible(false);
                ftr.Visible.Cascade(iftr.Visible);
                iftr.Action.Subscribe(ftr.ProcessChildActionChange);
            });

        ftr.Log            = log_helper("Feature name/id = " + (ftr.Info().Name ? ftr.Info().Name() : ftr.Info().Id()) + ": ");
        ftr.Components().Log = log_helper(ftr.Log.Prefix() + "Components: ");
        ftr.Features().Log   = log_helper(ftr.Log.Prefix() + "Features: ");
        ftr.Dependencies.Log = log_helper(ftr.Log.Prefix() + "Dependencies: ");
        //ftr.CustomObjects().Log = log_helper(ftr.Log.Prefix() + "CustomObjects: ");
        
        ftr.Id          = ftr.Info().Id;
        ftr.Name        = ftr.Info().Name;
        ftr.Version     = function(){return ns_version.Version(ftr.Info().Version());}
        ftr.Description = ftr.Info().Description;
        ftr.ErrorDescription = P(ftr.Info().ErrorDescription ? ftr.Info().ErrorDescription() : "");

        ftr.Upgrade  =  ConstP(new ns_upgrade.Upgrade(ftr));
        ftr.Groups = ConstP(ns_container.Container());
        
        ftr.Configurator = ConstP(ns_cnfg.FeatureConfigurator(ftr));
        ftr.InstallDir = ns_dir.Directory();
        //###############################################################
        ftr.Mandatory = PBool(false);
        ftr.Priority = PNumber(0);
        ftr.Order = PNumber(100);

        ftr.Offline = PBool(false);
        ftr.Offline.Filter = function(val){if(val) return true;}
        ftr.Offline.Subscribe(function(val)
        {
            if(val)
            {
                ftr.Components().Apply(function(el){el.Offline(true); return true;});
                ftr.Features().Apply(function(el){el.Offline(true); return true;});
            }
        });
        //###############################################################
        ftr.FeaturesFullSet = function() 
        {
            var set = {};
        
            ftr.Features().Apply(function(el)
            {
                set[el.Id()] = el;
                
                el.Features().Apply(function(_el){set[_el.Id()] = _el; return true;}); 
                return true;
            });

            return set;
        }
        //###############################################################
        ftr.ComponentsFullSet = function() 
        {
            var set = {};
        
            ftr.Components().Apply(function(el){set[el.Id()] = el; return true;});
        
            ftr.Features().Apply(function(el)
            {
                el.Components().Apply(function(_el){set[_el.Id()] = _el; return true;}); 
                return true;
            });

            return set;
        }
        //###############################################################
        // Detach
        //###############################################################
        ftr.Detach = function ()
        {
            ftr.Log("Detaching begin");
            if(ftr.Parent())
            {
                ftr.Parent().Features().Remove(ftr.Id());
                ftr.Parent(null);
            }

            ftr.Components().Apply(function(el){el.Detach(); return true;});
            ftr.Features().Apply(function(el){el.Detach(); return true;});

            ftr.DetachNode();
            ftr.Log("Detaching end");
        }
        //###############################################################
        //###############################################################
        // Add feature to specified Group
        //###############################################################
        ftr.AddToGroup = function (grp_id)
        {
            ftr.Log(" @@@ try add to group " + grp_id);
            if(!grp_id)
                return false;
        
            ftr.Log("@@@ add to group " + grp_id);

            ftr.Groups().Add(grp_id, grp_id);

            if(!ns_installer.Installer.Groups[grp_id])
                ns_installer.Installer.Groups[grp_id] = {};

            var grp = ns_installer.Installer.Groups[grp_id];
            grp[ftr.Id()] = ftr;
        
            return true;
        }
        //###############################################################
        // Check that feature belongs to specified Group
        //###############################################################
        ftr.InGroup = function (grp_id)
        {
            if(!grp_id) 
                return false;

            if(ftr.State() != ftr.state_t.installed)
                return false;
        
            if(!ns_installer.Installer.Groups[grp_id])
                ns_installer.Installer.Groups[grp_id] = {};

            if(ns_installer.Installer.Groups[grp_id][ftr.Id()] == ftr)
                return true;
        
            return false;
        }
        //###############################################################
        ftr.Root = function () 
        {
            var root = ftr;

            for (var parent = ftr.Parent(); parent; root = parent, parent = parent.Parent());

            return root;
        }
        //###############################################################
        ftr.Refresh = function () 
        {
            ftr.Features().Apply(function(el){el.Refresh(); return true;});

            ftr.RefreshNode();
        }
        //###############################################################
        // Disabled to store/receive disabled property
        //##############################################################
        ftr.Disabled = PBool();
        ftr.Disabled.Get = function()
        {
            var dis_val = undefined;
            var tmp_dis;

            var m_components = ftr.Components().Items();
            for (var cmp in m_components)
            {
                tmp_dis = m_components[cmp].Disabled();

                if(dis_val == undefined)
                    dis_val = tmp_dis;
            
                if(tmp_dis != dis_val)
                    return ftr.disabled_t.mix;
            }
            
            var m_features = ftr.Features().Items();
            for (var i in m_features)
            {
                tmp_dis = m_features[i].Disabled();
                if(dis_val == undefined)
                    dis_val = tmp_dis;
            
                if(tmp_dis != dis_val)
                    return ftr.disabled_t.mix;
            }
   
            if(dis_val == undefined) // feature is empty
                return ftr.disabled_t.no;

            return dis_val;
        }
        //###############################################################
        ftr.OwnAction = function (act)
        {
            if(act)
                return ftr.SetOwnAction(act);

            return ftr.GetOwnAction();
        }
        ftr.OwnAction.Subscribe = p_own_action.Subscribe;
        //###############################################################
        ftr.SetOwnAction = function (act) 
        {
            // in case of setting own action to remove it should be done by common way for all childs
            if(act == ftr.action_t.remove || (act == ftr.action_t.none && ftr.OwnState() == ftr.state_t.absent))
            {
                ftr.Log("SetOwnAction: request for setting 'remove' action (or 'none' with current own state absent) -> it will be done for all childs");
                return ftr.Action(act);
            }

            if(act && act != ftr.action_t.remove && ftr.Disabled() == ftr.disabled_t.yes)
            {
                ftr.Log("SetOwnAction: only 'remove' action can be set for disabled component -> action '" + act + "' can't be set");
                return ftr.action_t.none;
            }
        
            // act is action from ftr.action_t enum
            if (!act)
            {
                ftr.Log("SetOwnAction: input is undefined -> return GetAction()");
                return ftr.GetOwnAction();
            }

            if(m_action_update_in_prgrs)
            {
                if(act == m_action_to_set)
                {
                    ftr.Log("SetOwnAction: setting action to " + act + " is already in progress");
                    return act;
                }
                else
                {
                    ftr.Log(Log.l_error, "SetOwnAction: setting action to " + m_action_to_set + " is in progress, but received the concurent request to set act into " + act);
                    return m_action_to_set;
                }
            }
                        
            var curr_act = ftr.GetAction();

            if( curr_act == act)
            {
                ftr.Log("SetOwnAction: current feature full action \"" + curr_act + "\" will not be changed due to it is already the same as input act = \""+ act +"\"");
                return act;
            }
            
            ftr.Log("SetOwnAction act = \"" + act + "\"");

            m_action_update_in_prgrs = true;
            m_action_to_set = act;

            var curr_own_act = ftr.GetOwnAction();

            ftr.Components().Apply(function(el){el.Action(act); return true;});
        
            var new_own_act = ftr.GetOwnAction();
            if(curr_own_act == new_own_act)
            {
                ftr.Log("SetOwnAction: current feature own action \"" + act + "\" wasn't changed!");
            }
            else
                p_own_action(new_own_act);

            var new_act = ftr.GetAction();
            if(curr_act == new_act)
            {
                ftr.Log("SetOwnAction: action \"" + act + "\" was applied for own components only, full feature action remain \""+ curr_act +"\"");
            }
            else
                p_action(new_act);
        
            m_action_update_in_prgrs = false;

            return act;
        }
        //###############################################################
        //ftr.DoSetOwnAction = function(act) { return true; }
        //###############################################################
        ftr.GetOwnAction = function ()
        {
            var none_installed = false;
            var none_absent    = false;
            var install  = false;
            var remove   = false;

            var m_components = ftr.Components().Items();
            for (var key in m_components)
            {
                if(m_components[key].Disabled() == ftr.disabled_t.yes)
                    continue;

                var act = m_components[key].Action();
                var state = m_components[key].State();
            
                if(act == ftr.action_t.install)
                    install = true;
                else if(act == ftr.action_t.remove)
                    remove = true;
                else if(act == ftr.action_t.none && state == ftr.state_t.installed)
                    none_installed = true;
                else if(act == ftr.action_t.none && state == ftr.state_t.absent)
                    none_absent = true;
            }

            var curr_act = ftr.action_t.none;

            if((install && remove) || (none_installed && remove) || (none_absent && install))
                curr_act = ftr.action_t.mix; 
            else if(install || (install && none_installed))
                curr_act = ftr.action_t.install;
            else if(remove || (remove && none_absent))
                curr_act = ftr.action_t.remove;
            else //if(none_installed || none_absent)
                curr_act = ftr.action_t.none;

            return curr_act;
        }
        //###############################################################
        ftr.Action = function (act)
        {
            if(act)
                return ftr.SetAction(act);

            return ftr.GetAction();
        }
        ftr.Action.Subscribe = p_action.Subscribe;
        //###############################################################
        // 
        //##############################################################
        ftr.ProcessChildActionChange = function (chld)
        {
            if(m_action_update_in_prgrs)
            {
                ftr.Log("ProcessChildActionChange: child changed action, action update is in progress - > process it after action update completed");
                return true;
            }

            ftr.Log("ProcessChildActionChange: begin");
        
            var curr_act = ftr.Action();
        
            if(p_action() != curr_act)
            {
                ftr.Log("ProcessChildActionChange: previous ftr action was " + p_action() + ", new " + curr_act);

                m_action_update_in_prgrs = true;

                m_action_to_set = curr_act;

                //p_action() is responsible for storing action before current change
                //sub components should be marked for install only in cases
                // 1. prev_act == remove && state == installed incoming action is install | mix | none
                // 2. prev_act == none && state == absent incoming action is install | mix | remove -> remove should be skip
            
                var st = ftr.State();

                if((p_action() == ftr.action_t.remove && st == ftr.state_t.installed)|| 
                    (p_action() == ftr.action_t.none && st == ftr.state_t.absent && curr_act != ftr.action_t.remove))
                {
                    m_action_to_set = ftr.action_t.install;

                    ftr.Components().Apply(function(el){el.Action(ftr.action_t.install); return true;});
                    ftr.Features().Apply(function(el){if(el.Mandatory()) el.Action(ftr.action_t.install); return true;});
                }

                var new_own_act = ftr.GetOwnAction();
                if(p_own_action() != new_own_act)
                    p_own_action(new_own_act);

                p_action(ftr.Action());

                m_action_update_in_prgrs = false;
            }
            ftr.Log("ProcessChildActionChange: end");
        }
        //###############################################################
        ftr.SetAction = function (act) 
        {
            if(act && act != ftr.action_t.remove && ftr.Disabled() == ftr.disabled_t.yes)
            {
                ftr.Log("SetAction: only 'remove' action can be set for disabled component -> action '" + act + "' can't be set");
                return ftr.action_t.none;
            }
        
            // act is action from ftr.action_t enum
            if (!act)
            {
                ftr.Log("SetAction: input is undefined -> return GetAction()");
                return ftr.GetAction();
            }

            if(m_action_update_in_prgrs)
            {
                if(act == m_action_to_set)
                {
                    ftr.Log("SetAction: setting action to " + act + " is already in progress");
                    return act;
                }
                else
                {
                    ftr.Log(Log.l_error, "SetAction: setting action to " + m_action_to_set + " is progress, but received the concurent request to set act into " + act);
                    return m_action_to_set;
                }
            }
                        
            var curr_act = ftr.GetAction();

            if( curr_act == act)
            {
                ftr.Log("SetAction: current action \"" + curr_act + "\" will not be changed due to it is already the same as input act = \""+ act +"\"");
                return act;
            }
            
            ftr.Log("SetAction act = \"" + act + "\"");

            m_action_update_in_prgrs = true;
            m_action_to_set = act;

            var curr_own_act = ftr.GetOwnAction();

            ftr.Components().Apply(function(el){el.Action(act); return true;});
            ftr.Features().Apply(function(el){el.Action(act); return true;});
        
            //ftr.DoSetAction(act);

            var new_own_act = ftr.GetOwnAction();

            if(curr_own_act != new_own_act)
                p_own_action(new_own_act);

            var new_act = ftr.GetAction();
            if(curr_act == new_act)
            {
                ftr.Log("SetAction: action \"" + act + "\" was applied for all child elements but real action remain \""+ curr_act +"\"");
            }
            else
                p_action(new_act);
        

            m_action_update_in_prgrs = false;

            return act;
        }
        //###############################################################
        //ftr.DoSetAction = function(act) { return true; }
        //###############################################################
        ftr.GetAction = function ()
        {
            /*
            if(ftr.Disabled() == ftr.disabled_t.yes)
            {
                ftr.Log("GetAction: feature is fully disabled -> action_t.none");
                return ftr.action_t.none;
            }
            */
            var none_installed = false;
            var none_absent    = false;
            var install  = false;
            var repair  = false;
            var remove   = false;

            var m_features = ftr.Features().Items();
            for (var key in m_features)
            {
                if(m_features[key].Disabled() == ftr.disabled_t.yes)
                    continue;

                var act = m_features[key].Action();
                var state = m_features[key].State();

                if(act == ftr.action_t.mix)
                    return ftr.action_t.mix;
                else if(act == ftr.action_t.install)
                    install = true;
                else if(act == ftr.action_t.repair)
                {
                    repair = true;
                    none_installed = true;
                }
                else if(act == ftr.action_t.remove)
                    remove = true;
                else if(act == ftr.action_t.none && state == ftr.state_t.installed)
                    none_installed = true;
                else if(act == ftr.action_t.none && state == ftr.state_t.absent)
                    none_absent = true;
            }

            var m_components = ftr.Components().Items();
            for (var key in m_components)
            {
                if(m_components[key].Disabled() == ftr.disabled_t.yes)
                    continue;

                var act = m_components[key].Action();
                var state = m_components[key].State();
            
                if(act == ftr.action_t.install)
                    install = true;
                if(act == ftr.action_t.repair)
                {
                    repair = true;
                    none_installed = true;
                }
                else if(act == ftr.action_t.remove)
                    remove = true;
                else if(act == ftr.action_t.none && state == ftr.state_t.installed)
                    none_installed = true;
                else if(act == ftr.action_t.none && state == ftr.state_t.absent)
                    none_absent = true;
            }

            var curr_act = ftr.action_t.none;

            //if((install && remove) || (none_installed && none_absent) || (none_installed && remove) || (none_absent && install))
            if((install && remove) || (none_installed && remove) || (none_absent && install))
                curr_act = ftr.action_t.mix; 
            else if(install || (install && none_installed))
                curr_act = ftr.action_t.install;
            else if(remove || (remove && none_absent))
                curr_act = ftr.action_t.remove;
            else if(repair)
                curr_act = ftr.action_t.repair;
            else //if(none_installed || none_absent)
                curr_act = ftr.action_t.none;

            return curr_act;
        }
        //###############################################################
        ftr.StateConsistent = function ()
        {
            var state = null;

            var m_components = ftr.Components().Items();
            for (var key in m_components)        
            {
                if(m_components[key].Disabled() == ftr.disabled_t.yes)
                    continue;

                if(!state)
                    state = m_components[key].State();
                else if(m_components[key].State() != state)
                    return false;
            }

            var m_features = ftr.Features().Items();
            for (var key in m_features)
            {
                if(m_features[key].Disabled() == ftr.disabled_t.yes)
                    continue;

                if(!m_features[key].StateConsistent())
                    return false;
                else if(!state)
                    state = m_features[key].State();
                else if(m_features[key].State() != state)
                    return false;
            }

            return true;
        }
        //###############################################################
        ftr.OwnState = function (st)
        {
            if(st)
                ftr.Log("state can't be assigned to the feature, it can be done for components only");

            var m_components = ftr.Components().Items();

            for (var key in m_components)
            {
                if(m_components[key].Disabled() == ftr.disabled_t.yes)
                    continue;

                if(m_components[key].State() == ftr.state_t.installed)
                    return ftr.state_t.installed;
            }
            return ftr.state_t.absent;
        }
        //###############################################################
        ftr.State = function (st)
        {
            if(st)
                ftr.Log("state can't be assigned to the feature, it can be done for components only");

            return ftr.GetState();
        }
        //###############################################################
        ftr.GetState = function ()
        {
            var m_components = ftr.Components().Items();

            for (var key in m_components)
            {
                if(m_components[key].Disabled() == ftr.disabled_t.yes)
                    continue;

                if(m_components[key].State() == ftr.state_t.installed)
                    return ftr.state_t.installed;
            }

            var m_features = ftr.Features().Items();
            for (var key in m_features)
            {
                if(m_features[key].Disabled() == ftr.disabled_t.yes)
                    continue;

                if(m_features[key].State() == ftr.state_t.installed)
                    return ftr.state_t.installed;
            }
            return ftr.state_t.absent;
        }
        //###############################################################
        ftr.CheckForUpgrade = function ()
        {
            if(ftr.Disabled() == ftr.disabled_t.yes)
            {
                ftr.Log("CheckForUpgrade: feature is fully disabled -> check isn't required");
                return;
            }
        
            ftr.Log("CheckForUpgrade: begin");

            if(ftr.State() == ftr.state_t.installed)
            {
                ftr.Log("CheckForUpgrade: feature is installed -> check for own upgrade isn't required but check for childs will perform");
            }
            else
            {
                ftr.Upgrade().Check();
            }

            ftr.Features().Apply(function(el){ el.CheckForUpgrade(); return true;});
            ftr.Components().Apply(function(el){ el.CheckForUpgrade(); return true;});
        
            ftr.Log("CheckForUpgrade: completed");
        }
        //###############################################################
        ftr.UpgradeState = function ()
        {
            if(ftr.Disabled() == ftr.disabled_t.yes)
            {
                ftr.Log("UpgradeState: feature is fully disabled -> upgrade_state_t.none");
                return ftr.upgrade_state_t.none;
            }

            var act = ftr.Action();

            if(act == ftr.action_t.none || act == ftr.action_t.remove)
            {
                ftr.Log("UpgradeState: feature action is none/remove -> upgrade_state_t.none");
                return ftr.upgrade_state_t.none;
            }

            var curr_state = ftr.Upgrade().State();

            var t_state = curr_state;

            var m_features = ftr.Features().Items();
            for (var key in m_features)
            {
                if(m_features[key].Disabled() == ftr.disabled_t.yes)
                    continue;

                t_state = m_features[key].UpgradeState();
            
                if(t_state == ftr.upgrade_state_t.none)
                    continue;

                if(curr_state != ftr.upgrade_state_t.none && t_state != curr_state)
                {
                    curr_state = ftr.upgrade_state_t.mix;
                    return curr_state;
                }
                else
                    curr_state = t_state;
            }

            var m_components = ftr.Components().Items();
            for (var key in m_components)
            {
                if(m_components[key].Disabled() == ftr.disabled_t.yes)
                    continue;

                t_state = m_components[key].UpgradeState();
            
                if(t_state == ftr.upgrade_state_t.none)
                    continue;

                if(curr_state != ftr.upgrade_state_t.none && t_state != curr_state)
                {
                    curr_state = ftr.upgrade_state_t.mix;
                    return curr_state;
                }
                else
                    curr_state = t_state;
            }

            return curr_state;
        }
        //###############################################################
        ftr.Size = function ()
        {
            if(ftr.Disabled() == ftr.disabled_t.yes)
            {
                ftr.Log("Size: feature is fully disabled -> size = 0");
                return 0;
            }

            return ftr.get_size();
        }
        //###############################################################
        ftr.get_size = function ()
        {
            var size = 0;

            ftr.Components().Apply(function(el)
            {
                if( el.State() == ftr.state_t.absent && 
                    el.Action() == ftr.action_t.install)
                    size += el.Size();
                
                return true;
            });

            ftr.Features().Apply(function(el){size += el.Size(); return true;});

            return size;
        }
        //###############################################################
        // RestorePoint method definition
        //###############################################################
        ftr.RestorePoint = function (st)
        { 
            var rp = st ? st : Storage("*");

            rp("id").value = ftr.Id();
            rp("name").value = ftr.Name();
            rp("description").value = ftr.Description();
            rp("visible").value = ftr.Visible() ? 1 : 0;
            rp("obj_type").value = ftr.Type();
            rp("install_dir_base").value = ftr.InstallDir.Base();
            rp("install_dir_own").value = ftr.InstallDir.Own();
            rp("version").value = ftr.Version().Str();

            var ftr_rp = rp("Features");
            var cmp_rp = rp("Components");

            ftr.Components().Apply(function(el){el.RestorePoint(cmp_rp(el.Id())); return true;});
            ftr.Features().Apply(function(el){el.RestorePoint(ftr_rp(el.Id())); return true;});

            var groups = rp("groups");
            for(var i in ftr.Groups().Items())
                groups(i).value = ftr.Groups().Items()[i];

            var cnfg_opts = rp("ConfigurationOptions");
            ftr.ConfigurationOptions().Filter(function(nm,val){cnfg_opts(nm).value = val;});

            return rp;
        }
        //###############################################################
        // Setting of dependencies processor
        //###############################################################
        ftr.ProcessDependency = function(o){return true;}
        //###############################################################
        // Dependencies setting
        //###############################################################
        ftr.Depend = function (alias, o)
        {
            o.Action.Subscribe(function(){ return ftr.ProcessDependency(o);});
            ftr.Dependencies().Add(alias, o);
        }

        return ftr;
    }//class Feature

    //###############################################################
    // Feature constructor
    //###############################################################
    this.Create = function(inf, ex_init)
    {
        if(!inf)
            return null;

        var r_info = inf.GetInfo();
        if(!r_info || !r_info.Id || !r_info.Id())
        {
            Log(Log.l_error, "Attempt to create feature with undefined Id - input info isn't defined or doesn't have Id or Id() is empty");
            return null;
        }

        var obj = Feature(r_info);
        if(!obj)
            return null;
        
        if(ex_init)
            ex_init.call(obj);

        return obj;
    }
} // namespace Root.feature

/** @class Node
 *  @brief Binding to Feature infrastructure
 *  @details Feature is C++ handled object with has set of predefined attributes,
 *    most of them are read/write, additionaly it includes methods to operate with
 *    content of feature selection dialog.
 *  @attr string id          feature id, read/write
 *  @attr string name        feature name, this value will be displayed on feature tree, read/write
 *  @attr string description deature description, this value will be displayed on feature
 *                           description pane, read/write
 *  @attr string error       error message, in case if feature is disabled - this value
 *                           will be displayed on feature description pane, read/write
 *  @attr integer size       feature size, this value will be displayed on feature
 *                           size column, read/write
 *  @attr integer priority   feature priority, features on same level are sorted
 *                           according this value (this value doesn't affect to
 *                           installation sequence), read/write
 *  @attr string icon        icon id to display feature on tree, read/write
 *  @attr integer disabled   non-zero value means that feature is disabled (default: false), read/write
 *  @attr integer expanded   non-zero value means that feature is expanded (default: true), read/write
 *  @attr string guid        guild of feature element, this value is automatically generated
 *                           on object creation and should be used as argument for AddChild
 *                           method, readonly
 *  @attr function hit       callback function to be called when user click on feature, see
 *                           notes for details, read/write
 *  @note
 *    Feature is bi-directional element: on one side it represents data available from script
 *    engine, on second side - feature selection dialog uses feature objects to display
 *    tree-based information on tree control and provide feedback to script on any user's
 *    actions: for example call callback function when user click on feature icon. To catch
 *    click on feature element developer should create callback function, like
 *    <pre>
 *      var feature_hit = function()
 *      {
 *          return 0;
 *      }
 *    </pre>
 *    and initialize <code>hit</code> attribute by this function:
 *    <pre>
 *      var n = Node();
 *      n.hit = feature_hit;
 *    </pre>
 *    During feature selection dialog processing when user click on element <code>n</code>
 *    function <code>feature_hit</code> will be called
 *  @see AddChild Menu
 */

/** @fn Node
 *  @brief Constructor for Node object
 *  @return Node - new created Node object
 */

/** @method Node AddChild(string guid)
 *  @brief Append child node to current node
 *  @details Features may be organized on tree-based manner on feature selection dialog.
 *    To do this method AddChild should be used - this method adds link to child node
 *    for current object.
 *  @param string guid - guid of child node to add, see guid attribute
 *  @usage
 *    // example below demonstrates how one node may be linked as child to another node
 *      var n_parent = Node();
 *      n_parent.name = "parent";
 *      var n_child = Node();
 *      n_child = "child";
 *      n_parent.AddChild(n_child.guid);
 */

/** @method Node Menu(array menu_items)
 *  @brief Show pop-up menu
 *  @details When user clicks on feature element on feature selection dialog ayn action may be
 *    processed, for example pop-up menu may be diaplayed to provide user choice to
 *    install/remove any component.
 *  @param array menu_items - array of menu items to display on pop-up menu, see notes
 *    for details
 *  @return data <code>id</code> of element selected by user or empty value
 *  @usage
 *    // example below demonstrates displaing menu on clicking to feature
 *      var node = Node(); // create and initialize node
 *      node.name = "my example node";
 *
 *      var node_hit = function()
 *      {
 *          var menu_items = [];
 *          menu_items.push({name:"menu item 1", icon:"install_icon", id:"install"});
 *          menu_items.push({name:"menu item 2", icon:"uninstall_icon", id:"uninstall"});
 *          var result = node.Menu(menu_items);
 *          if(!result)
 *          { // user canceled menu
 *          }
 *          else if(result == "install")
 *          { // user selected item "menu item 1"
 *          }
 *          else if(result == "uninstall")
 *          { // user selected item "menu item 2"
 *          }
 *      }
 *
 *      // here should be code to display feature selection dialog
 *  @note
 *    Method Menu accepts array of menu elements to display. Menu element is object
 *    which should have attributes:<br>
 *    name - string, text of element to display on pop-up menu<br>
 *    icon - string, icon name to display<br>
 *    id - value to return from Menu method if user select this specific element<br>
 *    To demonstrate how it can be used let's look at example. Let's assume that we created
 *    and initialized Node element:
 *    <pre>
 *      var node = Node();
 *      node.name = "example node";
 *      node.description = "example node description";
 *    </pre>
 *    Now create and initialize callback function:
 *    <pre>
 *      node.hit = function()
 *      {
 *          var menu_items = []; // create array
 *          menu_items.push({name:"menu item 1", icon:"install_icon", id:"install"}); // append menu item
 *          menu_items.push({name:"menu item 2", icon:"uninstall_icon", id:"uninstall"}); // append menu item
 *          var result = node.Menu(menu_items); // call Menu method
 *          if(!result) // process return value
 *          { // user canceled menu
 *          }
 *          else if(result == "install")
 *          { // user selected item "menu item 1"
 *          }
 *          else if(result == "uninstall")
 *          { // user selected item "menu item 2"
 *          }
 *      }
 *    </pre>
 *    As you can see usage of this function is simple
 *  @see Refresh
 */

/** @method Node Refresh
 *  @brief Refresh feature element on feature selection dialog
 *  @details After Node element is updated (for example updated text or icon) corresponding
 *    element on feature selection dialog should be refreshed. Refresh method initiate
 *    re-drawing tree control.
 *  @usage
 *      var node = Node();
 *      node.icon = "install";
 *      node.hit = function()
 *      {
 *          node.icon = "uninstall"; // this action will not affect to GUI
 *          node.Refresh(); // redraw element
 *      }
 *  @see Menu
 */