//###############################################################
// This file contains definition for:
// GUI extension for Feature class
//###############################################################
new function ()
{
    var base_script_dir = Origin.Directory();
    var load = function(name) {return required(FileSystem.MakePath(name, base_script_dir));};
    var ns_prop      = load("property.js");

    var icons_dir = FileSystem.MakePath("Icons", FileSystem.Parent(Origin.Directory()));
    Node.icon_broken_menu = "icon_broken_menu";
    Action.FeatureTreeNodeIcon({image:icons_dir + "\\broken.png", id: "icon_broken_menu"});

    //###############################################################
    var P = function(val){return ns_prop.Property(val);}
    var ConstP = function(val){return ns_prop.Constant(val);}
    var PBool = function(val)
    {
      var p = ns_prop.Property(val);
      p.Transform = function(val){ return val ? true : false; }  
      return p;
    }

    var FilterNotEmpty = function(val)
    {
        if(typeof(val) == undefined || val == null) 
            return false;
        
        return true;
    }

    var PNotEmpty = function(val)
    {
      var p = ns_prop.Property(val);
      p.Filter = FilterNotEmpty;
      return p;
    }

    var PNumber = function(val)
    {
      var p = ns_prop.Property(val);
      p.Filter = function(val){ return (typeof(val) == "number" ? true : false); }
      return p;
    }

    var ns = this;
    //###############################################################
    // BindGui
    //###############################################################
    this.BindTo = function(ftr)
    {
        var m_node = null;
        
        ftr.Visible = PBool(true);
        ftr.Expanded = PBool(false);
        //###############################################################
        ftr.Hit = function () 
        {
            return function () {
                // this presents corresponding Node here

                var menu = ftr.Menu();
                var menu_arr = [];

                for (var i in menu)
                    menu_arr.push(menu[i]);

                var user_choice = ftr.GetNode().Menu(menu_arr);

                ftr.Log("User choice = " + user_choice);

                ftr.Action(menu[user_choice].act);

                ftr.Root().Refresh();
            }
        }
        //###############################################################
        ftr.SetNode = function (n) 
        {
            if(!n)
                return false;

            ftr.DetachNode();

            m_node = n;

            return true;
        }
        //###############################################################
        ftr.GetNode = function ()
        {
            return m_node;
        }
        //###############################################################
        ftr.RefreshNode = function () 
        {
            if (m_node) {
                m_node.id          = ftr.Id();
                m_node.name        = ftr.Name();
                m_node.description = ftr.Description();
                m_node.disabled    = (ftr.Disabled() == ftr.disabled_t.yes) ? true : false;
                m_node.error       = ftr.ErrorDescription();
                m_node.icon        = ftr.Icon();
                m_node.size        = ftr.Size();
                m_node.hit         = ftr.Hit();
                m_node.expanded    = ftr.Expanded();
                m_node.priority    = ftr.Priority();

                m_node.Refresh();

                return true;
            }

            return false;
        }
        //###############################################################
        ftr.ClearNode = function () 
        {
            if (m_node) {
                m_node.id          = "";
                m_node.name        = "";
                m_node.description = "";
                m_node.disabled    = false;
                m_node.error       = "";
                m_node.icon        = "";
                m_node.size        = "";
                m_node.hit         = function(){};
                m_node.expanded    = false;
                m_node.priority    = 0;

                m_node.Refresh();

                return true;
            }

            return false;
        }
        //###############################################################
        ftr.DetachNode = function () 
        {
            if (m_node) 
            {
                ftr.ClearNode();
                m_node.Detach();
                m_node = null;
                return true;
            }

            return false;
        }
        //###############################################################
        ftr.Icon = function () 
        {
            if(ftr.Disabled() == ftr.disabled_t.yes)
            {
                ftr.Log("Icon: feature is fully disabled -> disabled icon");
                return Node.icon_broken_menu;
            }

            var state = ftr.State();
            var consistent = ftr.StateConsistent();
            var act   = ftr.Action();
        
            ftr.Log("Icon define: state = " + state + " act = " + act);
            if(act == ftr.action_t.none)
            {
                if (state == ftr.state_t.absent)
                    return Node.icon_uninstalled_menu;
                else if (state == ftr.state_t.installed && consistent)
                    return Node.icon_installed_menu;
            }
            else if(act == ftr.action_t.install)
                return Node.icon_install_menu;
            else if (act == ftr.action_t.remove)
                return Node.icon_uninstall_menu;        
        
            return Node.icon_childs_differ_menu;        
        }
        //###############################################################
        ftr.Menu = function () 
        {
            ftr.Log("Menu generating start");
            if(ftr.Disabled() == ftr.disabled_t.yes)
            {
                ftr.Log("Menu: feature is fully disabled -> empty menu");
                return {};
            }

            ftr.Log("Menu generating cont");

            var menu = {};

            var item_install =
                {
                    id: "install",
                    name: "Install",
                    icon: Node.icon_install,
                    act: ftr.action_t.install
                };

            var item_do_not_remove =
                {
                    id: "install",
                    name: "Do not remove",
                    icon: Node.icon_installed,
                    act: ftr.action_t.install
                };

            var item_remove =
                {
                    id: "remove",
                    name: "Remove",
                    icon: Node.icon_uninstall,
                    act: ftr.action_t.remove
                };

            var item_do_not_install =
                {
                    id: "remove",
                    name: "Do not install",
                    icon: Node.icon_uninstalled,
                    act: ftr.action_t.remove
                };

            var state = ftr.State();
            var consistent = ftr.StateConsistent();
            var act   = ftr.Action();
      
            if(act == ftr.action_t.none)
            {
            
                if(!consistent)
                {
                    menu["install"] = item_install;
                    menu["remove"] = item_remove;
                }
                else if(state == ftr.state_t.installed)
                {
                    menu["install"] = item_do_not_remove;
                    menu["remove"] = item_remove;
                }
                else
                {
                    menu["install"] = item_install;
                    menu["remove"] = item_do_not_install;
                }
            }
            else if(act == ftr.action_t.mix)
            {
                if(!consistent)
                {
                    menu["install"] = item_install;
                    menu["remove"] = item_remove;
                }
                else if(state == ftr.state_t.installed)
                {
                    menu["install"] = item_do_not_remove;
                    menu["remove"] = item_remove;
                }
                else
                {
                    menu["install"] = item_install;
                    menu["remove"] = item_do_not_install;
                }
            }
            else if(act == ftr.action_t.remove)
            {
                if(!consistent)
                {
                    menu["install"] = item_install;
                    menu["remove"] = item_remove;
                }
                else if(state == ftr.state_t.installed)
                {
                    menu["install"] = item_do_not_remove;
                    menu["remove"] = item_remove;
                }
            }
            else if(act == ftr.action_t.install)
            {
                if(!consistent)
                {
                    menu["install"] = item_install;
                    menu["remove"] = item_remove;
                }
                else if(state == ftr.state_t.absent)
                {
                    menu["install"] = item_install;
                    menu["remove"] = item_do_not_install;
                }
            }

            if(ftr.Mandatory())
                delete menu["remove"];

            return menu;
        }
    }
}