//###############################################################
// This file contains definition for:
// MSI feature processing
//###############################################################
new function ()
{
    var load = function(name) {return required(FileSystem.AbsPath(Origin.Directory(), name));}

    var ns_enum = load("enums.js");

    this.FeatureMap = function(node)
    {
        if(node)
        {
            var fea = node.select("feature[@id]");

            var feature = function(node)
            {
                var f = {};
                f.id = node.attributes.id;

                if(!f.id)
                    return null;

                var log = function(t, m) {Log(t, "Feature map [" + f.id + "]: ", m);}
                var info = function(msg) {log(Log.l_info, msg);}
                var warning = function(msg) {log(Log.l_warning, msg);}
                var error = function(msg) {log(Log.l_error, msg);}

                f.size = parseInt(node.attributes.size);
                f.fullsize = parseInt(node.attributes.fullsize);
                f.title = node.attributes.title;
                f.description = node.attributes.description;
                f.parentid = node.attributes.parent;

                f.Id = function() {return f.id;}
                f.Size = function() {return f.size;}
                f.FullSize = function() {return f.fullsize;}
                f.Title = function() {return f.title;}
                f.Description = function() {return f.description;}
                f.ParentId = function() {return f.parentid;}

                ns_enum.BindTo(f);

                f.product = null;
                f.parent = null;
                f.action = f.action_t.none;
                f.state = f.state_t.absent;

                f.Product = function(prod)
                {
                    if(arguments.length)
                    {
                        info("Processing feature state");
                        if(prod.IsFeatureInstalled(f.id))
                            f.State(f.state_t.installed);
                        else
                            f.State(f.state_t.absent);
                        f.product = prod;
                    }
                    return f.product;
                }

                f.State = function(state)
                {
                    if(arguments.length)
                    {
                        info("State set: " + f.state + " -> " + state);
                        switch(state)
                        {
                        case f.state_t.installed:
                            f.state = f.state_t.installed;
                            break;
                        case f.state_t.absent:
                            f.state = f.state_t.absent;
                            break;
                        default:
                            warning("Unknown state request: " + state);
                            break;
                        }
                    }

                    return f.state;
                }

                f.Action = function(action)
                {
                    if(arguments.length)
                    {
                        info("Action set: " + f.action + " -> " + action);
                        switch(action)
                        {
                        case f.action_t.install:
                            f.action = f.action_t.install;
                            break;
                        case f.action_t.remove:
                            f.action = f.action_t.remove;
                            break;
                        case f.action_t.none:
                            f.action = f.action_t.none;
                            break;
                        default:
                            warning("Unknown action request: " + action);
                            break;
                        }
                    }

                    return f.action;
                }

                f.Parent = function(parent)
                {
                    if(arguments.length)
                    {
                        info("Parent set");
                        f.parent = parent;
                    }

                    return f.parent;
                }

                f.map = null;
                f.Map = function(map) {f.map = map;} // for internal usage - link to parent object

                f.Childs = function(cb) {return f.map ? f.map.Childs(f, cb) : null;}

                f.Deep = {Childs : function(cb) {return f.map ? f.map.Deep.Childs(f, cb) : null;},
                          Tree   : function(cb) {return f.map ? f.map.Deep.Tree(f, cb) : null;},
                          Action : function(action) {f.Action(action); f.Childs(function(c) {c.Deep.Action(action); return false;})}};

                info("Created: " + f.id + " : " + f.title + " : " + f.description);

                return f;
            }

            var fmap = {};
            
            for(var i in fea)
            {
                var f = feature(fea[i]);
                if(f)
                    fmap[f.Id()] = f;
            }

            for(var i in fmap)
            { // set parent objects for features
                var pid = fmap[i].ParentId();
                if(pid && fmap[pid])
                    fmap[i].Parent(fmap[pid]);
            }

            var log = function(t, m) {Log(t, "Feature map: ", m);}
            var info = function(msg) {log(Log.l_info, msg);}
            var warning = function(msg) {log(Log.l_warning, msg);}
            var error = function(msg) {log(Log.l_error, msg);}

            // now build feature map object
            var map = {};
            ns_enum.BindTo(map);

            map.List = function(cb)
            {
                if(typeof(cb) == "function")
                {
                    for(var i in fmap)
                        if(cb(fmap[i]))
                            return true;
                    return false;
                }

                return fmap;
            }

            map.List(function(f) {f.Map(map); return false;});

            map.Get = function(id)
            {
                if(id)
                    if(fmap[id])
                        return fmap[id];
                warning("Failed to find feature: " + id);
                return null;
            }

            map.Deep = {}; // object to process elements recursively
            
            map.Childs = function(parent, cb) // null parent for root features
            {
                if(parent)
                    var equ = function(f) {return parent.Id() == f.ParentId();}
                else
                    var equ = function(f) {return !f.Parent();}

                var r = typeof(cb) == "function" ? false : [];

                map.List(function(f)
                {
                    if(equ(f))
                    {
                        if(typeof(cb) == "function")
                        {
                            if(cb(f))
                            {
                                r = true;
                                return true;
                            }
                            else
                                r = false;
                        }
                        else
                            r.push(f);
                        return false;
                    }
                });

                return r;
            }

            // enumerate all childs recursively
            map.Deep.Childs = function(parent, cb)
            {
                var self = arguments.callee;
                if(typeof(cb) == "function")
                {
                    return map.Childs(parent, function(f)
                    {
                        if(cb(f))
                            return true;
                        else
                            return self(f, cb);
                    });
                }
                else
                {
                    var r = [];
                    self(parent, function(f) {r.push(f); return false;});
                    return r;
                }
            }

            // enumerate all childs recursively, including parent element
            map.Deep.Tree = function(parent, cb)
            {
                var self = arguments.callee;
                if(typeof(cb) == "function")
                {
                    if(cb(parent))
                        return true;
                    return map.Deep.Childs(parent, cb);
                }
                else
                    return [parent].concat(map.Deep.Childs(parent, cb));
            }

            // returns list of features by requested action
            map.ListAction = function(action)
            {
                var list = "";
                var append = function(name) {list = list + (list ? "," : "") + name;}
                map.List(function(f) {if(f.Action() == action) append(f.Id()); return false;});
                return list;
            }

            // returns list of features by requested state (useful for rollback)
            map.ListState = function(state)
            {
                var list = "";
                var append = function(name) {list = list + (list ? "," : "") + name;}
                map.List(function(f) {if(f.State() == state) append(f.Id()); return false;});
                return list;
            }

            return map;
        }

        return null;
    }
}

