
new function()
{
    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};

    var ns_dmp  = load("dumper.js");
    var ns_exec = load("executor.js");

    var thread_map = {};

    var group_header_template =
    {
        "Install"  :"[PrgInstall]\n[PrgInstallCurrComponent]",
        "Uninstall":"[PrgRemove]\n[PrgRemoveCurrComponent]",
        "Download" :"[PrgDownload]\n[PrgDownloadCurrComponent]"
    };

    var groups_disable_rollback =
    {
        "Uninstall" : true
    };

    var finished_tasks = {};

    var item_in_thread = function(item, groups)
    {
        var group = item.Group();
        if(group)
        {
            for(var i in groups)
            {
                if(group == groups[i])
                    return true;
            }
        }
        return false;
    }

    var threads_num = function(iter)
    {
        var thr = {};
        iter.Reset();

        while(iter.Next())
        {
            var item = iter.Get();
            if(item && !item.Skip())
            {
                for(var i in thread_map)
                {
                    if(item_in_thread(item, thread_map[i]))
                        thr[i] = true;
                }
            }
        }

        var num = 0;
        for(var i in thr)
            num++;

        iter.Reset();

        return num;
    }

    var threaded = function(item)
    {
        var group = item.Group();
        if(group)
        {
            for(var i in thread_map)
            {
                if(item_in_thread(item, thread_map[i]))
                    return true;
            }
        }
        return false;
    }

    var has_no_rollback_items = function(dmp)
    {
        var iter = ns_dmp.Iterator(dmp);
        while(iter.Next())
        {
            var item = iter.Get();
            if(item && !item.Skip())
            {
                var grp = item.Group();
                if(grp && groups_disable_rollback[grp])
                    return true;
            }
        }
        return false;
    }

    var items_count = function(iter)
    {
        iter.Reset();
        var num = 0;
        while(iter.Next())
            num++;
        iter.Reset();
        return num;
    }

    var countable = function(item)
    {
        if(item)
        {
            if(item.Attribute && item.Attribute("countable"))
                return true;
            if(!item.Attribute)
                return true; // for older items - assume that all items are countable
        }

        return false;
    }

    var item_name = function(item)
    {
        if(item && item.Attribute && item.Attribute("name"))
            return item.Attribute("name");

        return null;
    }

    var error_handler_lock = Mutex();

    // function sets error handler for dumper and all sub-dumpers
    var set_error_handler = function(dumper)
    {
        Log("Set handler for: " + dumper.Name());
        var self = arguments.callee;

        var create_error_handler = function()
        {
            var processed = false;
            var reverse_here = false;
            var result = Action.r_ok;

            var handler = function(iter, error)
            { // TODO: add lock for manipulations with tree data
                Log("Error handles: main thread: " + Thread.Self().executor_main_thread);
                if(iter.Get())
                    Log("Failed item: " + iter.Get().Name());
                if(iter.Dumper())
                    Log("Current dumper: " + iter.Dumper().Name());

                error_handler_lock.Lock();

                if(error == Action.r_cancel || Wizard.Canceled())
                {
                    error_handler_lock.Unlock();
                    Log("'Canceled' status is passed to parent object");
                    return Action.r_cancel; // do not process canceled operations
                }

                if(Wizard.Aborted())
                {
                    error_handler_lock.Unlock();
                    Log("'Aborted' status is passed to parent object");
                    return error;
                }

                var main_thread = Thread.Self().executor_main_thread;

                // mark all items in current iterator as failed
                var dumper = iter.Dumper();
                var i = ns_dmp.Iterator(dumper);
                while(i.Next())
                {
                    var item = i.Get();
                    if(item)
                    { // disable real Apply execution
                        Log("Disable Apply actions for item: " + item.Name());
                        item.Apply = function(){return Action.r_ok;}
                        item.Skip = function(){return true;}
                        item.failed = true;
                        if(main_thread)
                            item.rollback_started = true;
                    }
                }

                var reverse = function()
                {
                    if(main_thread)
                    {
                        Log("Reverse iterator for dumper: " + iter.Dumper().Name());
                        iter.Reverse(true);
                        iter.Reset();
                        iter.Filter(function(){return true;});
                        iter.Functor(create_rollback_functor(dumper));
                    }
                }

                if(!processed)
                {
                    processed = true;
                    if(dumper.IgnoreError && dumper.IgnoreError(iter))
                    {
                        if(!main_thread)
                        {
                            Log("Async thread. Set marker to reverse iterator");
                            reverse_here = true; // set marker to reverse iterator on main thread
                        }
                        else
                            reverse();
                        error_handler_lock.Unlock();
                        Log("'Ok' status is passed to parent object");
                        return Action.r_ok;
                    }
                }
                else
                { // in case if error was processed by handler - just return Ok status
                    if(main_thread && reverse_here)
                    {
                        reverse(); // reverse only in case if ignore error or in top-level error handles
                        reverse_here = false; // reverse done
                        error_handler_lock.Unlock();
                        Log("'Ok' status is passed to parent object");
                        return Action.r_ok;
                    }
                }

                //reverse(); // reverse only in case if ignore error or in top-level error handles
                error_handler_lock.Unlock();
                Log("Error status is passed to parent object: " + error);
                return error;
            }
            return handler;
        }

        dumper.OnError = create_error_handler();

        var el = dumper.Elements();
        while(el.Next())
        {
            var item = el.Get();
            if(item && item.IsDumper)
                self(item);
        }
    }

    var create_rollback_functor = function(dumper)
    {
        var iter = ns_dmp.Iterator(dumper);
        iter.Filter(function(item){return item.succeed && countable(item);});

        var total = items_count(iter);
        var current = 1;
        if(current > total)
            total = current;

        var functor = function(item)
        {
            Log("Rollback handler main thread: " + Thread.Self().executor_main_thread);

            Log("Rollback functor started. item: " + item.Name());
            if(item.succeed)
            {
                var header = StringList.Format("[PrgRollback]\n[PrgRollbackCurrComponent]", current, total);
                if(item_name(item))
                    header += ": " + item_name(item);
                Wizard.Notify("Progress1", "header", header);
                var progress = item.ProgressRollback();
                if(progress)
                {
                    Wizard.Notify("Progress1", "connect", progress.id);
                    progress.backward = true;
                }
                if(countable(item))
                    current++;
                if(current > total)
                    current = total;

                safecall(function(){item.Rollback();},
                         function(){Log(Log.l_error, "Exception handled calling Rollback method of Action: " + item.Name());});
                item.succeed = false;
            }
            item.rollback_started = false;
            item.rollback_done = true;
            Log("Rollback functor finished");
            return Action.r_ok;
        }

        return functor;
    }

    var create_commit_functor = function(dumper)
    {
        var iter = ns_dmp.Iterator(dumper);
        iter.Filter(function(item){return item.succeed && countable(item);});

        var total = items_count(iter);
        var current = 1;
        if(current > total)
            total = current;

        var functor = function(item)
        {
            Log("Commit functor started. item: " + item.Name());
            if(item.succeed)
            {
                var header = StringList.Format("[PrgCommit]\n[PrgCommitCurrComponent]", current, total);
                if(item_name(item))
                    header += ": " + item_name(item);
                Wizard.Notify("Progress1", "header", header);
                var progress = item.ProgressCommit();
                if(progress)
                {
                    Wizard.Notify("Progress1", "connect", progress.id);
                    progress.backward = false;
                }
                if(countable(item))
                    current++;
                if(current > total)
                    current = total;

                safecall(function(){item.Commit();},
                         function(){Log(Log.l_error, "Exception handled calling Commit method of Action: " + item.Name());});

                item.commited = true;
            }
            return Action.r_ok;
        }

        return functor;
    }

    var lock = Mutex();

    var create_apply_functor = function(thr, header)
    {
        var functor = function(item)
        {
            if(!thr)
                Thread.Self().executor_main_thread = true;

            Log("Apply functor started: item: " + (item ? item.Name() : "Unknown"));
            if(item.failed)
            {
                Log("  Item marked as 'Failed', Main thread: " + Thread.Self().executor_main_thread);
                if(Thread.Self().executor_main_thread) // main thread execution
                    return Wizard.Canceled() ? Action.r_cancel : Action.r_error;
                else
                    return Action.r_ok; // on threaded functors - just ignore failed elements
            }
            if(item.Skip())
            {
                item.skipped = true;
                return Action.r_ok;
            }
            if(header)
            {
                lock.Lock();
                header(item);
                lock.Unlock();
            }

            Log("Apply starting...");
            var res = safecall(function(){return item.Apply();},
                               function(){Log(Log.l_error, "Exception handled calling Apply method of Action: " + item.Name()); return Action.r_error;});
            Log("Apply done: " + res);

            if(res == Action.r_ok || res == true)
            {
                item.succeed = true;
                var group = item.Group();
                if(groups_disable_rollback[group])
                    Wizard.Cancel.Disable();
                return Action.r_ok;
            }
            else
                return Wizard.Canceled() ? Action.r_cancel : Action.r_error;
            return res;
        }
        return functor;
    }

    /* tasker - is function which select Action from iterator
     * and return it.
     * additionally create_tasker function creates & configure iterators
     * for processing dumper
     */
    var create_tasker = function(dumper, header, groups, id, main_wait_for_others)
    {
        var iter = ns_dmp.Iterator(dumper);

        if(groups)
        { // threaded tasker
            iter.Filter(function(item){return item_in_thread(item, groups);});
            iter.Functor(create_apply_functor(true, header));

            if(id)
                finished_tasks[id] = false;

            return function()
            {
                // if current task is marked as finished - return null
                if(id && finished_tasks[id])
                    return null;

                Log("Generating new task in: " + id);
                while(iter.Next())
                    if(!iter.Get().failed) // skip all failed items
                        return iter.Call;
                Log("No more tasks");
                if(id) // generate function to mark current task as finished
                    return function(){Log("Task " + id + " marked as finished"); finished_tasks[id] = true; return Action.r_ok;}
                return null;
            }
        }
        else
        { // main thread tasker
            iter.Functor(create_apply_functor(false, header));
            if(iter.Next()) // exists at least one element
            {
                var wait_progress = Progress();
                wait_progress.total = -1;
                wait_progress.message = "[waiting_for_media]";

                var tasker = function()
                {
                    Log("Main thread tasker called");

                    if(main_wait_for_others)
                    { // wait for other threads are finished
                      // used when uninstallation action exists
                        for(var i in finished_tasks)
                            if(!finished_tasks[i])
                            {
                                Log("Found non-finished task: " + i);
                                Wizard.Notify("Progress1", "connect", wait_progress.id);
                                return null;
                            }
                    }

                    var item = iter.Get();
                    if(!item) // first step
                    {
                        if(!iter.Next())
                            return null;
                        item = iter.Get();
                    }

                    while(true)
                    {
                        Log("Processing item: " + item.Name());
                        if(item.rollback_started)
                        {
                            Log("rollback_started flag exists: " + item.rollback_started);
                            return iter.Call; // do not filter rollback items
                        }

                        // check if item already processed
                        if(item.succeed || item.rollback_done || item.skipped)
                        {
                            Log("switch to next item: " + item.succeed + " : " + item.rollback_done);
                            if(!iter.Next())
                                return null;
                            item = iter.Get();
                            continue;
                        }

                        // check if current element is locked
                        if(threaded(item))
                        {
                            Log("Threaded item processing: " + item.Name());
                            if(!item.failed)
                            {
                                Log("Wait for locked item");
                                Wizard.Notify("Progress1", "connect", wait_progress.id);
                                return null;
                            }
                            else
                            {
                                Log("Item marked as 'failed'. Return caller");
                                return iter.Call;
                            }
                        }
                        else // not locked element
                        {
                            Log("Not locked element");
                            return iter.Call;
                        }
                    }
                }
                return tasker;
            }
            else
                return function(){return null;} // fake tasker - nothing to do
        }
    }

    /* creates function which updates progress bar header
     *
     */
    var create_header = function(dumper)
    {
        var groups = {}; // set of groups used later in processing

        var iter = ns_dmp.Iterator(dumper);
        // set filter function - ignore all skipped items
        iter.Filter(function(item){return !item.Skip()});

        while(iter.Next())
        {
            var item = iter.Get();
            if(item && countable(item))
            {
                // get action group
                var group = item.Group();
                if(!group) // in case if group is not defined - assume
                    group = "Install"; // that 'Install' group used
                var g = groups[group];
                if(!g) // group doesn't exist - create it
                {
                    g = {};
                    g.total = 0; // set total/current elements
                    g.current = 0;
                    if(group_header_template[group]) // set message template
                        g.header = group_header_template[group];
                    groups[group] = g;
                }
                g.total++; // increment total elements in group
            }
        }

        /* function used to attach Action progress to dialog progress
         * function is called from Apply functor
         * every group should be attached to particular progress
         */
        var bind_progress = function(progress, group)
        {
            if(!group)
                group = "Install";
            if(groups[group])
                groups[group].progress = progress;
        }

        /* progress updated function
         * called from Apply functor
         * incoming argument - item which is currently executing
         */
        var header = function(item)
        {
            if(item && item.Group)
            {
                var group = item.Group();
                if(!group)
                    group = "Install";
                if(groups[group])
                {
                    grp = groups[group];
                    if(countable(item))
                        grp.current++;
                    if(grp.current > grp.total)
                        grp.current = grp.total;
                    var message = StringList.Format(grp.header, grp.current ? grp.current : 1, grp.total);
                    if(item_name(item))
                        message += ": " + item_name(item);
                    Wizard.Notify(grp.progress, "header", message);
                    var p = item.ProgressApply();
                    if(p)
                    {
                        Wizard.Notify(grp.progress, "connect", p.id);
                        p.backward = false;
                    }
                }
            }
        }

        header.bind_progress = bind_progress;

        return header;
    }

    this.Process = function(dmp)
    {
        if(!dmp)
        {
            Log(Log.l_error, "No dumper provided");
            return Action.r_error;
        }

        Log("Preliminary installation sequence: ");
        ns_dmp.Trace(dmp);

        set_error_handler(dmp);

        // set high level error processing function
        dmp.OnError = function(iter, error)
        {
            Log("====> Top-level Error handler called: " + error);
            Log("Top-level error handler: main thread: " + Thread.Self().executor_main_thread);

            Wizard.Cancel.Disable();
            if(!Wizard.Canceled())
                Wizard.Abort();

            var main_thread = Thread.Self().executor_main_thread;

            var item = iter.Get();
            if(item)
            {
                if(main_thread)
                { // in case if this is main thread - rollback all changes
                    iter.Reverse(true);
                    iter.Reset();
                    iter.Functor(create_rollback_functor(iter.Dumper()));
                    Log("  Reverse iterator");
                }
            }

            Log("  Disable all nodes to execute");
            var dumper = iter.Dumper();
            var i = ns_dmp.Iterator(dumper);
            while(i.Next())
            {
                var item = i.Get();
                if(item)
                { // mark all elements as failed & rebuild Skip & Apply calls
                    if(main_thread)
                        item.rollback_started = true;
                    item.failed = true;
                    item.Skip = function() {return true;}
                    item.Apply = function() {return Action.r_ok;}
                }
            }
            Log("  Done");
            return Action.r_ok;
        }

        // generate header processors
        var header = create_header(dmp);
        header.bind_progress("Progress1", "Install");
        header.bind_progress("Progress1", "Uninstall");

        var mapped = {};

        for(var i in thread_map)
        {
            for(var j in thread_map[i])
            {
                header.bind_progress(i, thread_map[i][j]);
                mapped[thread_map[i][j]] = true;
            }
        }

        var i = ns_dmp.Iterator(dmp);
        while(i.Next())
        {
            var item = i.Get();
            if(item)
            {
                var gr = item.Group();
                if(gr && !mapped[gr])
                    header.bind_progress("Progress1", gr);
            }
        }

        var exec = ns_exec.Executor();

        var single_thread = has_no_rollback_items(dmp);

        exec.AddThread(create_tasker(dmp, header, null, "main", single_thread)); // main thread tasker
        for(var i in thread_map)
            if(thread_map[i] && thread_map[i].length)
            {
                Log("Creating execution thread for: " + i + ": " + thread_map[i]);
                exec.AddThread(create_tasker(dmp, header, thread_map[i], "thread " + i)); // threaded tasker
            }

        exec.Start();

        Wizard.Cancel.Disable();

        if(!Wizard.Canceled() && !Wizard.Aborted())
        { // commit all changes
            var commit_iterator = ns_dmp.Iterator(dmp);
            commit_iterator.Functor(create_commit_functor(dmp));
            while(commit_iterator.Next())
                commit_iterator.Call();
            return Action.r_ok;
        }
        else
        {
            if(Wizard.Canceled())
                return Action.r_cancel;
            else
                return Action.r_error;
        }
    }

    this.ThreadMap = function(tm)
    {
        if(tm)
            thread_map = tm;
    }

    this.ThreadNum = function(dmp)
    {
        var thr_iterator = ns_dmp.Iterator(dmp);
        if(thr_iterator)
            return threads_num(thr_iterator) + 1;
        return 1;
    }
}
