//###############################################################
// This file contains definition for:
//  enum install_scope_t
//  class Installer
//###############################################################
Namespace("Root.installer", function()
{
    var base_script_dir = Origin.Directory();
    var load = function(name) {return required(FileSystem.MakePath(name, base_script_dir));};

    var ns_dump  = load("dumper.js");    
    var ns_enums = load("enums.js");
    var ns_exec  = load("executor.js");
    var ns_inst  = load("install.js");
    var ns_event = load("event.js");

    var ns = this;
    //###############################################################
    // Installer class
    //###############################################################
    this.Installer = this.Installer || new function()
    {
        ns_enums.BindTo(this);

        this.Log = log_helper("Installer : ");
        this.Products   = {};
        this.Features   = {};
        this.Components = {};
        this.Groups     = {};
        this.ObjectsToUpgrade = [];
        this.UDumper = ns_dump.Dumper("Uninstaller");
        this.IDumper = ns_dump.Dumper("Installer");

        this.OnApplyUpgradeDone = new ns_event.Event(this);
        this.OnApplyRemoveDone = new ns_event.Event(this);
        this.OnApplyInstallDone = new ns_event.Event(this);
        this.OnApplyRepairDone = new ns_event.Event(this);

        this.DownloadDumper = ns_dump.Dumper("Downloader");

        this.ResetActs  = [];
        this.start_product = null;
        this.m_install_mode = this.install_mode_t.install;
        this.m_setup_type   = this.setup_type_t.setup_default;
        this.m_install_dir  = "";
        //###############################################################
        this.Clean = function()
        {
            this.Products   = {};
            this.Features   = {};
            this.Components = {};
            this.Groups     = {};
            this.ObjectsToUpgrade = [];
            this.UDumper = ns_dump.Dumper("Uninstaller");
            this.IDumper = ns_dump.Dumper("Installer");

            this.OnApplyUpgradeDone = new ns_event.Event(this);
            this.OnApplyRemoveDone = new ns_event.Event(this);
            this.OnApplyInstallDone = new ns_event.Event(this);

            this.DownloadDumper = ns_dump.Dumper("Downloader");

            this.ResetActs  = [];
            this.start_product = null;
            this.m_install_mode = this.install_mode_t.install;
            this.m_setup_type   = this.setup_type_t.setup_default;
            this.m_install_dir  = "";
            this.analize_configuration_was_done = false;
        }
        //###############################################################
        this.InstallMode = function()
        {
            if(arguments[0])
                this.m_install_mode = arguments[0];

            return this.m_install_mode;
        }
        //###############################################################
        this.SetupType = function()
        {
            if(arguments[0])
                this.m_setup_type = arguments[0];

            return this.m_setup_type;
        }
        //###############################################################
        this.InstallDir = function()
        {
            if(arguments[0])
                this.m_install_dir = arguments[0];

            return this.m_install_dir;
        }
        //###############################################################
        this.AddProduct = function(p)
        {
            if(!p)
            {
                this.Log("AddProduct - product is undefined");
                return false;
            }
            
            if(!p.Id || !p.Id())
            {
                this.Log("AddProduct - product Id() is undefined");
                return false;
            }

            this.Log("AddProduct id= " + p.Id());

            if(!this.Products[p.Id()])
                this.Products[p.Id()] = p;
            else
                Log("Product already exists");        

            return true;
        }
        //###############################################################
        this.AddFeature = function(f)
        {
            if(!f)
            {
                this.Log("AddFeature - feature is undefined");
                return false;
            }

            if(!f.Id || !f.Id())
            {
                this.Log("AddFeature - feature Id() is undefined");
                return false;
            }
            
            this.Log("AddFeature id= " + f.Id());

            if(!this.Features[f.Id()])
                this.Features[f.Id()] = f;
            else
                Log("Feature already exists");
            
            return true;
        }
        //###############################################################
        this.AddComponent = function(c)
        {
            if(!c)
            {
                this.Log("AddComponent - component is undefined");
                return false;
            }

            if(!c.Id || !c.Id())
            {
                this.Log("AddComponent - component Id() is undefined");
                return false;
            }

            this.Log("AddComponent id= " + c.Id());

            if(!this.Components[c.Id()])
                this.Components[c.Id()] = c;
            else
                Log("Component already exists");

            return true;
        }
        //###############################################################
        this.AddResetAction = function (act) 
        {
            if (!act) 
            {
                Log(Log.l_warning, "request for adding empty action to Installer.ResetActs. Ignore.");
                return false;
            }

            this.ResetActs.push(act);
            
            return true;
        }
        //###############################################################
        this.AddObjectToUpgrade = function (obj)
        {
            if (!obj)
            {
                Log(Log.l_warning, "request for adding empty obj to Installer.ObjectsToUpgrade. Ignore.");
                return false;
            }

            this.ObjectsToUpgrade.push(obj);
            
            return true;
        }

        //###############################################################
        this.Reset = function () 
        {
            Log("reset product settings to default");
            for (var i in this.ResetActs) 
            {
                this.ResetActs[i]();
            }
        }
        //###############################################################
        this.Load = function()
        {
            for(var i in this.Products)
                if(this.Products[i] && this.Products[i].LoadContent)
                    this.Products[i].LoadContent();

            for(var i in this.Products)
                if(this.Products[i] && this.Products[i].SetRelations)
                    this.Products[i].SetRelations();
        }
        //###############################################################
        this.AnalizeConfiguration = function()
        {
            if(this.analize_configuration_was_done)
                return;

            this.analize_configuration_was_done = true;
            
            this.Apply();

            // to have Commit called after Apply;
            var inst_obj = this;
            var dobj = { Commit : function() { return inst_obj.Commit(); } };            
            this.IDumper.AddAction(dobj, "Installer commit");
        }
        //###############################################################
        var on_start_cb = null;
        this.OnStart = function(cb) {on_start_cb = cb;}
        //###############################################################
        this.Execute = function()
        {
            this.Log("Execution begin");
            
            this.ConfigureDumpersMessages();
            this.AnalizeConfiguration();
                        
            //this.IDumper.ThreadsNum(1);

            //this.DownloadDumper.ThreadsNum(1);

            var idmp = this.IDumper;

            //var exec = new ns_exec.Create();
            //this.Log("Adding tasks for download");
            //this.DownloadDumper.AddTasksToExecutor(exec);
            
            //this.Log("Adding tasks for install/remove");
            //idmp.AddTasksToExecutor(exec);

            this.UDumper.Group("Uninstall");
            this.IDumper.PreAction().AddAction(this.UDumper);

            ns_inst.ThreadMap({"Progress2":["Download"]});
            if(on_start_cb)
                on_start_cb(ns_inst.ThreadNum(this.IDumper));

            var res = ns_inst.Process(this.IDumper);

            this.Log("Execution complete res = " + res);
            return res;
        }
        //###############################################################
        this.ConfigureDumpersMessages = function()
        {
            var idmpr = this.IDumper;
            var f_line_i = "[PrgInstall]\n";
            var s_line_i = "[PrgInstallCurrComponent]";

            if(this.InstallMode() == this.install_mode_t.remove)
            {
                f_line_i = "[PrgRemove]\n";
                s_line_i = "[PrgRemoveCurrComponent]";
            }
            
            idmpr.ApplyPrgHeader = idmpr.ApplyPrgHeader || function()
            {
                var fst_line = f_line_i;
                var scd_line = s_line_i;

                var prg_hdr = StringList.Format(fst_line);
                prg_hdr += StringList.Format(scd_line, idmpr.PrgGrpCurrNum(), idmpr.PrgGrpTotalNum());

                return prg_hdr;
            }
            idmpr.RollbackPrgHeader = idmpr.RollbackPrgHeader || function()
            {
                var fst_line = f_line_i;
                var scd_line = s_line_i;

                var prg_hdr = StringList.Format(fst_line);
                prg_hdr += StringList.Format("[PrgRollback]\n");

                return prg_hdr;
            }
            idmpr.CommitPrgHeader = idmpr.CommitPrgHeader || function()
            {
                var fst_line = f_line_i;
                var scd_line = s_line_i;

                var prg_hdr = StringList.Format(fst_line);
                prg_hdr += StringList.Format("[PrgCommit]\n");

                return prg_hdr;
            }
            //###############################################################
            var udmpr = this.UDumper;
            var f_line_u = "[PrgRemove]\n";
            var s_line_u = "[PrgRemoveCurrComponent]";

            if(this.InstallMode() != this.install_mode_t.remove)
            {
                f_line_u = "[PrgPreInstallRemove]\n";
                s_line_u = "[PrgPreInstallCurrComponent]";
            }

            udmpr.ApplyPrgHeader = udmpr.ApplyPrgHeader || function()
            {
                var fst_line = f_line_u;
                var scd_line = s_line_u;

                var prg_hdr = StringList.Format(fst_line);
                prg_hdr += StringList.Format(scd_line, udmpr.PrgGrpCurrNum(), udmpr.PrgGrpTotalNum());

                return prg_hdr;
            }
            
            udmpr.RollbackPrgHeader = udmpr.RollbackPrgHeader || function()
            {
                var fst_line = f_line_u;
                var scd_line = s_line_u;

                var prg_hdr = StringList.Format(fst_line);
                prg_hdr += StringList.Format("[PrgRollback]\n");

                return prg_hdr;
            }
            
            udmpr.CommitPrgHeader = udmpr.CommitPrgHeader || function()
            {
                var fst_line = f_line_u;
                var scd_line = s_line_u;

                var prg_hdr = StringList.Format(fst_line);
                prg_hdr += StringList.Format("[PrgCommit]\n");

                return prg_hdr;
            }
            //###############################################################
            var ddmpr = this.DownloadDumper;
            var f_line_d = "[PrgDownload]\n";
            var s_line_d = "[PrgDownloadCurrComponent]";

            ddmpr.ApplyPrgHeader = ddmpr.ApplyPrgHeader || function()
            {
                var fst_line = f_line_d;
                var scd_line = s_line_d;

                var prg_hdr = StringList.Format(fst_line);
                prg_hdr += StringList.Format(scd_line, ddmpr.PrgGrpCurrNum(), ddmpr.PrgGrpTotalNum());

                return prg_hdr;
            }
            
            ddmpr.RollbackPrgHeader = ddmpr.RollbackPrgHeader || function()
            {
                var fst_line = f_line_d;
                var scd_line = s_line_d;

                var prg_hdr = StringList.Format(fst_line);
                prg_hdr += StringList.Format("[PrgRollback]\n");

                return prg_hdr;
            }
            
            ddmpr.CommitPrgHeader = ddmpr.CommitPrgHeader || function()
            {
                var fst_line = f_line_d;
                var scd_line = s_line_d;

                var prg_hdr = StringList.Format(fst_line);
                prg_hdr += StringList.Format("[PrgCommit]\n");

                return prg_hdr;
            }
        }
        //###############################################################
        this.Apply = function()
        {
            this.Log("ApplyUpgrade begin");
            
            for(var i in this.Products)
                this.Products[i].ApplyUpgrade();
            
            this.OnApplyUpgradeDone.Call();
            
            this.Log("ApplyUpgrade complete");
            
            this.Log("ApplyRemove begin");
            this.Log("  Doing ApplyRemove for each object from ObjectsToUpgrade array");
            
            for(var i in this.ObjectsToUpgrade)
                if(this.ObjectsToUpgrade[i].ApplyRemove)
                    this.ObjectsToUpgrade[i].ApplyRemove(this.UDumper);
            
            this.Log("  Doing ApplyRemove for each product");
            
            for(var i in this.Products)
                this.Products[i].ApplyRemove(this.UDumper);
            
            this.OnApplyRemoveDone.Call();
            
            this.Log("ApplyRemove complete");

            this.Log("ApplyRepair begin");
            
            for(var i in this.Products)
                this.Products[i].ApplyRepair(this.IDumper);
            
            this.OnApplyRepairDone.Call();

            this.Log("ApplyRepair complete");
            
            this.Log("ApplyInstall begin");
            
            for(var i in this.Products)
                this.Products[i].ApplyInstall(this.IDumper);
            
            this.OnApplyInstallDone.Call();
            
            this.Log("ApplyInstall complete");
        }
        //###############################################################
        this.Commit = function()
        {
            this.Log("Commit begin");
            for(var i in this.Products)
                if(this.Products[i].Commit)
                    if(!this.Products[i].Commit())
                    {
                        this.Log("product id = " + this.Products[i].Id() + " name = " + this.Products[i].Name() + " caused failure during commit!");
                        //return false; // ignore error in commit
                    }
            this.Log("Commit complete");
            
            return true;
        }
    }
}
);