//###############################################################
// This file contains definition for:
//  enum install_mode_t
//  class Product
//###############################################################
//Namespace("Root.product", function()
new function()
{
    var micl_id = "{9560B63A-0C5C-479C-8279-8071F86C00F0}";

    var base_script_dir = Origin.Directory();
    //###############################################################
    var ns_installer = Namespace("Root.installer");
    var load = function(name) {return required(FileSystem.MakePath(name, base_script_dir));};
    var ns_dump      = load("dumper.js");
    var ns_feature   = load("feature.js");
    var ns_component = load("component.js");
    var ns_cmp_inf   = load("component_info.js");
    var ns_arp       = load("component_arp.js");
    var ns_cmp_micl  = load("component_micl.js");
    var ns_cmp_is    = load("component_isource.js");
    var ns_enums     = load("enums.js");
    
    var product_cache_xml = FileSystem.MakePath("..\\" + Cache.config_name, base_script_dir);
    var target_dir = "C:\\DATA\\temp\\_{6789203}_test_installer_folder";
    var rp_hive = "RestorePoint::";

    var ns = this;
    //###############################################################
    // Product constructor
    //###############################################################
    this.Create = this.Create || function(id, ex_init)
    {
        var prd = ns_installer.Installer.Products[id];
        
        if(!prd)
        {
            prd = new ns.Product();
            if(!prd.Init(id))
                return null;
            if(ex_init)
                ex_init.call(prd);
        }

        return prd;
    }
    //###############################################################
    // function to define install mode
    //###############################################################
    var InstallModeIdentifier = function()
    {
        if(this.State() == this.state_t.installed)
        {
            if(this.ImageInstalled())
            {
                this.Log("Current product image " + this.Image() + " is installed");
                this.InstallMode(this.install_mode_t.modify);
            }
            else
            {
                this.Log("Current product image " + this.Image() + " isn't installed, but some components of " + this.Name() + " is already installed");
                this.InstallMode(this.install_mode_t.install);
            }
        }
        else
        {
            this.Log("none components is already installed");
            this.InstallMode(this.install_mode_t.install);
        }
    }
    //###############################################################
    // class Product
    //###############################################################
    this.Product = this.Product || function ()
    {
        arguments.callee.superclass.constructor.call(this);
        this.obj_type = "product";
        this.dumper   = ns_dump.Dumper();
        this.content_loaders    = {};
        this.relations_setters  = {};
        ns_enums.BindTo(this);
    }
    //###############################################################
    // Product is inheritted from Feature
    extend(this.Product, ns_feature.Feature);
    //###############################################################
    this.Product.prototype.Init = function(id)
    {
        ns.Product.superclass.Init.call(this, id);
        this.Log = log_helper("Product id = " + this.Id() + ": ");
        
        this.curr_image_id =  this.Id();
        //this.Scenario = {};
        this.IS = ns_cmp_is.Create(ns_cmp_inf.InfoPure("InstallSource_component_" + this.Id()), this.Id());
        this.IS.AddSource(FileSystem.MakePath("..\\" + Cache.config_name, Origin.Directory()));
        this.IS.Parent(this);
        this.MICL = ns_cmp_micl.Create(ns_cmp_inf.InfoPure(micl_id));
        this.MICL.Parent(this);

        this.m_uninstall_exe  = FileSystem.MakePath(FileSystem.exe_name, this.MICL.TargetDir());
        this.m_uninstall_prms = "--product=\"" + this.Id() + "\"";
        this.m_uninstall_cmd  = "\"" + this.m_uninstall_exe + "\"" + " " + this.m_uninstall_prms;

        this.ARP = ns_arp.Create(ns_cmp_inf.InfoPure("ARP_cmp_" + this.Id()), "ARP_for_prd_" + this.Id());
        this.ARP.Parent(this);
        this.ARP.Name(this.Id());
        this.ARP.UninstallString(this.m_uninstall_cmd);
        this.commit_to_remove = true; // flag which is changed during apply to false 
                                      // if there is reason to left this product (one of features isn't removed, ...)
                                      // if this flag is false -> product info is stored in db, else -> removed


        this.install_mode = this.install_mode_t.install;
        // custom properties
        this.custom_properties = {};
        
        // define install mode as modify if this product's image was already installed
        this.rp = Storage("*");
        this.rp.Read(rp_hive + id);

        this.m_install_dir_base = this.rp("install_dir_base").value;
        this.m_install_dir_own = this.rp("install_dir_own").value;
        this.Log(" installdirbase = " + this.m_install_dir_base);
        this.Log(" installdirown = " + this.m_install_dir_own);
        this.Log(" loading groups for product");

        var cnfg_opts = this.rp("ConfigurationOptions");
        for(var i in cnfg_opts.childs)
                this.AddCnfgOpt(cnfg_opts.childs[i], cnfg_opts(cnfg_opts.childs[i]).value);

        var groups = this.rp("groups");
        for(var i in groups.childs)
                this.AddToGroup(groups(groups.childs[i]).value);
        
        this.AddRelationSetter("InstallModeIdentifier", InstallModeIdentifier);
        ns_installer.Installer.AddProduct(this);
        this.m_visible = true;

        return true;
    }
    //###############################################################
    // function to transform storage to object
    //###############################################################
    var storage2object = function(stor)
    {
        if(stor)
        {
            var res = {};
            var childs = stor.childs;
            for(var i in childs)
            {
                var id = childs[i];
                res[id] = stor(id).value;
            }
            return res;
        }

        return {}; // return empty object
    }
    //###############################################################
    //
    //###############################################################
    this.Product.prototype.Image = function()
    {
        if(arguments[0])
            this.curr_image_id = arguments[0];

        return this.curr_image_id;
    }
    //###############################################################
    //
    //###############################################################
    this.Product.prototype.CacheDir = function()
    {
        return this.IS.TargetDir();        
    }
    //###############################################################
    //
    //###############################################################
    this.Product.prototype.ImageInstalled = function()
    {
        var images = this.rp("images");
        this.Log("Check if Image is installed: current Image = " + this.curr_image_id); 
        for(var i = 0, img; img = images.childs[i]; i++)
        {
            this.Log(" there is installed Image: " + img);
            if(img == this.curr_image_id)            
                return true;
        }
        return false;
    }
    //###############################################################
    //
    //###############################################################
    this.Product.prototype.ProductState = function()
    {
        this.Log("Get ProductState");
        var images = this.rp("images");
        this.Log("Check if any image of this product is installed:");
        
        if(!images.childs.length)
        {
            this.Log("nothing images of this product are installed - ProductState: absent");
            return this.state_t.absent;
        }

        for(var i = 0, img; img = images.childs[i]; i++)
            this.Log(" there is installed image: " + img);
        
        this.Log("ProductState: installed");
        return this.state_t.installed;
    }
    //###############################################################
    // Full command which is used for product uninstall
    //###############################################################
    this.Product.prototype.UninstallString = function(){ return this.m_uninstall_cmd; }
    //###############################################################
    // Exe which is used for product uninstall
    //###############################################################
    this.Product.prototype.UninstallExe = function(){ return this.m_uninstall_exe; }
    //###############################################################
    // Params which is used for product uninstall
    //###############################################################
    this.Product.prototype.UninstallParams = function(){ return this.m_uninstall_prms; }
    //###############################################################
    // following method is called on installdirbase change
    //###############################################################
    this.Product.prototype.DoInstallDirBaseChange = function (val)
    {
        if(this.ARP)
            this.ARP.InstallDirBase(this.InstallDir());

        if(this.IS)
            this.IS.InstallDirBase(this.InstallDir());

        return true;
    }
    //###############################################################
    // following method is called on installdirown change
    //###############################################################
    this.Product.prototype.DoInstallDirOwnChange = function (val)
    {
        // Product changes its own install dir childs should use it as base installdir
        if(this.ARP)
            this.ARP.InstallDirBase(this.InstallDir());

        if(this.IS)
            this.IS.InstallDirBase(this.InstallDir());
    
        return true;
    }
    //###############################################################
    this.Product.prototype.CheckForUpgrade = function ()
    {
        if(this.Disabled() == this.disabled_t.yes)
        {
            this.Log("CheckForUpgrade: product is fully disabled -> check isn't required");
            return;
        }
        
        this.Log("CheckForUpgrade: begin");

        if(this.ProductState() == this.state_t.installed)
        {
            this.Log("CheckForUpgrade: product is installed -> check for own upgrade isn't required but check for childs will perform");
        }
        else
        {
            this.Upgrade.Check();
        }

        for (var key in this.m_features)
            this.m_features[key].CheckForUpgrade();

        for (var key in this.m_components)
            this.m_components[key].CheckForUpgrade();
        
        this.Log("CheckForUpgrade: completed");
    }
    //###############################################################
    // DoApplyUpgrade method targeted to be redefinded by descendants
    //###############################################################
    this.Product.prototype.DoApplyUpgrade = function () 
    {
        if(this.m_apply_upgrade_done)
        {
            this.Log("ApplyUpgrade: was already done -> skip");
            return true;
        }

        this.m_apply_upgrade_done = true;
        
        // upgrade should be applied only in case if action not like remove or none

        var act = this.Action();
        if(act == this.action_t.remove || act == this.action_t.none)
            return true;
        
        this.Log("ApplyUpgrade begin");

        // products own upgrade should be taken only in case if it is absent
        if(this.ProductState() == this.state_t.absent)
            this.Upgrade.Apply();

        for (var cmp in this.m_components_order)
            if(!this.m_components_order[cmp].ApplyUpgrade())
            {
                this.Log("component id = " + this.m_components_order[cmp].Id() + " name = " + this.m_components_order[cmp].Name() + " caused failure during ApplyUpgrade!");
                return false;
            }

        for (var ftr in this.m_features_order)
            if(!this.m_features_order[ftr].ApplyUpgrade())
            {
                this.Log("feature id = " + this.m_features_order[ftr].Id() + " name = " + this.m_features_order[ftr].Name() + " caused failure during ApplyUpgrade!");
                return false;
            }

        this.Log("ApplyUpgrade end");
        return true;
    }
    //###############################################################
    this.Product.prototype.InstallMode = function(mode) 
    {
        if(!mode)
            return this.install_mode;
        
        this.install_mode = mode;
        // Setting Action for features and components
        if(mode == this.install_mode_t.install)
        {
            if(this.MICL)
                this.MICL.State(this.state_t.absent);

            this.Action(this.action_t.install);
        }
        else if(mode == this.install_mode_t.repair)
        {
            this.Action(this.action_t.install);
        }
        else if(mode == this.install_mode_t.modify)
        {
            if(this.MICL)
                this.MICL.State(this.state_t.installed);
            this.Action(this.action_t.none);
        }
        else if(mode == this.install_mode_t.remove)
        {
            if(this.MICL)
                this.MICL.State(this.state_t.installed);
            this.Action(this.action_t.remove);
        }

        this.Refresh();
    }
    //###############################################################
    this.Product.prototype.AddContentLoader = function (id, cb)
    {
        if(id && cb)
        {
            if(!this.content_loaders[id])
                this.content_loaders[id] = cb;
            else
                this.Log(Log.l_warning , "AddContentLoader : content loader with same id exists... ignore second instance: " + id);
        }
        else
            this.Log(Log.l_warning , "AddContentLoader : input object or id is undefined");
    }
    //###############################################################
    this.Product.prototype.AddRelationSetter = function (id, cb)
    {
        if(id && cb)
        {
            if(!this.relations_setters[id])
                this.relations_setters[id] = cb;
            else
                this.Log(Log.l_warning , "AddRelationSetter : relation setter with same id exists... ignore second instance: " + id);
        }
        else
            this.Log(Log.l_warning , "AddRelationSetter : input object or id is undefined");
    }
    //###############################################################
    this.Product.prototype.LoadContent = function ()
    {        
        this.Log("LoadContent begin");
        //this.rp.Read(rp_hive + this.Id());

        //if(ns_installer.Installer.start_product == this)
        //    this.start_product = true;

        for(var i in this.content_loaders)
        {
            this.Log("Call of content loader \"" + i + "\"");
            this.content_loaders[i].call(this);
        }
        
        this.Log("LoadContent completed");
    };
    //###############################################################
    this.Product.prototype.SetRelations = function ()
    {        
        this.Log("Relations set begin");

        for(var i in this.relations_setters)
        {
            this.Log("Call of relations setter \"" + i + "\"");
            this.relations_setters[i].call(this);
        }
        
        this.Log("Relations set completed");
    };
    //###############################################################
    this.Product.prototype.GenerateNodes = function ()
    {
        this.Log("GenerateNodes");

        var node_from_feature = function(n,f)
        {
            if(!f.Visible())
            {
                Log("Feature is hidden: " + f.Name());
                return;
            }

            var self = arguments.callee;

            var nf = new Node();

            f.SetNode(nf);
        
            if(n)
                n.AddChild(nf.guid);

            var ftrs = f.FeaturesOrder();
            for(var i in ftrs)
                self(nf, ftrs[i]);
        }
      
        if(this.m_visible)
            node_from_feature(null, this);
        else
        {
            this.Log("Root node is hidden");
            var ftrs = this.FeaturesOrder();
            for(var i in ftrs)
                node_from_feature(null, ftrs[i]);
        }
        
        this.Refresh();
        
        this.Log("GenerateNodes complete");
    };
    //###############################################################
    this.Product.prototype.Visible = function (val)
    {
        if(val != undefined)
            this.m_visible = val;
        
        return true;
    }
    //###############################################################
    this.Product.prototype.set_disabled = function(val)
    {    
        ns.Product.superclass.set_disabled.call(this, val);

        if(this.ARP)
            this.ARP.Disabled(val);

        if(this.IS)
            this.IS.Disabled(val);

        if(this.MICL)
            this.MICL.Disabled(val);
    }
    //###############################################################
    this.Product.prototype.DoProcessActionChange = function (act)
    {
        var ract = (act == this.action_t.mix) ? this.action_t.install : act;
        this.DoSetAction(ract);
    }
    //###############################################################
    this.Product.prototype.DoSetAction = function (act)
    { 
        if(this.ARP)
            this.ARP.Action(act);

        if(this.IS)
            this.IS.Action(act);

        if(this.MICL)
            this.MICL.Action(act);

        return true;
    };
    //###############################################################
    // ApplyResolveSrc method definition
    //###############################################################
    this.Product.prototype.DoApplyResolveSrc = function (dmp)
    {
        this.Log("DoApplyResolveSrc");
        if(!ns.Product.superclass.DoApplyResolveSrc.call(this, dmp))
        {
            this.Log("DoApplyResolveSrc: failure occured for child components");
            return false;
        }
        
        var state = this.State();
        var act = this.Action();
        if( act == this.action_t.install || 
            act == this.action_t.mix || 
            (act == this.action_t.none && state == this.state_t.installed))        
            this.commit_to_remove = false;        
        
        if(!this.commit_to_remove)
        {
            this.Log("There is feature/component installed or targeted for installation, therefore product will be asked for sources resolving ...");
            if(this.ARP && !this.ARP.ApplyResolveSrc(dmp))
                return false;

            if(this.IS && !this.IS.ApplyResolveSrc(dmp))
                return false;

            if(this.MICL && !this.MICL.ApplyResolveSrc(dmp))
                return false;
        }
        this.Log("DoApplyResolveSrc complete");

        return true;
    }
    //###############################################################
    this.Product.prototype.DoApplyRemove= function (dmp)
    {
        this.Log("DoApplyRemove");
        if(!ns.Product.superclass.DoApplyRemove.call(this, dmp))
        {
            this.Log("DoApplyRemove: failure occured for child components");
            return false;
        }
        
        //for(var i in this.features)
        //{     
            var state = this.State();
            var act = this.Action();
            if( act == this.action_t.install || 
                act == this.action_t.mix || 
                (act == this.action_t.none && state == this.state_t.installed))            
                this.commit_to_remove = false;
        //}        
        
        if(this.commit_to_remove)
        {
            this.Log("There isn't any feature/component installed or targeted for installation, therefore product will be removed...");
            this.Action(this.action_t.remove);            

            if(this.ARP && !this.ARP.ApplyRemove(dmp))
                return false;

            if(this.IS && !this.IS.ApplyRemove(dmp))
                return false;

            if(this.MICL && !this.MICL.ApplyRemove(dmp))
                return false;

            if(dmp && dmp.IsDumper)
                dmp.AddAction(this.dumper,"dmpr_" + this.Name());
            else
                this.Log("ApplyRemove: Can't schedule actions - input dumper is undefined or not a dumper (!dmp.IsDumper)");

            //ns_installer.Installer.Dumper.AddAction(this.dumper);
        }
        this.Log("DoApplyRemove complete");

        return true;
    };
    //###############################################################
    this.Product.prototype.DoApplyInstall = function (dmp)
    {
        this.Log("DoApplyInstall");
        if(!ns.Product.superclass.DoApplyInstall.call(this, dmp))
        {
            this.Log("DoApplyInstall: failure occured for child components");
            return false;
        }
        
        var state = this.State();
        var act = this.Action();
        if( act == this.action_t.install || 
            act == this.action_t.mix || 
            (act == this.action_t.none && state == this.state_t.installed))        
            this.commit_to_remove = false;        
        
        if(!this.commit_to_remove)
        {
            this.Log("There is feature/component installed or targeted for installation, therefore product will be installed..");
            if(this.ARP && !this.ARP.ApplyInstall(dmp))
                return false;

            if(this.IS && !this.IS.ApplyInstall(dmp))
                return false;

            if(this.MICL && !this.MICL.ApplyInstall(dmp))
                return false;

            if(dmp && dmp.IsDumper)
                dmp.AddAction(this.dumper,"dmpr_" + this.Name());
            else
                this.Log("ApplyInstall: Can't schedule actions - input dumper is undefined or not a dumper (!dmp.IsDumper)");
            
            //ns_installer.Installer.Dumper.AddAction(this.dumper);
        }
        this.Log("DoApplyInstall complete");
        
        return true;
    };
    //###############################################################
    this.Product.prototype.PreAction = function () { return this.dumper.PreAction(); }
    //###############################################################
    this.Product.prototype.PostAction = function () { return this.dumper.PostAction(); }
    //###############################################################
    this.Product.prototype.DoCommit = function ()
    {
        this.Log("DoCommit");
        if(!ns.Product.superclass.DoCommit.call(this))
        {
            this.Log("DoCommit: failure occured for child components, but commit will be continued for the rest of components");
        }

        if(this.commit_to_remove)
        {
            this.Log("will be removed");
            Storage("*").Write(rp_hive + this.Id());
        }
        else
        {
            this.Log("will be saved");

            var images = this.rp("images");
            images(this.curr_image_id).value = this.curr_image_id;
            this.RestorePoint(this.rp);
            this.rp.Write(rp_hive + this.Id());

            this.Log("Saved successful");
        }
        this.Log("DoCommit complete");

        return true;
    }
    //###############################################################
    this.Product.prototype.get_size = function ()
    {
        var size = ns.Product.superclass.get_size.call(this);

        if(this.ARP)
            size += this.ARP.Size();

        if(this.IS)
            size += this.IS.Size();

        if(this.MICL)
            size += this.MICL.Size();

        return size;
    };
    //###############################################################
    this.Product.prototype.RestorePoint = function (st)
    {
        var rp = st ? st : this.rp;

        ns.Product.superclass.RestorePoint.call(this, rp);

        if(this.ARP)
            this.ARP.RestorePoint(rp("ARP"));

        if(this.IS)
            this.IS.RestorePoint(rp("IS"));

        if(this.MICL)
            this.MICL.RestorePoint(rp("MICL"));

        if(this.custom_properties)
        {
            var custom = rp("CustomProperties");
            for(var i in this.custom_properties)
                custom(i).value = this.custom_properties[i];
        }
                   
        var rp_images = rp("images");

        for(var i in this.rp("images").childs)
        {
            rp_images(this.rp("images").childs[i]).value = this.rp("images").childs[i];
        }

        return rp;
    }

    // custom properties API
    this.Product.prototype.CustomProperties = function()
    {
        return this.custom_properties;
    }

    // get list of products
    this.ProductList = function()
    {
        var storage = Storage("ProductList::*");
        storage.Read(rp_hive);

        var res = [];

        var childs = storage.childs;
        for(var i in childs)
        {
            var p = storage(childs[i]);
            res[p.name] = storage2object(p("CustomProperties"));
        }
        storage.Clear(); // clean storage
        return res;
    }

    // update micl_id value based on data from config file
    var cfg_file = FileSystem.Exists(product_cache_xml) ?  product_cache_xml : Cache.Config();
    if(FileSystem.Exists(cfg_file))
    {
        var root = XML(cfg_file);
        if(root)
        {
            var cfg = root.node("/config/micl[@id]");
            if(cfg)
            {
                var id = cfg.attributes.id;
                if(id)
                {
                    Log("MICL id configured: " + id);
                    micl_id = id;
                }
            }
        }
    }
}
//##########################################################
// Backup
//##########################################################
/*
    //###############################################################
    // Product constructor from RestorePoint
    //###############################################################
    this.CreateFromRP = this.CreateFromRP || function(rp, restore_mngr)
    {
        var id = "";

        if(typeof rp == "string")
            { id = rp; }
        else if(rp && rp("id").value != "")
            { id = rp("id").value; }
        else
            { return null; }

        var prd = ns_installer.Installer.Products[id];
        
        if(!prd)
        {
            prd = new ns.Product();
            if(!prd.InitFromRP(id, restore_mngr))
            {
                delete prd;
                return null;
            }
        }
            
        return prd;
    }
*/
/*
    //###############################################################
    this.Product.prototype.InitFromRP = function(id, restore_manager)
    {
        //if(!rp || rp("id").value == "")
        //    return false;
        
        //var id = rp("id").value;        

        this.rp = Storage("*");
        this.rp.Read(rp_hive + id);        

        if(!ns.Product.superclass.InitFromRP.call(this, this.rp, restore_manager))
            return false;

        this.Log = log_helper("Product id = " + id + ": ");

        this.m_install_dir_base = this.rp("install_dir_base").value;
        this.m_install_dir_own = this.rp("install_dir_own").value;

        this.curr_image_id =  this.Id();
        this.Scenario = {};

        this.ARP = ns_arp.CreateFromRP(this.rp("ARP"));
        this.IS  = ns_cmp_is.CreateFromRP(this.rp("IS"));
        this.MICL = ns_cmp_micl.CreateFromRP(this.rp("MICL"));
        this.custom_properties = storage2object(this.rp("CustomProperties"));
                
        this.commit_to_remove = true; // flag which is changed during apply to false 
                                      // if there is reason to left this product (one of features isn't removed, ...)
                                      // if this flag is false -> product info is stored in db, else -> removed
        // define install mode as modify if this product's image was already installed
        //this.rp = Storage("*");        

        ns_installer.Installer.AddProduct(this);

        return true;
    }
*/