//###############################################################
// This file contains definition for:
//  enum install_mode_t
//  class Product
//###############################################################
//Namespace("Root.product", function()
new function()
{
    var micl_id = "{9560B63A-0C5C-479C-8279-8071F86C00F0}";

    var base_script_dir = Origin.Directory();
    //###############################################################
    var load = function(name) {return required(FileSystem.MakePath(name, base_script_dir));};

    var ns_installer = load("installer.js");
    var ns_dump      = load("dumper.js");
    var ns_feature   = load("feature3.js");
    var ns_component = load("component3.js");
    var ns_cmp_inf   = load("component_info.js");
    var ns_arp       = load("component_arp3.js");
    var ns_cmp_micl  = load("component_micl3.js");
    var ns_cmp_is    = load("component_isource3.js");
    var ns_enums     = load("enums.js");
    var ns_container = load("container.js");
    var ns_prop_set  = load("property_set.js");
    var ns_prop      = load("property.js");

    var product_cache_xml = FileSystem.MakePath("..\\" + Cache.config_name, base_script_dir);
    var target_dir = "C:\\DATA\\temp\\_{6789203}_test_installer_folder";
    var rp_hive = "RestorePoint::";

    var ns = this;

    var P = function(val){return ns_prop.Property(val);}
    var ConstP = function(val){return ns_prop.Constant(val);}
    var FilterNotEmpty = function(val)
    {
        if(typeof(val) == undefined || val == null)
            return false;

        return true;
    }
    //###############################################################
    // function to define install mode
    //###############################################################
    var GetInstallModeIdentifier = function(prd)
    {
        return function()
        {
            if(prd.State() == prd.state_t.installed)
            {
                if(prd.ImageInstalled())
                {
                    prd.Log("Current product image " + prd.Image() + " is installed");
                    prd.InstallMode(prd.install_mode_t.modify);
                }
                else
                {
                    prd.Log("Current product image " + prd.Image() + " isn't installed, but some components of " + prd.Name() + " is already installed");
                    prd.InstallMode(prd.install_mode_t.install);
                }
            }
            else
            {
                prd.Log("none components is already installed");
                prd.InstallMode(prd.install_mode_t.install);
            }
        };
    }
    //###############################################################
    /*
    function Transform(args)
    {
        if(args.length == 2 && args[0] && args[1])
        {
            args[1].Id = function(){ return args[0];}
            return args[1];
        }
        else if(args.length == 1)
            return args[0];

        return undefined;
    }
    */
    //###############################################################
    // function to transform storage to object
    //###############################################################
    var storage2object = function(stor)
    {
        if(stor)
        {
            var res = {};
            var childs = stor.childs;
            for(var i in childs)
            {
                var id = childs[i];
                res[id] = stor(id).value;
            }
            return res;
        }

        return {}; // return empty object
    }
    //###############################################################
    // function to transform storage to object recurs
    //###############################################################
    var storage2object_rec = function(stor)
    {
        if(stor)
        {
            var res = {};
            var childs = stor.childs;
            
            if(!childs.length)
                return stor.value;

            for(var i in childs)
            {
                var id = childs[i];
                res[id] = storage2object_rec(stor(id));
            }
            return res;
        }

        return {}; // return empty object
    }

    //###############################################################
    // function to restore product members from RP
    //###############################################################
    var LoadFromRP = function(prd, rp)
    {
        prd.InstallDir.Base(rp("install_dir_base").value);
        prd.InstallDir.Own(rp("install_dir_own").value);

        prd.Log(" installdirbase = " + prd.InstallDir.Base());
        prd.Log(" installdirown = " + prd.InstallDir.Own());
        prd.Log(" loading groups for product");

        var cnfg_opts = rp("ConfigurationOptions");
        for(var i in cnfg_opts.childs)
                prd.ConfigurationOptions().Value(cnfg_opts.childs[i], cnfg_opts(cnfg_opts.childs[i]).value);

        var props = rp("CustomProperties");
        for(var i in props.childs)
                prd.CustomProperties().Value(props.childs[i], props(props.childs[i]).value);

        var groups = rp("groups");
        for(var i in groups.childs)
                prd.AddToGroup(groups(groups.childs[i]).value);

        var objs = rp("CustomObjects");
        for(var i in objs.childs)
                prd.CustomObjects().Add(objs.childs[i], storage2object_rec(objs(objs.childs[i])));
    }
    //###############################################################
    // class Product
    //###############################################################
    var Product = function(inf)
    {
        var prd = ns_feature.Create(inf);
        //arguments.callee.superclass.constructor.call(this);
        prd.Type("product");
        prd.dumper   = ns_dump.Dumper();
        //ns_enums.BindTo(prd);

        prd.Log = log_helper("Product id = " + prd.Id() + ": ");

        prd.Image = P(prd.Id());
        prd.Image.Filter = FilterNotEmpty;
        //prd.curr_image_id =  prd.Id();

        prd.IS = ns_cmp_is.Create({Info : ns_cmp_inf.InfoPure("InstallSource_component_" + prd.Id()) , ISFolder : prd.Id()});
        prd.IS.AddSource(FileSystem.MakePath("..\\" + Cache.config_name, Origin.Directory()));
        prd.IS.Parent(prd);
        prd.MICL = ns_cmp_micl.Create({Info : ns_cmp_inf.InfoPure(micl_id)});
        prd.MICL.Parent(prd);

        //###############################################################
        // Exe which is used for product uninstall
        //###############################################################
        prd.UninstallExe = ConstP(FileSystem.MakePath(FileSystem.exe_name, prd.MICL.TargetDir()));
        //###############################################################
        // Params which is used for product uninstall
        //###############################################################
        prd.UninstallParams = ConstP("--product=\"" + prd.Id() + "\"");
        //###############################################################
        // Full command which is used for product uninstall
        //###############################################################
        prd.UninstallString = ConstP("\"" + prd.UninstallExe() + "\"" + " " + prd.UninstallParams());

        prd.ARP = ns_arp.Create({Info : ns_cmp_inf.InfoPure("ARP_cmp_" + prd.Id()), ARPId : "ARP_for_prd_" + prd.Id()});
        prd.ARP.Parent(prd);
        prd.ARP.DisplayName(prd.Id());
        prd.ARP.UninstallString(prd.UninstallString());
        prd.commit_to_remove = true; // flag which is changed during apply to false
                                      // if there is reason to left this product (one of features isn't removed, ...)
                                      // if this flag is false -> product info is stored in db, else -> removed


        prd.InstallMode = P(prd.install_mode_t.install);
        // custom properties
        // custom properties API
        prd.CustomProperties = ConstP(ns_prop_set.PropertySet());
        prd.CustomObjects = ConstP(ns_container.Container());
        // define install mode as modify if this product's image was already installed
        var rp = Storage("*");
        rp.Read(rp_hive + prd.Id());

        // Loading info stored in RP for this product
        LoadFromRP(prd, rp);

        prd.ContentLoaders = P(ns_container.Container());
        prd.RelationSetters  = P(ns_container.Container());

        prd.ContentLoaders().Log  = log_helper(prd.Log.Prefix() + "ContentLoaders: ");
        prd.RelationSetters().Log = log_helper(prd.Log.Prefix() + "RelationSetters: ");
        prd.CustomObjects().Log   = log_helper(prd.Log.Prefix() + "CustomObjects: ");

        prd.RelationSetters().Add("InstallModeIdentifier", GetInstallModeIdentifier(prd));

        ns_installer.Installer.AddProduct(prd);
        prd.MustBeRemoved = function()
        {
            var state = prd.State();
            var act = prd.Action();
            if(act == prd.action_t.remove || 
               (act == prd.action_t.none && state == prd.state_t.absent))
                return true;

            return false;
        }
        //###############################################################
        //
        //###############################################################
        prd.CacheDir = function(){ return prd.IS.TargetDir();}
        //###############################################################
        prd.TopVisible = P(true);
        //
        //###############################################################
        prd.ImageInstalled = function()
        {
            var images = rp("images");
            prd.Log("Check if Image is installed: current Image = " + prd.Image());
            for(var i = 0, img; img = images.childs[i]; i++)
            {
                prd.Log(" there is installed Image: " + img);
                if(img == prd.Image())
                    return true;
            }
            return false;
        }
        //###############################################################
        //
        //###############################################################
        prd.ProductState = function()
        {
            prd.Log("Get ProductState");
            var images = rp("images");
            prd.Log("Check if any image of this product is installed:");

            if(!images.childs.length)
            {
                prd.Log("nothing images of this product are installed - ProductState: absent");
                return prd.state_t.absent;
            }

            for(var i = 0, img; img = images.childs[i]; i++)
                prd.Log(" there is installed image: " + img);

            prd.Log("ProductState: installed");
            return prd.state_t.installed;
        }
        //###############################################################
        prd.CheckForUpgrade = function ()
        {
            if(prd.Disabled() == prd.disabled_t.yes)
            {
                prd.Log("CheckForUpgrade: product is fully disabled -> check isn't required");
                return;
            }

            prd.Log("CheckForUpgrade: begin");

            if(prd.ProductState() == prd.state_t.installed)
            {
                prd.Log("CheckForUpgrade: product is installed -> check for own upgrade isn't required but check for childs will perform");
            }
            else
            {
                prd.Upgrade().Check();
            }

            prd.Features().Apply(function(el){el.CheckForUpgrade(); return true;});
            prd.Components().Apply(function(el){el.CheckForUpgrade(); return true;});

            prd.Log("CheckForUpgrade: completed");
        }
        //###############################################################
        // DoApplyUpgrade method targeted to be redefinded by descendants
        //###############################################################
        prd.Configurator().Apply.Upgrade.SubscribeOnBegin(function()
        {
            if(prd.ProductState() == prd.state_t.absent)
                prd.Upgrade().Apply();
        });
        //###############################################################
        prd.InstallMode.Subscribe(function(mode)
        {
            // Setting Action for features and components
            if(mode == prd.install_mode_t.install)
            {
                if(prd.MICL)
                    prd.MICL.State(prd.state_t.absent);

                prd.Action(prd.action_t.install);
            }
            else if(mode == prd.install_mode_t.repair)
            {
                prd.Action(prd.action_t.repair);
            }
            else if(mode == prd.install_mode_t.modify)
            {
                if(prd.MICL)
                    prd.MICL.State(prd.state_t.installed);
                prd.Action(prd.action_t.none);
            }
            else if(mode == prd.install_mode_t.remove)
            {
                if(prd.MICL)
                    prd.MICL.State(prd.state_t.installed);
                prd.Action(prd.action_t.remove);
            }

            prd.Refresh();
        });
        prd.InstallMode.Filter(function(mode){if(!mode) return false;});
        //###############################################################
        prd.LoadContent = function ()
        {
            prd.Log("LoadContent begin");
            prd.ContentLoaders().Apply(function(el){el.call(prd); return true;});
            prd.Log("LoadContent completed");
        };
        //###############################################################
        prd.SetRelations = function ()
        {
            prd.Log("Relations set begin");
            prd.RelationSetters().Apply(function(el){el.call(prd); return true;});
            prd.Log("Relations set completed");
        };
        //###############################################################
        prd.GenerateNodes = function ()
        {
            prd.Log("GenerateNodes");

            var node_from_feature = function(n,f)
            {
                var self = arguments.callee;

                if(!f.Visible())
                    return;

                var nf = new Node();

                f.SetNode(nf);

                if(n)
                    n.AddChild(nf.guid);

                f.Features().Apply(function(el){self(nf, el); return true;});
            }

            if(prd.TopVisible())
                node_from_feature(null, prd);
            else
                prd.Features().Apply(function(el){node_from_feature(null, el); return true;});

            prd.Refresh();

            prd.Log("GenerateNodes complete");
        }
        //###############################################################
        if(prd.ARP)
        {
            prd.InstallDir.Cascade(prd.ARP.InstallDir);
            prd.Disabled.Cascade(prd.ARP.Disabled);
        }

        if(prd.IS)
        {
            prd.InstallDir.Cascade(prd.IS.InstallDir);
            prd.Disabled.Cascade(prd.IS.Disabled);
        }

        if(prd.MICL)
            prd.Disabled.Cascade(prd.MICL.Disabled);
        //###############################################################
        prd.Action.Subscribe( function (act)
        {
            var ract = (act == prd.action_t.mix) ? prd.action_t.install : act;
            prd.DoSetAction(ract);
        });
        //###############################################################
        prd.DoSetAction = function (act)
        {
            if(prd.ARP)
                prd.ARP.Action(act);

            if(prd.IS)
                prd.IS.Action(act);

            if(prd.MICL)
                prd.MICL.Action(act);

            return true;
        };
        //###############################################################
        // ApplyResolveSrc method definition
        //###############################################################
        prd.Configurator().Apply.ResolveSrc.SubscribeOnEnd(function(dmp)
        {
            prd.Log("Do required actions by the end of DoApplyResolveSrc");
            if(!prd.MustBeRemoved())
            {
                prd.Log("There is feature/component installed or targeted for installation, therefore product will be asked for sources resolving ...");
                if(prd.ARP && !prd.ARP.ApplyResolveSrc(dmp))
                    return false;

                if(prd.IS && !prd.IS.ApplyResolveSrc(dmp))
                    return false;

                if(prd.MICL && !prd.MICL.ApplyResolveSrc(dmp))
                    return false;
            }
            prd.Log("Do required actions by the end of DoApplyResolveSrc complete");

            return true;
        });
        //###############################################################
        prd.Configurator().Apply.Remove.SubscribeOnEnd(function(dmp)
        {
            prd.Log("Do required actions by the end of DoApplyRemove");

            if(prd.MustBeRemoved())
            {
                prd.Log("There isn't any feature/component installed or targeted for installation, therefore product will be removed...");
                prd.Action(prd.action_t.remove);

                if(prd.ARP && !prd.ARP.ApplyRemove(dmp))
                    return false;

                if(prd.IS && !prd.IS.ApplyRemove(dmp))
                    return false;

                if(prd.MICL && !prd.MICL.ApplyRemove(dmp))
                    return false;

                if(dmp && dmp.IsDumper)
                    dmp.AddAction(prd.dumper,"dmpr_" + prd.Name());
                else
                    prd.Log("ApplyRemove: Can't schedule actions - input dumper is undefined or not a dumper (!dmp.IsDumper)");

                //ns_installer.Installer.Dumper.AddAction(prd.dumper);
            }
            prd.Log("Do required actions by the end of DoApplyRemove complete");

            return true;
        });
        //###############################################################
        prd.Configurator().Apply.Install.SubscribeOnEnd(function(dmp)
        {
            prd.Log("Do required actions by the end of DoApplyInstall");
            if(!prd.MustBeRemoved())
            {
                prd.Log("There is feature/component installed or targeted for installation, therefore product will be installed..");
                if(prd.ARP && !prd.ARP.ApplyInstall(dmp))
                    return false;

                if(prd.IS && !prd.IS.ApplyInstall(dmp))
                    return false;

                if(prd.MICL && !prd.MICL.ApplyInstall(dmp))
                    return false;

                if(dmp && dmp.IsDumper)
                    dmp.AddAction(prd.dumper,"dmpr_" + prd.Name());
                else
                    prd.Log("ApplyInstall: Can't schedule actions - input dumper is undefined or not a dumper (!dmp.IsDumper)");

                //ns_installer.Installer.Dumper.AddAction(prd.dumper);
            }
            prd.Log("Do required actions by the end of DoApplyInstall complete");

            return true;
        });
        //###############################################################
        prd.PreAction = function () { return prd.dumper.PreAction(); }
        //###############################################################
        prd.PostAction = function () { return prd.dumper.PostAction(); }
        //###############################################################
        prd.Configurator().Commit.SubscribeOnEnd(function()
        {
            prd.Log("Do required actions by the end of DoCommit");

            if(prd.MustBeRemoved())
            {
                prd.Log("will be removed");
                Storage("*").Write(rp_hive + prd.Id());
            }
            else
            {
                prd.Log("will be saved");

                var images = rp("images");
                images(prd.Image()).value = prd.Image();
                prd.RestorePoint(rp);
                rp.Write(rp_hive + prd.Id());

                prd.Log("Saved successful");
            }
            prd.Log("Do required actions by the end of DoCommit complete");

            return true;
        });
        //###############################################################
        var ftr_get_size = prd.get_size;
        prd.get_size = function ()
        {
            var size = ftr_get_size();

            if(prd.ARP)
                size += prd.ARP.Size();

            if(prd.IS)
                size += prd.IS.Size();

            if(prd.MICL)
                size += prd.MICL.Size();

            return size;
        };
        //###############################################################
        var orig_rest_p = prd.RestorePoint;
        prd.RestorePoint = function (st)
        {
            var rp = st ? st : rp;

            orig_rest_p(rp);

            if(prd.ARP)
                prd.ARP.RestorePoint(rp("ARP"));

            if(prd.IS)
                prd.IS.RestorePoint(rp("IS"));

            if(prd.MICL)
                prd.MICL.RestorePoint(rp("MICL"));

            var pps = rp("CustomProperties");
            prd.CustomProperties().Filter(function(nm,val){pps(nm).value = val;});

/*
            if(prd.custom_properties)
            {
                var custom = rp("CustomProperties");
                for(var i in prd.custom_properties)
                    custom(i).value = prd.custom_properties[i];
            }
*/
            var rp_images = rp("images");

            for(var i in rp("images").childs)
            {
                rp_images(rp("images").childs[i]).value = rp("images").childs[i];
            }

            // storing CustomObjects
            
            // default RestorePoint function to process simple objects (hash of properties)
            var def_RP = function(st, obj)
            {
                for(var key in obj)
                {
                    if(typeof(obj[key]) == "object")
                        def_RP(st(key), obj[key]);
                    else
                        st(key).value = obj[key];
                }
                    
            }

            var co_rp = rp("CustomObjects");
            var items = prd.CustomObjects().Items();

            for(var i in items)
            {
                if(items[i].RestorePoint && typeof(items[i].RestorePoint) == "function")
                    items[i].RestorePoint(co_rp(i));
                else
                    def_RP(co_rp(i),items[i]);
            }

            return rp;
        }

        // get list of products
        prd.ProductList = function()
        {
            var storage = Storage("ProductList::*");
            storage.Read(rp_hive);

            var res = [];

            var childs = storage.childs;
            for(var i in childs)
            {
                var p = storage(childs[i]);
                res[p.name] = storage2object(p("CustomProperties"));
            }
            storage.Clear(); // clean storage
            return res;
        }

        // update micl_id value based on data from config file
        var cfg_file = FileSystem.Exists(product_cache_xml) ?  product_cache_xml : Cache.Config();
        if(FileSystem.Exists(cfg_file))
        {
            var root = XML(cfg_file);
            if(root)
            {
                var cfg = root.node("/config/micl[@id]");
                if(cfg)
                {
                    var id = cfg.attributes.id;
                    if(id)
                    {
                        Log("MICL id configured: " + id);
                        micl_id = id;
                    }
                }
            }
        }

        return prd;
    }

    //###############################################################
    // Product constructor
    //###############################################################
    this.Create = function(inf, ex_init)
    {
        if(!inf)
            return null;

        var r_info = inf.GetInfo();
        if(!r_info || !r_info.Id || !r_info.Id())
        {
            Log(Log.l_error, "Attempt to create product with undefined Id - input info isn't defined or doesn't have Id or Id() is empty");
            return null;
        }

        var prd = ns_installer.Installer.Products[r_info.Id()];

        if(!prd)
        {
            prd = Product(r_info);
            if(!prd)
                return null;

            if(ex_init)
                ex_init.call(prd);
        }
        return prd;
    }
}