new function()
{
    var load = function(name) {return required(FileSystem.AbsPath(Origin.Directory(), name));}
    var ns_event = load("event.js");
    //###############################################################
    //class Property
    //###############################################################
    this.Property = function(def_val)
    {
        var on_set = ns_event.FEvent();

        var value = (arguments.length > 0) ? def_val : undefined;

        var prop = function(val)
        {
            if(arguments.length > 0)
                return _set(val);
            else
                return _get();
        }
        
        //###############################################################
        // required functions
        //###############################################################
        function _set(val)
        {
            if(prop.Filter(val))
            {
                var v = prop.Transform(val);
                var res = prop.Set(v);
                on_set(v);
                return res;
            }

            return prop.Get();
        }

        function _get(){ return prop.Get(); }

        function un_function(val)
        {
            if(typeof(val) == "function")
                return val();
            return val;
        }
        //###############################################################
        
        prop.Filter = function(val){ return true;}
        prop.Transform = function(val){ return val;}
        prop.DefaultSet = function(val){value = prop.Transform(val); return value;}
        prop.Set = prop.DefaultSet;
        prop.Subscribe = function(cb) {on_set.Connect(cb);}
        prop.Cascade = function(p) {prop.Subscribe(function(v) {p(v);});}

        prop.DefaultGet = function(){ return un_function(value);}
        prop.Get = prop.DefaultGet;
        // get raw value - without undecoration
        prop.GetRaw = function(){ return value; }

        return prop;
    }
    //###############################################################
    //class Constant Property
    //###############################################################
    this.Constant = function(def_val)
    {
        var on_set = ns_event.FEvent();

        var value = (arguments.length > 0) ? def_val : undefined;

        var prop = function(val){ return _get();}
        //###############################################################
        // required functions
        //###############################################################
        function _get(){ return prop.Get(); }

        function un_function(val)
        {
            if(typeof(val) == "function")
                return val();
            return val;
        }
        //###############################################################
        prop.DefaultGet = function(){ return un_function(value);}
        prop.Get = prop.DefaultGet;
        // get raw value - without undecoration
        prop.GetRaw = function(){ return value; }

        return prop;
    }
}
