
/*
    Locking queue implementation

    Push(obj) - push object to queue
    var obj = Pop(); - pop object from queue - locked till at least one object is available
*/

new function()
{
    this.Queue = function()
    {
        var sema = Semaphore();
        var lock = Mutex();
        var data = [];

        var queue = {};

        queue.Push = function(obj)
        {
            lock.Lock();
            data.unshift(obj);
            sema.Inc();
            lock.Unlock();
        }

        queue.Pop = function()
        {
            sema.Dec();
            lock.Lock();
            var obj = data.pop();
            lock.Unlock();
            return obj;
        }

        queue.Clear = function()
        {
            lock.Lock();
            while(sema.count)
                sema.Dec();
            data = [];
            lock.Unlock();
        }

        return queue;
    }
}


