new function()
{
    this.Create = function()
    {
        var actions = [];
        var iterator = 0;

        var on_cancel = function() {};
        var on_error  = function() {};
        var on_finish = null;

        var scenario = function() {return scenario.Run();};

        var get_next = function(current)
        {
            if(current >= actions.length)
                return null;
            
            for(var i = current; i < actions.length; i++)
            {
                var act = actions[i];
                if((act.Skip && !act.Skip()) || !act.Skip)
                {
                    iterator = i;
                    return act;
                }
            }

            return null;
        }
        
        var get_prev = function(current)
        {
            if(current < 0)
                return null;
            
            for(var i = current; i >= 0; i--)
            {
                var act = actions[i];
                if((act.Skip && !act.Skip()) || !act.Skip)
                {
                    iterator = i;
                    return act;
                }
            }
                    
            return null;
        }

        scenario.Run = function()
        {
            Log("Scenario launched");
        
            if(actions.length)
            {
                var result = Action.r_ok;
                do
                {
                    var act = get_next(iterator);
                    if(act)
                    {
                        result = act();
                        Log("action return code: " + result);
                        switch(result)
                        {
                        case Action.r_ok:
                            act = get_next(iterator + 1);
                            break;
                        case Action.r_back:
                            act = get_prev(iterator - 1);
                            break;
                        case Action.r_error:
                            Log("Scenario failed");
                            var r = on_error();
                            if(typeof(r) != "undefined")
                                return r;
                            return result;
                        case Action.r_cancel:
                            Log("Scenario canceled");
                            if(!Splash.Canceled()) // if process canceled not on splash - call callback function
                            {
                                var r = on_cancel();
                                if(typeof(r) != "undefined")
                                    return r;
                            }
                            return result;
                        default:
                            Log("Scenario aborted: " + result);
                            return result;
                        }
                    }
                }while(act);
                
                if(on_finish)
                {
                    Wizard.Notify("title", "no-cancel-confirm");
                    var r = on_finish();
                    if(typeof(r) != "undefined")
                        return r;
                }
            }
            Log("Scenario finished");
            //return Action.r_ok;
            return result;
        }

        scenario.Add = function(action, execute_once)
        {
            if(!action)
            {
                Log(Log.l_warning, "requested to add empty action (not defined object). Ignore.");
                return;
            }

            if(!execute_once)
                actions.push(action);
            else
            {
                var executed = false;
                var act = function() {executed = true; return action();}
                act.Skip = function() {return executed || (action.Skip && action.Skip());}
                actions.push(act);
            }
        }

        scenario.OnCancel = function(f)
        {
            on_cancel = f;
        }

        scenario.OnError = function(f)
        {
            on_error = f;
        }

        scenario.OnFinish = function(f)
        {
            on_finish = f;
        }

        scenario.AllSkipped = function()
        {
            for(var i in actions)
            {
                if(!actions[i].Skip)
                    return false;
                else if(!actions[i].Skip())
                    return false;
            }
            return true;
        }

        scenario.Skip = scenario.AllSkipped;

        scenario.Reset = function() {iterator = 0;}

        return scenario;
    }
}
