new function()
{
    var ns_enums;
    var ns_installer;
    var ns_version;
    var ns_cmp_msi;
    var ns_info;

    //var ProductToUpgrade_id = "_aux_product_contains_cmps_for_upgrade";
    //var ProductToUpgrade = null;

    var is_initialized = false;

    this.Init = function()
    {
        if(is_initialized)
            return;

        ns_installer = Namespace("Root.installer");

        var base_script_dir = Origin.Directory();
        var load = function(name) {return required(FileSystem.MakePath(name, base_script_dir));};
        
        ns_enums     = load("enums.js");
        ns_version   = load("version.js");

        ns_cmp_msi   = load("component_msi.js");
        ns_info      = load("component_info.js");

        is_initialized = true;
    }

    var ns = this;
    //###############################################################
    //class UpgradeTarget
    //###############################################################
    this.UpgradeTarget = this.UpgradeTarget || function(obj, type, act, st)
    {
        ns_enums.BindTo(this);

        this.m_target_obj = obj;
        this.m_action = act;
        this.m_type = type;
        this.m_state = st;
    }
    //###############################################################
    this.UpgradeTarget.prototype.Object = function() { return this.m_target_obj; }
    //###############################################################
    this.UpgradeTarget.prototype.Action = function(act)
    {
        if(act)
            this.m_action = act;

        return this.m_action;
    }
    //###############################################################
    this.UpgradeTarget.prototype.Type = function() { return this.m_type; }
    this.UpgradeTarget.prototype.State = function() { return this.m_state; }
    //###############################################################
    this.UpgradeTarget.prototype.Apply = function()
    {
        //apply upgrade -> removing targets
        if(this.m_target_obj.Action && this.m_action == this.action_t.remove)
        {
            this.m_target_obj.Action(this.action_t.remove);
            
            if(ns_installer.Installer.AddObjectToUpgrade)
                ns_installer.Installer.AddObjectToUpgrade(this.m_target_obj);
        }

        return true;
    }
//###################################################################
//###################################################################
    //###############################################################
    //class UpgradeEntry
    //###############################################################
    this.UpgradeEntry = this.UpgradeEntry || function(owner, type, act)
    {
        ns_enums.BindTo(this);
        this.Log = this.Log || log_helper("Upgrade Entry: ");

        this.owner = owner;
        
        if(!this.owner.Version)
            Log("UpgradeEntry Initialization: Attention: owner with id "+this.owner.Id()+" doesn't have method \"Version\"");
        
        this.m_v_min = ns_version.Version();
        this.m_v_max = ns_version.Version();
        this.m_same_dir = false;
        this.m_type  = type ? type : this.upgrade_type_t.mandatory;
        this.m_action  = (this.m_type == this.upgrade_type_t.mandatory) ? this.action_t.remove : (act ? act : this.action_t.remove);

        this.m_targets = [];
        this.m_processor = null;
    }
    //###############################################################
    // VMin
    //###############################################################
    this.UpgradeEntry.prototype.VMin = function (str) { this.m_v_min = ns_version.Version(str);}
    //###############################################################
    // VMax
    //###############################################################
    this.UpgradeEntry.prototype.VMax = function (str) { this.m_v_max = ns_version.Version(str);}
    //###############################################################
    // SameDirOnly
    //###############################################################
    this.UpgradeEntry.prototype.SameDirOnly = function (v)
    {
        if(v == undefined)
            return this.m_same_dir;

        if(v)
            this.m_same_dir = true;
        else
            this.m_same_dir = false;
    }
    //###############################################################
    // Checks for upgrade
    //###############################################################
    this.UpgradeEntry.prototype.Check = function () { return true; }
    //###############################################################
    // Reset
    //###############################################################
    this.UpgradeEntry.prototype.Reset = function ()
    {
        //this.m_state = this.upgrade_state_t.none;
        this.m_targets = [];
        //this.m_state = this.upgrade_state_t.allowed;
        return true;
    }
    //###############################################################
    // returns array of targets for upgrade
    //###############################################################
    this.UpgradeEntry.prototype.Targets = function () { return this.m_targets; }
    //###############################################################
    this.UpgradeEntry.prototype.OlderExists = function ()
    {
        for(var i in this.m_targets)
            if(this.m_targets[i].State() == this.upgrade_state_t.upgrade)
                return true;
        
        return false;
    }
    //###############################################################
    this.UpgradeEntry.prototype.NewerExists = function ()
    {
        for(var i in this.m_targets)
            if(this.m_targets[i].State() == this.upgrade_state_t.downgrade)
                return true;
        
        return false;
    }
    //###############################################################
    this.UpgradeEntry.prototype.SameExists = function ()
    {
        for(var i in this.m_targets)
            if(this.m_targets[i].State() == this.upgrade_state_t.same)
                return true;
        
        return false;
    }
    //###############################################################
    // add obj to targets for upgrade
    //###############################################################
    this.UpgradeEntry.prototype.AddTarget = function (obj)
    {
        var state = this.DefineUpgradeState((obj.Version ? obj.Version() : ""));
        
        this.Log("add object: " + obj.Id() + " to targets for upgrade with state = " + state);
        var act = this.m_action;
        
        if(state == this.upgrade_state_t.same || state == this.upgrade_state_t.downgrade)
            act = this.action_t.none;

        this.m_targets.push(new ns.UpgradeTarget(obj, this.m_type, act, state));
    }
    //###############################################################
    // Type
    //###############################################################
    //this.UpgradeEntry.prototype.Type = function () { return this.m_state; }
    //###############################################################
    // State
    //###############################################################
    this.UpgradeEntry.prototype.State = function () 
    {
        var c_state = this.upgrade_state_t.none;
        
        for(var i in this.m_targets)
        {
            if(c_state == this.upgrade_state_t.mix)
                break;

            //if(this.m_targets[i].State() == this.upgrade_state_t.none)
            //    continue;

            if(c_state == this.upgrade_state_t.none)
                c_state = this.m_targets[i].State();
            else if(c_state != this.m_targets[i].State())
                c_state = this.upgrade_state_t.mix;
        }
        
        return c_state;
    }
    //###############################################################
    //VerifyVersionRange checks that version match the required conditions
    //###############################################################
    this.UpgradeEntry.prototype.VerifyVersionRange = function (ver)
    {
        this.Log("VerifyVersionRange");
        if(this.m_v_min.IsNULL() && this.m_v_max.IsNULL())
        {
            this.Log("version range is undefined, therefore any version is acceptable");
            return true;
        }

        if(!ver)
        {
            this.Log("ver = \"" +ver +"\" doesn't belong to required range");
            return false;
        }

        var iver = ns_version.Version(ver);

        if( iver.IsNull() ||
            (!this.m_v_min.IsNull() && iver.lt(this.m_v_min)) ||
            (!this.m_v_max.IsNull() && ver.gt(this.m_v_max))
            )// input version isn't defined or doesn't belong to required range
        {
            this.Log("ver = \"" +ver +"\" doesn't belong to required range");
            return false;
        }

        return true;
    }
    //###############################################################
    //VerifyVersion checks that version match the required conditions
    //###############################################################
    this.UpgradeEntry.prototype.DefineUpgradeState = function (ver)
    {
        if(!ver || !this.owner.Version)
            return this.upgrade_state_t.upgrade;

        var iver = ns_version.Version(ver);

        if(iver.eq(this.owner.Version()))
            return this.upgrade_state_t.same;
        else if(iver.lt(this.owner.Version()))
            return this.upgrade_state_t.upgrade;
        //else //if(iver.gt(this.owner.Version()))
        
        return this.upgrade_state_t.downgrade;
    }
    //###############################################################
    //VerifyVersion checks that version match the required conditions
    //###############################################################
    this.UpgradeEntry.prototype.VerifyInstallDir = function (path)
    {
        if( !this.SameDirOnly()  )
            return true;

        if(!path || path == "")
            return false;

        this.Log("VerifyInstallDir: owner.id = "+this.owner.Id()+": input path = " + path + " owner path = " + this.owner.InstallDir() );

        if(FileSystem.MakePath(path) == FileSystem.MakePath(this.owner.InstallDir()))
            return true;

        return false;
    }
    //###############################################################
    //Apply method targets all found elements to remove
    //###############################################################
    this.UpgradeEntry.prototype.Apply = function ()
    {
        this.Log("Upgrade Entry: Apply begin");

        if(this.m_state == this.upgrade_state_t.none)
            return false;

        for(var i in this.m_targets)
            this.m_targets[i].Apply();

        this.Log("Upgrade Entry: Apply end");
        return true;
    }
//###################################################################
//###################################################################
    //###############################################################
    //class GroupUpgradeEntry
    //###############################################################
    this.GroupUpgradeEntry = this.GroupUpgradeEntry || function(owner, id, type, act)
    {
        arguments.callee.superclass.constructor.call(this, owner, type, act);
        this.Log = log_helper("GroupUpgradeEntry \"" + id + "\": ");
        this.m_group_id = id;
    }
    //###############################################################
    // GroupUpgradeEntry is inheritted from UpgradeEntry
    extend(this.GroupUpgradeEntry, ns.UpgradeEntry);
    //###############################################################
    // Check verifies each object from group for upgrade ability
    //###############################################################
    this.GroupUpgradeEntry.prototype.Check = function ()
    {
        this.Reset();
        this.Log("Check");
        var grp = ns_installer.Installer.Groups[this.m_group_id];
        if(!grp)
            return false;

        var obj = null;

        for(var i in grp)
        {
            var obj = grp[i];
            
            this.Log("Check object with id " + obj.Id());

            if(obj == this.owner)
            {
                this.Log("It is the same object as upgrade owner - skip from checking");
                continue;
            }

            if(this.VerifyInstallDir((obj.InstallDir ? obj.InstallDir() : "")) &&
               this.VerifyVersionRange((obj.Version ? obj.Version() : ""))
               )
            {
                this.AddTarget(obj);
            }
        }
        this.Log("Check end");
        return true;
    }
//###################################################################
//###################################################################
    //###############################################################
    //class MSIComponentCodeUpgradeEntry
    //###############################################################
    this.MSIComponentCodeUpgradeEntry = this.MSIComponentCodeUpgradeEntry || function(owner, id, type, act)
    {
        arguments.callee.superclass.constructor.call(this, owner, type, act);
        this.Log = log_helper("MSIComponentCodeUpgradeEntry \"" + id + "\": ");
        this.m_msi_cc = id;
    }
    //###############################################################
    // MSIComponentCodeUpgradeEntry is inheritted from UpgradeEntry
    extend(this.MSIComponentCodeUpgradeEntry, ns.UpgradeEntry);
    //###############################################################
    // Check verifies each object from clients for msi component code for upgrade ability
    //###############################################################
    this.MSIComponentCodeUpgradeEntry.prototype.Check = function ()
    {
        this.Reset();
        this.Log("Check");

        var clients = [];

        if(this.SameDirOnly())
            clients = WI.ClientsInstalledComponent(this.m_msi_cc, this.owner.InstallDir());
        else
            clients = WI.ClientsInstalledComponent(this.m_msi_cc);

        var cl = null;

        for(var i in clients)
        {
            cl = clients[i];
            this.Log("Check object with id " + cl.Id);
            if(this.VerifyVersionRange(cl.Version))
            {
                var state = this.DefineUpgradeState(cl.Version);
                if(state != this.upgrade_state_t.none)
                {
                    var cmp = ns_installer.Installer.Components[cl.Id];
                    
                    if(!cmp)
                    {
                        var wi_info = ns_info.InfoWI(cl.Id);
                        var c_info = ns_info.ComponentInfo();
                        c_info.AddInfo(wi_info);
                    
                        cmp = ns_cmp_msi.Create(c_info);

                        //cmp = ns_cmp_msi.Create(cl.Id);
                        //Create returns a clone, but what if someone create another clone?
                        // in that case remove will not have an effect therefore core component should be used
                        // in any case
                        cmp = ns_installer.Installer.Components[cl.Id]; 
                    }
                    else
                    {
                        this.Log(" Component with id " + cl.Id + " exists in installer");
                    }

                    this.Log(" found prod id = \"" + cmp.Id() + "\" name = \"" + cmp.Name() + "\" ver = " + cmp.Version().Str() + " this ver =" + this.owner.Version().Str() )
                                        
                    this.AddTarget(cmp);
                }
            }
        }

        this.Log("Check end");
        return true;
    }
//###################################################################
//###################################################################
    //###############################################################
    //class MSIProductCodeUpgradeEntry
    //###############################################################
    this.MSIProductCodeUpgradeEntry = this.MSIProductCodeUpgradeEntry || function(owner, id, type, act)
    {
        arguments.callee.superclass.constructor.call(this, owner, type, act);
        this.Log = log_helper("MSIProductCodeUpgradeEntry \"" + id + "\": ");
        this.m_msi_pc = id;
    }
    //###############################################################
    // MSIProductCodeUpgradeEntry is inheritted from UpgradeEntry
    extend(this.MSIProductCodeUpgradeEntry, ns.UpgradeEntry);
    //###############################################################
    // Check verifies each object from clients for msi component code for upgrade ability
    //###############################################################
    this.MSIProductCodeUpgradeEntry.prototype.Check = function ()
    {
        this.Reset();
        this.Log("Check for existence of WI product with pcode \"" + this.m_msi_pc + "\"" );

        var cmp = ns_installer.Installer.Components[this.m_msi_pc];

        if(!cmp)
        {
            var wi_info = ns_info.InfoWI(this.m_msi_pc);
            var c_info = ns_info.ComponentInfo();
            c_info.AddInfo(wi_info);
                    
            cmp = ns_cmp_msi.Create(c_info);

            //cmp = ns_cmp_msi.Create(this.m_msi_pc, this.m_msi_pc);
            //Create returns a clone, but what if someone create another clone?
            // in that case remove will not have an effect therefore core component should be used
            // in any case
            cmp = ns_installer.Installer.Components[this.m_msi_pc]; 
        }
        else
        {
            this.Log(" Component with id " + this.m_msi_pc + " exists in installer");
        }

        if(cmp.State() != this.state_t.installed)
            this.Log("Product isn't installed");
        else
        {
            this.Log("Product is installed.");

            this.AddTarget(cmp);            
        }
        this.Log("Check end");
        return true;
    }
//###################################################################
//###################################################################
    //###############################################################
    //class MSIUpgradeCodeUpgradeEntry
    //###############################################################
    this.MSIUpgradeCodeUpgradeEntry = this.MSIUpgradeCodeUpgradeEntry || function(owner, id, type, act)
    {
        arguments.callee.superclass.constructor.call(this, owner, type, act);
        this.Log = log_helper("MSIUpgradeCodeUpgradeEntry \"" + id + "\": ");
        this.m_msi_uc = id;
    }
    //###############################################################
    // MSIUpgradeCodeUpgradeEntry is inheritted from UpgradeEntry
    extend(this.MSIUpgradeCodeUpgradeEntry, ns.UpgradeEntry);
    //###############################################################
    // Check verifies each object from clients for msi component code for upgrade ability
    //###############################################################
    this.MSIUpgradeCodeUpgradeEntry.prototype.Check = function ()
    {
        this.Reset();
        this.Log("Check" );

        var prods = WI.RelatedProducts(this.m_msi_uc);
        var wi_prods = [];
        
        if(prods && prods.length)
        {
            for(var i in prods)
            {
                var cmp = ns_installer.Installer.Components[prods[i]];
                
                if(!cmp)
                {
                    var wi_info = ns_info.InfoWI(prods[i]);
                    var c_info = ns_info.ComponentInfo();
                    c_info.AddInfo(wi_info);
                    
                    cmp = ns_cmp_msi.Create(c_info);
                    //Create returns a clone, but what if someone create another clone?
                    // in that case remove will not have an effect therefore core component should be used
                    // in any case
                    cmp = ns_installer.Installer.Components[prods[i]];
                }
                else
                {
                    this.Log(" Component with id " + prods[i] + " exists in installer");
                }

                wi_prods.push(cmp);
            }
        }
        
        var prod = null;
        for(var i in wi_prods)
        {
            prod = wi_prods[i];
            if(this.VerifyVersionRange(prod.Version()))
            {
                this.Log(" found prod id = \"" + prod.Id() + "\" name = \"" + prod.Name() + "\" ver = " + prod.Version().Str() + " this ver =" + this.owner.Version().Str() )
                var state = this.DefineUpgradeState(prod.Version());

                if(state != this.upgrade_state_t.none)
                {
                    this.AddTarget(prod);
                }
            }
        }
        
        this.Log("Check end");
        return true;
    }
//###################################################################
//###################################################################
    //###############################################################
    //class Upgrade
    //###############################################################
    this.Upgrade = this.Upgrade || function(owner)
    {
        ns.Init();
        ns_enums.BindTo(this);

        this.owner = owner;
        //this.m_downgrade_forbidden = true;
        this.m_entries = {};
    }
    //###############################################################
    this.Upgrade.prototype.EntryExist = function(id){ return id != undefined ? this.m_entries[id] : false; }
    //###############################################################
    this.Upgrade.prototype.OlderExists = function ()
    {
        for(var i in this.m_entries)
            if(this.m_entries[i].OlderExists())
                return true;
        
        return false;
    }
    //###############################################################
    this.Upgrade.prototype.NewerExists = function ()
    {
        for(var i in this.m_entries)
            if(this.m_entries[i].NewerExists())
                return true;
        
        return false;
    }
    //###############################################################
    this.Upgrade.prototype.SameExists = function ()
    {
        for(var i in this.m_entries)
            if(this.m_entries[i].SameExists())
                return true;
        
        return false;
    }
    //###############################################################
    this.Upgrade.prototype.Targets = function()
    {
        var arr = [];
        for(var i in this.m_entries)
        {
            arr = arr.concat(this.m_entries[i].Targets());
        }

        return arr;
    }
    //###############################################################
    this.Upgrade.prototype.AddEntry = function(id, obj)
    {
        if(!id || !obj || this.EntryExist(id))
            return;
        
        this.m_entries[id] = obj;
    }
    //###############################################################
    this.Upgrade.prototype.State = function()
    { 
        var c_state = this.upgrade_state_t.none;

        for(var i in this.m_entries)
        {
            if(c_state == this.upgrade_state_t.mix)
                break;

            var entry_st = this.m_entries[i].State();

            if(entry_st == this.upgrade_state_t.none)
                continue;

            if(c_state == this.upgrade_state_t.none)
                c_state = entry_st;
            else if(c_state != entry_st)
                c_state = entry_st;
        }

        return c_state;
    }
    /*
    //###############################################################
    // DowngradeForbidden
    //###############################################################
    this.Upgrade.prototype.DowngradeForbidden = function ()
    {
        if(arguments.length)
            this.m_downgrade_forbidden = arguments[0] ? true : false;

        return this.m_downgrade_forbidden;
    }
    */
    //###############################################################
    // Check
    //###############################################################
    this.Upgrade.prototype.Check = function ()
    {
        for(var i in this.m_entries)
            this.m_entries[i].Check();
    }
    //###############################################################
    // Apply
    //###############################################################
    this.Upgrade.prototype.Apply = function ()
    {
        for(var i in this.m_entries)
            this.m_entries[i].Apply();
        
        return true;
    }
    //###############################################################
    // Provide an ability for upgrading by Group
    //###############################################################
    this.Upgrade.prototype.Group = function (group_id, v_min, v_max, same_dir_only, type, def_act)
    {
        if(!group_id)
            return false;

        var id = "group_" + group_id + "_" + 
                 (v_min ? v_min : "") + "_" + 
                 (v_max ? v_max : "") + "_" + 
                 (same_dir_only ? "same_dir" : "any_dir") + "_" +
                 type + "_" +
                 def_act;
        
        if(this.EntryExist(id))
            return true;

        var ue = new ns.GroupUpgradeEntry(this.owner, group_id, type, def_act);
        ue.VMin(v_min);
        ue.VMax(v_max);
        ue.SameDirOnly(same_dir_only);

        this.AddEntry(id, ue);

        return true;
    }
    //###############################################################
    // Provide an ability for upgrading by MSI Component Code(Guid)
    //###############################################################
    this.Upgrade.prototype.MSICmpCode = function (msi_cmp_code, v_min, v_max, same_dir_only, type, def_act)
    {
        if(!msi_cmp_code)
            return false;

        var id = "MSICmpCode_" + msi_cmp_code + "_" + 
                 (v_min ? v_min : "") + "_" + 
                 (v_max ? v_max : "") + "_" + 
                 (same_dir_only ? "same_dir" : "any_dir") + "_" +
                 type + "_" +
                 def_act;

        if(this.EntryExist(id))
            return true;

        var ue = new ns.MSIComponentCodeUpgradeEntry(this.owner, msi_cmp_code, type, def_act);
        ue.VMin(v_min);
        ue.VMax(v_max);
        ue.SameDirOnly(same_dir_only);

        this.AddEntry(id, ue);

        return true;
    }

    //###############################################################
    // Provide an ability for upgrading by MSI Product Code(Guid)
    //###############################################################
    this.Upgrade.prototype.MSIProductCode = function (msi_pcode, type, def_act)
    {
        if(!msi_pcode)
            return false;

        var id = "MSIPrdCode_" + msi_pcode + "_" + 
                 type + "_" +
                 def_act;

        if(this.EntryExist(id))
            return true;

        var ue = new ns.MSIProductCodeUpgradeEntry(this.owner, msi_pcode, type, def_act);
        ue.VMin(v_min);
        ue.VMax(v_max);
        ue.SameDirOnly(false);

        this.AddEntry(id, ue);

        return true;
    }
    //###############################################################
    // Provide an ability for upgrading by MSI Upgrade Code(Guid)
    //###############################################################
    this.Upgrade.prototype.MSIUpgradeCode = function (msi_ucode, v_min, v_max, type, def_act)
    {
        if(!msi_ucode)
            return false;

        var id = "MSIUpgrCode_" + msi_ucode + "_" + 
                 (v_min ? v_min : "") + "_" + 
                 (v_max ? v_max : "") + "_" + 
                 type + "_" +
                 def_act;

        if(this.EntryExist(id))
            return true;

        var ue = new ns.MSIUpgradeCodeUpgradeEntry(this.owner, msi_ucode, type, def_act);
        ue.VMin(v_min);
        ue.VMax(v_max);
        ue.SameDirOnly(false);

        this.AddEntry(id, ue);

        return true;
    }
}
//end new function()