
new function()
{
    var ns = this;

    this.TypeName = function(){ return "object_version";}

    this.Version = function(iver, delim)
    {
        var obj_type = ns.TypeName();

        if(typeof(delim) == "undefined" || !delim)
            delim = /\D+/;

        if(typeof iver == "undefined" || !iver)
            iver = "0.0.0.0";

        var version_string = iver;
        var ver = {};

        var major = 0;
        var minor = 0;
        var revision = 0;
        var build = 0;

        if(iver instanceof Array)
            var spl = iver;
        else if(typeof(iver) == "string")
            var spl = iver.split(delim, 4);
        else
            return iver;

        if(spl.length > 0)
            major = parseInt(spl[0]);
        if(spl.length > 1)
            minor = parseInt(spl[1]);
        if(spl.length > 2)
            revision = parseInt(spl[2]);
        if(spl.length > 3)
            build = parseInt(spl[3]);

        ver.Major = function() {return major;}
        ver.Minor = function() {return minor;}
        ver.Revision = function() {return revision;}
        ver.Build = function() {return build;}
        ver.Str = function() {return version_string;}
        ver.Array = function() {return [major, minor, revision, build];}

        ver.IsNULL = function()
        {
            return major == 0 && minor == 0 && revision == 0 && build == 0;
        }

        ver.ObjType = function() { return obj_type; }

        var to_version = function(v)
        {
            if(!v.ObjType || v.ObjType() != obj_type)
                v = ns.Version(v, delim);
            return v;
        }

        ver.gt = function(v)
        {
            if(!v)
                return !ver.IsNull();

            v = to_version(v);

            var v1 = ver.Array();

            if(v.Array)
                var v2 = v.Array();
            else
                var v2 = [v.Major(), v.Minor(), v.Revision(), v.Build()];

            for(var i = 0; i < v1.length && i < v2.length; i++)
                if(v1[i] > v2[i])
                    return true;
                else if(v1[i] < v2[i])
                    return false;

            return false;
        }

        ver.eq = function(v)
        {
            if(!v)
                return ver.IsNull();

            v = to_version(v);

            var v1 = ver.Array();

            if(v.Array)
                var v2 = v.Array();
            else
                var v2 = [v.Major(), v.Minor(), v.Revision(), v.Build()];

            for(var i = 0; i < v1.length && i < v2.length; i++)
                if(v1[i] != v2[i])
                    return false;

            return true;
        }

        ver.ge = function(v)
        {
            return ver.gt(v) || ver.eq(v);
        }

        ver.lt = function(v)
        {
            return !ver.eq(v) && !ver.gt(v);
        }

        ver.le = function(v)
        {
            return ver.lt(v) || ver.eq(v);
        }

        ver.Format = function(concat)
        {
            if(!concat)
                concat = ".";

            return major.toString() + concat + minor.toString() + concat + revision.toString() + concat + build.toString();
        }

        if(iver instanceof Array)
            var version_string = ver.Format();

        return ver;
    }
}


