/*
Visual Studio processing.

function GetVSInfo returns object where key is VS identification:
    vs_2002, vs_2003, vs_2005, vs_2008, vs_2010, vs_2012

value is object with attributes (on example for vs_2008 object):

    vs_2008.id = "vs_2008"; // example
    vs_2008.name = "Microsoft Visual Studio* 2008 software"; // example
    vs_2008.dir = product directory
    vs_2008.devenv = devenv executable path
    vs_2008.sh_dir = shell directory
    vs_2008.sp = service pack identifier
    vs_2008.dexplore = dexplore, boolean
    vs_2008.csharp = CSharp, boolean
    vs_2008.vb = VB, boolean
    vs_2008.cpp = CPP, boolean
    vs_2008.vb_expr = VB Express, boolean
    vs_2008.cpp_expr = CPP Express, boolean
    vs_2008.csharp_expr = CSharp Express, boolean
    vs_2008.vwd_expr = VWD Express ???, bolean
    vs_2008.Running - function(), returns true if corresponding devenv.exe process is running
*/

new function()
{
    var is_running = function(image)
    {
        if(!image)
            return false;

        if(!FileSystem.Exists(image))
            return false;

        var p_list = System.ProcessList();

        for(var i in p_list)
        {
            var proc = p_list[i];
            if(FileSystem.Exists(proc) && FileSystem.Same(proc, image))
                return true;
        }
        return false;
    }

    var vs_2002 = {};
    vs_2002.id = "vs_2002";
    vs_2002.name = "Microsoft Visual Studio* 2002 software";
    vs_2002.data = {};
    vs_2002.data.dir = {key:"SOFTWARE\\Microsoft\\VisualStudio\\7.0\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2002.data.devenv = {key:"SOFTWARE\\Microsoft\\VisualStudio\\7.0\\Setup\\VS", value:"EnvironmentPath", type:"file"};
    vs_2002.Running = function(){return is_running(vs_2002.devenv);}

    var vs_2003 = {};
    vs_2003.id = "vs_2003";
    vs_2003.name = "Microsoft Visual Studio* 2003 software"
    vs_2003.data = {};
    vs_2003.data.dir = {key:"SOFTWARE\\Microsoft\\VisualStudio\\7.1\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2003.data.devenv = {key:"SOFTWARE\\Microsoft\\VisualStudio\\7.1\\Setup\\VS", value:"EnvironmentPath", type:"file"};
    vs_2003.Running = function(){return is_running(vs_2003.devenv);}

    var vs_2005 = {};
    vs_2005.id = "vs_2005";
    vs_2005.name = "Microsoft Visual Studio* 2005 software"
    vs_2005.data = {};
    vs_2005.data.dir = {key:"SOFTWARE\\Microsoft\\VisualStudio\\8.0\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2005.data.devenv = {key:"SOFTWARE\\Microsoft\\VisualStudio\\8.0\\Setup\\VS", value:"EnvironmentPath", type:"file"};
    vs_2005.data.sp = {key:"SOFTWARE\\Microsoft\\DevDiv\\VS\\Servicing\\8.0", value:"SP", type:"value"};
    vs_2005.data.ppe_dir = {key:"SOFTWARE\\Microsoft\\VisualStudio\\8.0\\Setup\\VS\\IDE", value:"ProductDir", type:"directory"};
    vs_2005.data.csharp = {key:"SOFTWARE\\Microsoft\\VisualStudio\\8.0\\Projects\\{FAE04EC0-301F-11D3-BF4B-00C04F79EFBC}", value:"DefaultProjectExtension", type:"boolean"};
    vs_2005.data.vb = {key:"SOFTWARE\\Microsoft\\VisualStudio\\8.0\\Projects\\{F184B08F-C81C-45f6-A57F-5ABD9991F28F}", value:"DefaultProjectExtension", type:"boolean"};
    vs_2005.data.cpp = {key:"SOFTWARE\\Microsoft\\VisualStudio\\8.0\\Projects\\{8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942}", value:"DefaultProjectExtension", type:"boolean"};
    vs_2005.data.dexplore = {key:"Software\\Microsoft\\DExplore\\v2.0.50727\\1033", value:"Install", type:"boolean"};
    vs_2005.data.vb_expr = {key:"Software\\Microsoft\\VBExpress\\8.0\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2005.data.cpp_expr = {key:"Software\\Microsoft\\VCExpress\\8.0\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2005.data.csharp_expr = {key:"Software\\Microsoft\\VCSExpress\\8.0\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2005.data.vwd_expr = {key:"Software\\Microsoft\\VWDExpress\\8.0\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2005.data.vjsh_expr = {key:"Software\\Microsoft\\VJSExpress\\8.0\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2005.Running = function(){return is_running(vs_2005.devenv);}

    var vs_2008 = {};
    vs_2008.id = "vs_2008";
    vs_2008.name = "Microsoft Visual Studio* 2008 software"
    vs_2008.data = {};
    vs_2008.data.dir = {key:"SOFTWARE\\Microsoft\\VisualStudio\\9.0\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2008.data.devenv = {key:"SOFTWARE\\Microsoft\\VisualStudio\\9.0\\Setup\\VS", value:"EnvironmentPath", type:"file"};
    vs_2008.data.sh_dir = {key:"SOFTWARE\\Microsoft\\VisualStudio\\9.0\\Setup\\VS\\IDE", value:"ProductDir", type:"directory"};
    vs_2008.data.sp = {key:"SOFTWARE\\Microsoft\\DevDiv\\VS\\Servicing\\9.0", value:"SP", type:"value"};
    vs_2008.data.dexplore = {key:"Software\\Microsoft\\DExplore\\v9.0.21022\\1033", value:"Install", type:"boolean"};
    vs_2008.data.csharp = {key:"SOFTWARE\\Microsoft\\VisualStudio\\9.0\\Projects\\{FAE04EC0-301F-11D3-BF4B-00C04F79EFBC}", value:"DefaultProjectExtension", type:"boolean"};
    vs_2008.data.vb = {key:"SOFTWARE\\Microsoft\\VisualStudio\\9.0\\Projects\\{F184B08F-C81C-45f6-A57F-5ABD9991F28F}", value:"DefaultProjectExtension", type:"boolean"};
    vs_2008.data.cpp = {key:"SOFTWARE\\Microsoft\\VisualStudio\\9.0\\Projects\\{8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942}", value:"DefaultProjectExtension", type:"boolean"};
    vs_2008.data.vb_expr = {key:"Software\\Microsoft\\VBExpress\\9.0\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2008.data.cpp_expr = {key:"Software\\Microsoft\\VCExpress\\9.0\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2008.data.csharp_expr = {key:"Software\\Microsoft\\VCSExpress\\9.0\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2008.data.vwd_expr = {key:"Software\\Microsoft\\VWDExpress\\9.0\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2008.Running = function(){return is_running(vs_2008.devenv);}

    var vs_2010 = {};
    vs_2010.id = "vs_2010";
    vs_2010.name = "Microsoft Visual Studio* 2010 software"
    vs_2010.data = {};
    vs_2010.data.dir = {key:"SOFTWARE\\Microsoft\\VisualStudio\\10.0\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2010.data.devenv = {key:"SOFTWARE\\Microsoft\\VisualStudio\\10.0\\Setup\\VS", value:"EnvironmentPath", type:"file"};
    vs_2010.data.csharp = {key:"SOFTWARE\\Microsoft\\VisualStudio\\10.0\\Projects\\{FAE04EC0-301F-11D3-BF4B-00C04F79EFBC}", value:"DefaultProjectExtension", type:"boolean"};
    vs_2010.data.vb = {key:"SOFTWARE\\Microsoft\\VisualStudio\\10.0\\Projects\\{F184B08F-C81C-45f6-A57F-5ABD9991F28F}", value:"DefaultProjectExtension", type:"value"};
    vs_2010.data.cpp = {key:"SOFTWARE\\Microsoft\\VisualStudio\\10.0\\Projects\\{8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942}", value:"DefaultProjectExtension", type:"value"};
    vs_2010.data.cpp_expr = {key:"Software\\Microsoft\\VCExpress\\10.0\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2010.data.shell = {key:"SOFTWARE\\Microsoft\\VisualStudio\\10.0\\Setup\\IntShell", value:"ProductDir", type:"subkey_dir"};
    vs_2010.Running = function(){return is_running(vs_2010.devenv);}

    var vs_2012 = {};
    vs_2012.id = "vs_2012";
    vs_2012.name = "Microsoft Visual Studio* 2012 software"
    vs_2012.data = {};
    vs_2012.data.dir = {key:"SOFTWARE\\Microsoft\\VisualStudio\\11.0\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2012.data.devenv = {key:"SOFTWARE\\Microsoft\\VisualStudio\\11.0\\Setup\\VS", value:"EnvironmentPath", type:"file"};
    vs_2012.data.csharp = {key:"SOFTWARE\\Microsoft\\VisualStudio\\11.0\\Projects\\{FAE04EC0-301F-11D3-BF4B-00C04F79EFBC}", value:"DefaultProjectExtension", type:"boolean"};
    vs_2012.data.vb = {key:"SOFTWARE\\Microsoft\\VisualStudio\\11.0\\Projects\\{F184B08F-C81C-45f6-A57F-5ABD9991F28F}", value:"DefaultProjectExtension", type:"value"};
    vs_2012.data.cpp = {key:"SOFTWARE\\Microsoft\\VisualStudio\\11.0\\Projects\\{8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942}", value:"DefaultProjectExtension", type:"value"};
    vs_2012.data.cpp_expr = {key:"Software\\Microsoft\\VCExpress\\11.0\\Setup\\VS", value:"ProductDir", type:"directory"};
    vs_2012.data.shell = {key:"SOFTWARE\\Microsoft\\VisualStudio\\11.0\\Setup\\IntShell", value:"ProductDir", type:"subkey_dir"};
    vs_2012.Running = function(){return is_running(vs_2012.devenv);}

    var find = function(array, val)
    {
        for(var i in array)
            if(array[i] == val)
                return true;
        return false;
    }

    var studios = {vs_2002:vs_2002, vs_2003:vs_2003, vs_2005:vs_2005, vs_2008:vs_2008, vs_2010:vs_2010, vs_2012:vs_2012};

    for(var i in studios)
    {
        var iter = studios[i];

        Log("Processing: " + iter.id + ": " + iter.name);

        var data = iter.data;

        for(var k in data)
        {
            Log("  item: " + k);
            var r = data[k];
            if(r.key && r.type)
            {
                Log("    key: " + r.key + "; value: " + r.value + "; type: " + r.type);
                var reg = Registry("HKLM", r.key);

                var found;
                found = false;

                if(reg.Exists())
                {
                    var val;

                    if(r.value && r.type != "subkey_dir" && find(reg.Values(), r.value))
                    {
                        val = reg.Value(r.value);
                        Log("    value detected: " + val);

                        switch(r.type)
                        {
                        case "directory":
                            if(FileSystem.Exists(val))
                            {
                                if(FileSystem.IsDirectory(val))
                                {
                                    iter[k] = val;
                                    found = true;
                                }
                                else
                                    Log("    Target path is not directory");
                            }
                            else
                                Log("    Directory doesn't exist");
                            break;
                        case "boolean":
                            iter[k] = true;
                            found = true;
                            break;
                        case "file":
                            if(FileSystem.Exists(val))
                            {
                                if(!FileSystem.IsDirectory(val))
                                {
                                    iter[k] = val;
                                    found = true;
                                }
                                else
                                    Log("    Target path is directory");
                            }
                            else
                                Log("    File doesn't exist");
                            break;
                        case "value":
                            iter[k] = val;
                            found = true;
                            break;
                        }
                    }
                    else if(r.type == "subkey_dir")
                    {
                        var subkeys = reg.Subkeys();
                        for(var sub_name in subkeys)
                        {
                            var s_name = subkeys[sub_name];
                            Log("    look at subkey: " + s_name);
                            var sub_reg = reg.Key(s_name);
                            if(find(sub_reg.Values(), r.value))
                            {
                                var val = sub_reg.Value(r.value);
                                Log("      found value: " + val);

                                if(FileSystem.Exists(val))
                                {
                                    if(FileSystem.IsDirectory(val))
                                    {
                                        iter[k] = val;
                                        found = true;
                                        break;
                                    }
                                    else
                                        Log("      Target path is not directory");
                                }
                                else
                                    Log("      Directory doesn't exist");
                            }
                        }
                    }
                }
                else
                {
                    Log("    registry key doesn't exist");

                    if(!found)
                    {
                        switch(r.type)
                        {
                        case "directory":
                        case "file":
                        case "value":
                        case "subkey_dir":
                            delete iter[k];
                            break;
                        case "boolean":
                            iter[k] = false;
                            break;
                        }
                    }
                }
            }
        }
    }

    this.GetVSInfo = function() {return studios;}
}


