new function()
{
    var format = StringList.Format;

    this.Init = function()
    {
        var ns = this;

        //###############################################################
        // Welcome
        //###############################################################
        var welcome_template = "[welcome_template]";

        this.Welcome = function()
        {
            ns.DialogHeader("Welcome");
            ns.Buttons("[Next]", "[Prev]", "[Cancel]");
            Wizard.Next.Enable();
            Wizard.Prev.Disable();
            Wizard.Cancel.Enable();
            ns.Stage("widi.png");
            Wizard.Notify("welcome", "set rtf text", welcome_template);
            var r = Action.Dialog({name:"Welcome", mode:"sync"});
            Wizard.Prev.Enable();
            return r;
        }

        this.Welcome.Template = function(text)
        {
            if(text)
                welcome_template = text;
            else
                welcome_template = "[welcome_template]";
        }

        //###############################################################
        // Maintenance
        //###############################################################
        var maintenance_enable_prev = true;

        var maintenance_mode_changed_cb;

        Wizard.Notify("maintenance/modify", "check btn"); // update status only once

        this.Maintenance = function()
        {
            ns.DialogHeader("Maintenance");
            ns.Buttons("[Next]", "[Prev]", "[Cancel]");
            if(!maintenance_enable_prev)
                Wizard.Prev.Disable();
            else
                Wizard.Prev.Enable();

            Wizard.Next.Enable();
            Wizard.Cancel.Enable();

            ns.Stage("widi.png");
            var r = Action.Dialog({name:"Maintenance", mode:"sync"});
            if(!maintenance_enable_prev)
                Wizard.Prev.Enable();
            return r;
        }

        this.Maintenance.OnModeChange = function(cb) {maintenance_mode_changed_cb = cb;}

        this.Maintenance.EnablePrev = function(enable)
        {
            maintenance_enable_prev = enable;
        }

        this.Maintenance.EnableModify = function(en) {Wizard.Notify("maintenance/modify", en ? "enable" : "disable");}
        this.Maintenance.EnableRepair = function(en) {Wizard.Notify("maintenance/repair", en ? "enable" : "disable");}
        this.Maintenance.EnableRemove = function(en) {Wizard.Notify("maintenance/remove", en ? "enable" : "disable");}

        var maintenance_mode_cb = function(mode)
        {
            if(maintenance_mode_changed_cb)
                safecall(function(){maintenance_mode_changed_cb(mode);},
                         function(){Log(Log.l_error, "Maintenance mode changed callback exception handled.");});
        }

        this.Maintenance.Select = function(opt)
        {
            Wizard.Notify("maintenance/modify", "set checked", false);
            Wizard.Notify("maintenance/repair", "set checked", false);
            Wizard.Notify("maintenance/remove", "set checked", false);
            switch(opt)
            {
            case "modify":
                Wizard.Notify("maintenance/modify", "set checked", true);
                maintenance_mode_cb(ns.Installer().install_mode_t.modify);
                break;
            case "repair":
                Wizard.Notify("maintenance/repair", "set checked", true);
                maintenance_mode_cb(ns.Installer().install_mode_t.repair);
                break;
            default: //case "remove":
                Wizard.Notify("maintenance/remove", "set checked", true);
                maintenance_mode_cb(ns.Installer().install_mode_t.remove);
                break;
            }
        }

        var MaintenanceTypeChanged = function(id, notify, value)
        {
            if(id != "maintenance" || notify != "maintenance type changed")
                return;

            switch(value)
            {
                case "NTF_MODIFY":
                    ns.Installer().InstallMode(ns.Installer().install_mode_t.modify);
                    maintenance_mode_cb(ns.Installer().install_mode_t.modify);
                    break;
                case "NTF_REPAIR":
                    ns.Installer().InstallMode(ns.Installer().install_mode_t.repair);
                    maintenance_mode_cb(ns.Installer().install_mode_t.repair);
                    break;
                case "NTF_REMOVE":
                    ns.Installer().InstallMode(ns.Installer().install_mode_t.remove);
                    maintenance_mode_cb(ns.Installer().install_mode_t.remove);
                    break;
                default:
                    Log("Maintenance mode: unknown mode: " + value);
                    break;
            }
        }

        Wizard.Subscribe("maintenance", "maintenance type changed", MaintenanceTypeChanged);
        //###############################################################
        // Setuptype
        //###############################################################
        this.Setuptype = function()
        {
            ns.DialogHeader("SetupType");
            ns.Buttons("[Next]", "[Prev]", "[Cancel]");
            ns.Stage("widi.png");
            Wizard.Next.Enable();
            Wizard.Prev.Enable();
            Wizard.Cancel.Enable();

            if(ns.Installer().SetupType() == ns.Installer().setup_type_t.setup_default)
                Wizard.Notify("setuptype/default", "check btn");
            else
                Wizard.Notify("setuptype/custom", "check btn");

            var r = Action.Dialog({name:"Setuptype", mode:"sync"});
            return r;
        }

        var SetuptypeChanged = function (id, notify, value)
        {
            if(id != "setuptype" || notify != "setuptype_was_changed")
                return;

            switch(value)
            {
                case "NTF_DEFAULT":
                    ns.Installer().SetupType(ns.Installer().setup_type_t.setup_default);
                    break;
                case "NTF_CUSTOM":
                    ns.Installer().SetupType(ns.Installer().setup_type_t.setup_custom);
                    break;
            }
        }

        Wizard.Subscribe("setuptype", "setuptype_was_changed", SetuptypeChanged);
        //###############################################################
        // EULA
        //###############################################################
        var eula_accept_reject = function(control, action)
        {
            if(action == "OnClicked")
            {
                if(control == "eula/accept")
                    Wizard.Next.Enable();
                else if(control == "eula/reject")
                    Wizard.Next.Disable();
            }
        }

        this.Eula = function()
        {
            ns.DialogHeader("Eula");
            ns.Buttons("[Next]", "[Prev]", "[Cancel]");
            ns.Stage("widi.png");
            Wizard.Next.Enable();
            Wizard.Prev.Enable();
            Wizard.Cancel.Enable();

            return Action.Dialog({name:"EULA", mode:"sync"});
        }

        this.EulaMultiple = function()
        {
            ns.DialogHeader("Eula");
            ns.Buttons("[Next]", "[Prev]", "[Cancel]");
            ns.Stage("widi.png");
            Wizard.Next.Enable();
            Wizard.Prev.Enable();
            Wizard.Cancel.Enable();

            return Action.Dialog({name:"EULA-multiple", mode:"sync"});
        }

        this.Eula.File = function(file_path)
        {
            if(file_path)
                Wizard.Notify("eula", "set rtf text", FileSystem.ReadFileUTF8(file_path));
        }

        this.Eula.File(FileSystem.MakePath("../eula.rtf", Origin.Directory()));

        this.Eula.CustomHandler = function(cb)
        {
            if(cb)
            {
                Wizard.Subscribe("eula/accept", "OnClicked", cb);
                Wizard.Subscribe("eula/reject", "OnClicked", cb);
            }
            else
            {
                Wizard.Subscribe("eula/accept", "OnClicked", eula_accept_reject);
                Wizard.Subscribe("eula/reject", "OnClicked", eula_accept_reject);
            }
        }

        Wizard.Subscribe("eula", "OnClicked", function(c, m, url){Execute.URL(url);});
        Wizard.Subscribe("eula/multiple", "OnClicked", function(c, m, url){Execute.URL(url);});
        this.Eula.CustomHandler();
        this.EulaMultiple.OnClicked = function(cb)
        {
            Wizard.Subscribe("eula/multiple/liclist", "OnClicked", function(id, command, value) {cb(value);});
        }
        this.EulaMultiple.Add = function(text) {Wizard.Notify("eula/multiple/liclist", "add", text);}
        this.EulaMultiple.Clear = function() {Wizard.Notify("eula/multiple/liclist", "clear");}
        this.EulaMultiple.Comps = function(text) {Wizard.Notify("eula/multiple/complist", "set text", text);}
        this.EulaMultiple.Text = function(text) {Wizard.Notify("eula/multiple", "set rtf text", text);}

        //###############################################################
        // Destination
        //###############################################################
        var destination_space_required = null;
        var destination_current_value = "";

        var update_space_info = function()
        {
            var invalid_path = function(reason)
            {
                Log("Failed path processing: " + reason);
                var required = destination_space_required ? destination_space_required() : 0;
                Wizard.Notify("destination/space", "set rtf text", format("[space_incorrect_path_file]", required));
                Wizard.Next.Disable();
            }
            Log("incoming path: " + destination_current_value);

            var path = destination_current_value;
            if(!path || path.length < 3 || !FileSystem.IsAbsolute(path))
            {
                invalid_path("Not absolute");
                return false;
            }

            if(path.match(/[<>?*|]/))
            {
                invalid_path("Incorrect symbols");
                return false;
            }

            if(FileSystem.IsNetwork() && path.match(/[:]/))
            {
                invalid_path("Network path contains ':'");
                return false;
            }

            if(path.split(":").length > 2)
            {
                invalid_path("More that one ':'");
                return false;
            }

            if(FileSystem.IsNetwork(path))
                Wizard.Notify("destination/space", "set rtf text", format("[space_unknown_file]", destination_space_required(), "[unknown]"));
            else
            {
                var avail = FileSystem.FreeSpace(path);
                if(!avail)
                {
                    invalid_path("Can't detect free space for target path");
                    return false;
                }
                var required = destination_space_required ? destination_space_required() : 0;
                if(required > avail)
                {
                    Wizard.Notify("destination/space", "set rtf text", format("[space_failed_file]", required, avail));
                    Wizard.Next.Disable();
                    return false;
                }
                else
                    Wizard.Notify("destination/space", "set rtf text", format("[space_required_file]", required, avail));
            }

            Wizard.Next.Enable();
            return true;
        }

        this.Destination = function()
        {
            ns.DialogHeader("Destination");
            ns.Buttons("[Next]", "[Prev]", "[Cancel]");
            Wizard.Next.Enable();
            Wizard.Prev.Enable();
            Wizard.Cancel.Enable();

            ns.Stage("widi.png");

            update_space_info();
            if(ns.Destination.Refresh)
                ns.Destination.Refresh();
            return Action.Dialog({name:"Destination", mode:"sync"});
        }

        this.Destination.Set = function( folder_path )
        {
            Wizard.Notify("destination/edit_box","set text", folder_path);
            destination_current_value = folder_path;
            update_space_info();
        }

        this.Destination.SetInfo = function( mes )
        {
            Wizard.Notify("destination/info","set text", mes);
        }

        this.Destination.Disable = function( )
        {
            Wizard.Notify("destination/edit_box","disable");
        }

        this.Destination.Enable = function( )
        {
            Wizard.Notify("destination/edit_box","enable");
        }

        this.Destination.SpaceRequired = function(cb)
        {
            destination_space_required = cb;
            update_space_info();
        }

        var ChangeProcessor = function (id, notify, value)
        {
            if(id != "destination" || notify != "destination_changed")
                return;

            destination_current_value = value;
            if(update_space_info())
                if(ns.Destination.OnChange)
                    ns.Destination.OnChange(destination_current_value);
        }

        Wizard.Subscribe("destination", "destination_changed", ChangeProcessor);
        Wizard.Notify("destination/edit_box", "set text limit", 260);
        //###############################################################
        // ComponentSelection
        //###############################################################
        
        var prod_hooked = false;
        var processing = false;

        var allow_continue_cb = function() {return true;}

        var on_action_change = function()
        {
            if(processing)
            {
                if(allow_continue_cb)
                {
                    if(allow_continue_cb())
                        Wizard.Next.Enable();
                    else
                        Wizard.Next.Disable();
                }
                else
                    Wizard.Next.Enable();
            }
        }
        
        var create_filter = function()
        {
            var features;

            return function(control, command, value)
            {
                var foreach = function(collection, func)
                {
                    for(var i in collection)
                        if(func(collection[i], i))
                            return true;
                    return false;
                }

                if(ns.Product())
                {
                    if(!features)
                    {
                        features = {};
                        foreach(ns.Product().FeaturesFullSet(), function(f)
                        {
                            var node = f.GetNode();
                            features[f.Id()] = {node:node, feature:f, expanded:node.expanded, visible:node.visible};
                            return false;
                        });
                    }

                    if(command == "OnChanged")
                    {
                        var filter = value.replace(/^\s+/, "").replace(/\s+$/, "");

                        if(filter)
                        { // setting filter
                            var regexp = RegExp(filter, "i");
                            foreach(features, function(f)
                            { // find matched features
                                if(f.feature.Name().match(regexp) || f.feature.Description().match(regexp) ||
                                foreach(f.feature.Components(), function(c) {if(c.Name().match(regexp)) return true; return false;}))
                                {
                                    Log("Feature matched: " + f.feature.Name());
                                    f.matched = true;
                                }
                                else
                                    f.matched = false;
                                return false;
                            });

                            foreach(features, function(f)
                            { // mark matched features as visible & expanded
                                if(f.matched || foreach(f.feature.FeaturesFullSet(), function(f, key)
                                {
                                    if(features[key].matched)
                                        return true;
                                    return false;
                                }))
                                {
                                    Log("Feature marked as visible: " + f.feature.Name());
                                    f.node.visible = true;
                                    f.node.expanded = true;
                                }
                                else
                                    f.node.visible = false;
                                return false;
                            });
 
                            foreach(features, function(f)
                            { // mark child features as visible
                                if(f.matched)
                                {
                                    foreach(f.feature.FeaturesFullSet(), function(f, key)
                                    {
                                        if(features[f.Id()])
                                            features[f.Id()].node.visible = true;
                                        return false;
                                    });
                                }
                            });

                            foreach(features, function(f) {f.node.Refresh(); return false;});
                        }
                        else
                        { // clearing filter
                            foreach(features, function(f)
                            {
                                f.node.visible = f.visible;
                                f.node.expanded = f.expanded;
                                return false;
                            });
                            foreach(features, function(f) {f.node.Refresh(); return false;});
                        }
                    }
                }
            }
        }

        Wizard.Subscribe("feature/filter", "OnChanged", create_filter());

        var feature_tree_generator = function(name)
        {
            var f = function()
            {
                processing = true;

                if(!prod_hooked && ns.Product())
                {
                    prod_hooked = true;
                    var p = ns.Product();
                    p.Action.Subscribe(on_action_change);
                }

                ns.DialogHeader("Features");
                ns.Buttons("[Next]", "[Prev]", "[Cancel]");
                ns.Stage("widi.png");
                Wizard.Next.Enable();
                Wizard.Prev.Enable();
                Wizard.Cancel.Enable();
                on_action_change();
                var res = Action.Dialog({name:name, mode:"sync"});
                processing = false;
                return res;
            }

            f.AllowContinue = function(cb)
            {
                if(cb)
                    allow_continue_cb = cb;
                else
                    allow_continue_cb = function() {return true;}
            }

            return f;
        }

        this.Features = feature_tree_generator("FeatureTree");
        this.FeaturesFilter = feature_tree_generator("FeatureTreeFilter");
        this.FeaturesSplash = feature_tree_generator("FeatureTreeSplash");
        //###############################################################
        // Progress
        //###############################################################
        var installation_dlg_name = "";

        var inst_files_in_use = function(id, command, value)
        {
            Log("Files in use notification");
            var header = "[alert_img] " + value[0];

            var message = "";

            for(var i = 1; i < value.length; i += 2)
                if(value[i].length)
                {
                    Log("  Message: " + value[i]);

                    var m = value[i];
                    // Program Compatibility Assistant
                    if(m.match(/widiapp/i))
                        m = "[widi_app_to_close]";

                    message += "- " + m + "\\par ";
                }

            var text = StringList.Format("[files_in_use_template]", header, message);

            ns.Buttons("[Retry]", "[Prev]", "[Cancel]");

            var n_e = Wizard.Next.Enable();
            var p_e = Wizard.Prev.Disable();
            var c_e = Wizard.Cancel.Enable();

            Wizard.Notify("prerequisite_text", "set rtf text", text);
            var r = Action.Dialog({name:"Pre_requisite", mode:"sync"});

            ns.Buttons("[Next]", "[Prev]", "[Cancel]");

            if(n_e)
                Wizard.Next.Enable();
            else
                Wizard.Next.Disable();

            if(p_e)
                Wizard.Prev.Enable();
            else
                Wizard.Prev.Disable();

            if(c_e)
                Wizard.Cancel.Enable();
            else
                Wizard.Cancel.Disable();

            var ret = "cancel";

            switch(r)
            {
            case Action.r_ok:
                ret = "retry";
                break;
            case Action.r_back:
                ret = "ignore";
                break;
            case Action.r_cancel:
                ret = "cancel";
                break;
            }
            Action.Dialog({name:installation_dlg_name, mode:"async"}); // restore progress dialog
            return ret;
        }

        this.Installation = function(prg_num)
        {
            if(!prg_num)
                prg_num = 1;

            ns.DialogHeader("Installation");
            ns.Buttons("[install_updates]", "[Prev]", "[close]");
            ns.Stage("widi.png");
            Wizard.Next.Disable();
            Wizard.Prev.Disable();
            Wizard.Cancel.Enable();

            installation_dlg_name = "Progress" + prg_num;

            Wizard.Subscribe("installation", "files in use", inst_files_in_use);

            return Action.Dialog({name:installation_dlg_name, mode:"async"});
        };

        this.Installation.AssignProgress = function( dmpr, prg_num )
        {
            if(!prg_num)
                prg_num = 1;

            if(dmpr && dmpr.Progress)
                Wizard.Notify("Progress" + prg_num, "connect", dmpr.Progress().id);
            else
                return false;

            var inst = this;

            dmpr.PrgHeader = function(mes)
            {
                inst.AssignHeader(mes, prg_num);
            }

            dmpr.PrgTitle = function(mes)
            {
                inst.AssignTitle(mes, prg_num);
            }

            return false;
        };

        this.Installation.AssignHeader = function( mes, prg_num )
        {
            if(!prg_num)
                prg_num = 1;

            Log("Assing header with mes = " + mes);
            Wizard.Notify("Progress" + prg_num, "header", mes);
            return false;
        };

        this.Installation.AssignTitle = function( mes, prg_num )
        {
            if(!prg_num)
                prg_num = 1;

            Log("Assing title with mes = " + mes);
            Wizard.Notify("Progress" + prg_num, "title", mes);
            return false;
        };
        //###############################################################    

        //###############################################################
        // VS Integration
        //###############################################################
        var vs_integration_data;

        var vs_integration_callback = function(control, command, id)
        {
            Log("Item " + id + " " + command);

            for(var i in vs_integration_data)
            {
                if(vs_integration_data[i].id == id)
                {
                    if(command == "selected")
                        vs_integration_data[i].selected = true; // save states for every id
                    else
                        vs_integration_data[i].selected = false;
                }
            }
        }

        Wizard.Subscribe("vs_integration", "selected", vs_integration_callback);
        Wizard.Subscribe("vs_integration", "unselected", vs_integration_callback);

        this.VSIntegration = function()
        {
            ns.DialogHeader("VSIntegration");
            ns.Buttons("[Next]", "[Prev]", "[Cancel]");
            Wizard.Next.Enable();
            Wizard.Prev.Enable();
            Wizard.Cancel.Enable();
            ns.Stage("widi.png");
            return Action.Dialog({name:"vs_integration", mode:"sync"});
        }

        this.VSIntegration.Data = function(data)
        {
            Log(" @@@@@@ Setting VS integration data");
            for(var k in data)
            {
                Log(" title = " + data[k].title);
            }

            vs_integration_data = data;
            VSIntegrationData(data);
        }

        this.VSIntegration.GetState = function()
        {
            return vs_integration_state;
        }
        //###############################################################

        //###### PreRequisites dialog API ###############################
        var prereq_template = "[prereq_template]";

        var prereq_fatal    = [];
        var prereq_critical = [];
        var prereq_warning  = [];
        var prereq_info     = [];

        var prereq_custom_checker = null;

        var prereq_check = function()
        {
            prereq_fatal    = [];
            prereq_critical = [];
            prereq_warning  = [];
            prereq_info     = [];

            if(prereq_custom_checker)
            {
                return prereq_custom_checker() || prereq_fatal.length || prereq_critical.length || prereq_warning.length;
            }
            else
                return true;
        }

        this.PreRequisites = function()
        {
            ns.DialogHeader("PreRequisites");
            ns.Stage("widi.png");
            do
            {
                if(prereq_fatal.length)
                {
                    var message = "";
                    for(var i in prereq_fatal)
                        message += prereq_fatal[i];
                }
                else
                {
                    var message = "";
                    for(var i in prereq_critical)
                        message += prereq_critical[i];
                    for(var i in prereq_warning)
                        message += prereq_warning[i];
                    for(var i in prereq_info)
                        message += prereq_info[i];
                }

                var txt = StringList.Format(prereq_template, message);
                Log("Pre-req message: " + txt);
                Wizard.Notify("prerequisite_text", "set rtf text", txt);

                if(prereq_fatal.length)
                {
                    Wizard.Notify("title", "no-cancel-confirm"); 
                    Log("disabling next due to fatal pre-requisite");
                    ns.buttons("[Finish]", "[Prev]", "[Cancel]");
                    ns.Stage("widi.png");
                    Wizard.Next.Enable();
                    Wizard.Prev.Disable();
                    Wizard.Cancel.Disable();
                }
                else
                {
                    Wizard.Next.Enable();
                    Wizard.Prev.Enable();
                    Wizard.Cancel.Enable();

                    if(prereq_critical.length)
                        ns.buttons("[Retry]", "[Prev]", "[Cancel]");
                    else
                        ns.buttons("[Next]", "[Prev]", "[Cancel]");
                    //Wizard.Next.Enable();
                }

                var result = Action.Dialog({name:"Pre_requisite", mode:"sync"});
                Log("Pre_requisite result = " + result);

                if(prereq_fatal.length)
                    return Action.r_abort;

                switch(result)
                {
                case Action.r_ok:
                    prereq_check();
                    break;
                default:
                    Wizard.Next.Enable();
                    return result;
                }
            } while(prereq_fatal.length || prereq_critical.length)

            return Action.r_ok;
        }

        this.PreRequisites.Skip = function()
        {
            Log("check for pre-requisites");

            var ch = prereq_check();
            if(!ch)
                Log(" no prerequisites detected");
            return !ch;
        }

        this.PreRequisites.File = function(file)
        {
            var path = FileSystem.MakePath(file, Origin.Directory());
            if(FileSystem.Exists(path))
            {
                prereq_template = FileSystem.ReadFileUTF8(path);
            }
            else
                Log(Log.l_error, "failed to load file: " + path + " (no prereq template available)");
        }

        this.PreRequisites.Template = function(tmpl)
        {
            prereq_template = tmpl;
        }

        this.PreRequisites.Fatal    = function(msg) {prereq_fatal.push(StringList.Format("{{\\pntext\\f1 [image_error] } \\cf1 [%s]}\\par", msg));}
        this.PreRequisites.Critical = function(msg) {prereq_critical.push(StringList.Format("{{\\pntext\\f1 [image_error] } \\cf1 [%s]}\\par", msg));}
        this.PreRequisites.Warning  = function(msg) {prereq_warning.push(StringList.Format("{{\\pntext\\f1 [image_warning] }[%s]}\\par", msg));}
        this.PreRequisites.Info     = function(msg) {prereq_info.push(StringList.Format("{{\\pntext\\f1 [image_info] } [%s]}\\par", msg));}

        this.PreRequisites.Callback = function(cb) {prereq_custom_checker = cb;}

        //###############################################################
        // Finish
        //###############################################################

        var error_reason = function()
        {
            var errs = GlobalErrors.List();
            if(errs && errs.length)
            {
                var txt = "";
                for(var i in errs)
                {
                    var e = (txt.length ? "\\par" : "") + StringList.Format("{\\cf1 [%s]}", errs[i]);
                    txt += e;
                }

                return txt;
            }

            return null;
        }

        var finish_template = "[finish_template]";
        var finish_notes = "";
        var finish_cb = function() {}
        this.Complete = function()
        {
            ns.DialogHeader("Complete");
            ns.Buttons("[Finish]", "[Prev]", "[Cancel]");
            ns.Stage("widi.png");

            var errs = error_reason();
            if(errs)
                finish_notes = finish_notes + "\\par Errors: \\par" + errs;

            Wizard.Notify("finish_text", "set rtf text", StringList.Format(finish_template, finish_notes));
            if(finish_cb)
                finish_cb();
            Wizard.Next.Enable();
            Wizard.Prev.Disable();
            Wizard.Cancel.Disable();

            return Action.Dialog({name:"Finish", mode:"sync"});
        }

        this.Complete.Template = function(tmpl)
        {
            if(tmpl)
                finish_template = tmpl;
            else
                finish_template = "[finish_template]";
        }

        this.Complete.Notes = function(notes)
        {
            finish_notes = notes;
        }

        this.Complete.OnShow = function(cb) {finish_cb = cb;}

        Wizard.Subscribe("finish_text", "OnClicked", function(c, m, url){Execute.URL(url);});

        //###############################################################
        // Cancel
        //###############################################################
        var cancel_template = "[cancel_template]";
        this.Cancel = function()
        {
            ns.Buttons("[Finish]", "[Prev]", "[Cancel]");
            ns.Header("[title]");
            ns.SubHeader("[subtitle_cancel]");
            Wizard.Next.Enable();
            Wizard.Prev.Disable();
            Wizard.Cancel.Disable();
            ns.Stage("widi.png");
            Wizard.Notify("finish_text", "set rtf text", cancel_template);
            Wizard.Notify("title", "no-cancel-confirm"); 
            Action.Dialog({name:"Finish", mode:"sync"});
            return Action.r_cancel;
        }
        this.Cancel.Template = function(tmpl)
        {
            if(tmpl)
                cancel_file = file_path;
            else
                cancel_template = "[cancel_template]";
        }

        //###############################################################
        // Error
        //###############################################################
        var error_template = "[error_template]";
        this.Error = function()
        {
            ns.Buttons("[Finish]", "[Prev]", "[Cancel]");
            ns.Header("[title]");
            ns.SubHeader("[subtitle_error]");
            Wizard.Next.Enable();
            Wizard.Prev.Disable();
            Wizard.Cancel.Disable();
            ns.Stage("widi.png");
            var c_msg = StringList.Format(error_template, error_reason());
            Wizard.Notify("finish_text", "set rtf text", c_msg);
            Wizard.Notify("title", "no-cancel-confirm"); 
            Action.Dialog({name:"Finish", mode:"sync"});
            return Action.r_error;
        }
        this.Error.Template = function(tmpl)
        {
            if(tmpl)
                error_template = tmpl;
            else
                error_template = "[error_template]";
        }

        //###############################################################
        ns.DialogHeader("Welcome", "[required_updates]");
        ns.DialogHeader("PreRequisites", "[subtitle_prereq]");
        ns.DialogHeader("Maintenance", "[subtitle_welcome]");
        ns.DialogHeader("Eula", "[title]", "[subtitle_eula]");
        ns.DialogHeader("Installation", "[subtitle_download]");
        ns.DialogHeader("Cancel", "[title]", "[subtitle_cancel]");
        ns.DialogHeader("Error", "[failed_to_install]");
        ns.DialogHeader("SetupType", "[title]", "[subtitle_setuptype]");
        ns.DialogHeader("VSIntegration", "[title]", "[subtitle_vsintegration]");
        ns.DialogHeader("Complete", "[subtitle_complete]");
        ns.DialogHeader("Destination", "[title]", "[subtitle_destination]");
        ns.DialogHeader("Features", "[title]", "[subtitle_features]");
    }
}



