new function()
{
    var load = function(name) {return required(FileSystem.MakePath("../" + name, Origin.Directory()));};
    var base = function(name) {return load("Base/" + name);};

    var format = StringList.Format;

    this.Init = function()
    {
        var ns = this;

        //###############################################################
        // Welcome
        //###############################################################
        var welcome_text = "";

        this.WiDiWelcome = function(failed)
        {
            if(!failed)
            {
                ns.DialogHeader("WiDiWelcome");
                ns.Buttons("[install_updates]", "[Prev]", "[close]");
                Wizard.Next.Enable();
                Wizard.Prev.Disable();
                Wizard.Cancel.Enable();
                ns.Stage("widi.png");
                ns.WiDiWelcome.Update();
                var r = Action.Dialog({ name: "Welcome", mode: "sync" });
                return r;
            }
            else
            {
                ns.DialogHeader("PreRequisites");
                Wizard.Notify("title", "no-cancel-confirm");
                Log("disabling next due to fatal pre-requisite");
                Wizard.Notify("cancel", "hide");
                ns.Buttons("[close]");
                ns.Stage("widi.png");
                Wizard.Next.Enable();
                Wizard.Prev.Disable();
                Wizard.Cancel.Enable();
                ns.WiDiWelcome.Update();
                Wizard.Notify("welcome/footer", "set rtf text", "");
                return Action.Dialog({name:"Welcome", mode:"sync"});
            }
        }

        this.WiDiWelcome.Text = function(text)
        {
            if(text)
                welcome_text = text;
            else
                welcome_text = "";
        }

        this.WiDiWelcome.Update = function()
        {
            Wizard.Notify("welcome", "set rtf text", StringList.Format("[widi_text_template]", welcome_text));
        }

        var error_text = "";
        var error_cb = function() {return false;}

        this.WiDiError = function(failed)
        {
            if(!failed || typeof(failed) == "function")
            {
                ns.DialogHeader("WiDiWelcome");
                ns.Buttons("[Retry]", "[Prev]", "[Cancel]");
                Wizard.Next.Enable();
                Wizard.Prev.Disable();
                Wizard.Cancel.Enable();
                ns.Stage("widi.png");

                if(typeof(failed) == "function")
                {
                    while(failed())
                    {
                        ns.WiDiError.Update();
                        Wizard.Notify("welcome/footer", "set rtf text", "");
                        var r = Action.Dialog({name:"Welcome", mode:"sync"});
                        switch(r)
                        {
                        case Action.r_ok:
                            continue;
                        default:
                            return r;
                        }
                    }
                    return Action.r_ok;
                }
                else
                {
                    Wizard.Notify("welcome/footer", "set rtf text", "");
                    return Action.Dialog({name:"Welcome", mode:"sync"});
                }
            }
            else
            {
                ns.DialogHeader("PreRequisites");
                Wizard.Notify("title", "no-cancel-confirm");
                Log("disabling next due to fatal pre-requisite");
                ns.buttons("[Next]", "[Prev]", "[Finish]");
                ns.Stage("widi.png");
                Wizard.Next.Disable();
                Wizard.Prev.Disable();
                Wizard.Cancel.Enable();
                ns.WiDiError.Update();
                Wizard.Notify("welcome/footer", "set rtf text", "");
                return Action.Dialog({name:"Welcome", mode:"sync"});
            }
        }

        this.WiDiError.Text = function(text)
        {
            if(text)
                error_text = text;
            else
                error_text = "";
        }

        this.WiDiError.Update = function()
        {
            Wizard.Notify("welcome", "set rtf text", StringList.Format("[widi_text_template]", error_text));
        }

        var error_reason = function()
        {
            var errs = GlobalErrors.List();
            if(errs && errs.length)
            {
                var txt = "";
                for(var i in errs)
                {
                    var e = (txt.length ? "\\par" : "") + errs[i];
                    txt += e;
                }

                return txt;
            }

            return null;
        }

        var failed_header;

        this.WiDiFailed = function()
        {
            ns.WiDiError.Text(error_reason);
            if(failed_header)
                ns.DialogHeader("Error", failed_header);
            ns.DialogHeader("Error");
            Wizard.Notify("title", "no-cancel-confirm");
            Log("disabling next due to fatal pre-requisite");
            Wizard.Notify("cancel", "hide");
            ns.Buttons("[close]");
            ns.Stage("widi.png");
            Wizard.Next.Enable();
            Wizard.Prev.Disable();
            Wizard.Cancel.Enable();
            ns.WiDiFailed.Update();
            Wizard.Subscribe("welcome", "OnClicked", function(c, m, url){Execute.URL(url);});
            return Action.Dialog({name:"Welcome", mode:"sync"});
        }

        this.WiDiFailed.Update = function()
        {
            Wizard.Notify("welcome", "set rtf text", StringList.Format("[widi_text_template]", error_reason()));
        }

        this.WiDiFailed.Header = function(h) {failed_header = h;}

        this.WiDiFailedRetry = function()
        { // using WiDiFailed infrastructure
            ns.WiDiError.Text(error_reason);
            if(failed_header)
                ns.DialogHeader("Error", failed_header);
            ns.DialogHeader("Error");
            Wizard.Notify("title", "no-cancel-confirm");
            Log("disabling next due to fatal pre-requisite");
            ns.Buttons("[Retry]", "", "[close]");
            ns.Stage("widi.png");
            Wizard.Next.Enable();
            Wizard.Prev.Disable();
            Wizard.Cancel.Enable();
            ns.WiDiFailed.Update();
            var res = Action.Dialog({name:"Welcome", mode:"sync"});
            Wizard.Notify("title", "cancel-confirm");
            return res == Action.r_ok;
        }

        //###############################################################
        // Complete
        //###############################################################
        var complete_text = "";
        var complete_on_click = function() {}
        var complete_mark;

        var image_name = "widi.png";
        var image_name81 = "widi_finish.png";

        this.WiDiComplete = function(click_at_ok)
        {
            ns.DialogHeader("WiDiComplete");
            Wizard.Notify("cancel", "hide");
            Wizard.Prev.Enable();
            if(click_at_ok)
            {
                Wizard.Notify("next", "hide");
                Wizard.Notify("button4", "show");
            }

            ns.Buttons("[close]");
            ns.WiDiComplete.Update();
            Wizard.Subscribe("finish_text", "OnClicked", complete_on_click);
            if(complete_mark)
                Wizard.Notify("finish_text", "mark link", complete_mark);
            ns.Stage(image_name);

            Wizard.Next.Enable();
            Wizard.Prev.Disable();
            Wizard.Cancel.Enable();
            Wizard.Notify("title", "no-cancel-confirm");
            var r = Action.Dialog({name:"Finish", mode:"sync"});
            if(r != Action.r_cancel && click_at_ok)
                complete_on_click();
            return r;
        }

        this.WiDiComplete.Text = function(text)
        {
            if(text)
                complete_text = text;
            else
                complete_text = "";
        }

        this.WiDiComplete.Update = function()
        {
            Wizard.Notify("finish_text", "set rtf text", StringList.Format("[widi_text_template]", complete_text));
        }

        this.WiDiComplete.Image = function(iname) {image_name = iname;}

        this.WiDiComplete.OnClick = function(cb) {complete_on_click = cb;}
        this.WiDiComplete.Mark = function(m) {complete_mark = m;}

        //###############################################################
        // Reboot
        //###############################################################
        var reboot_text = "[reboot_message]";
        var reboot_on_click;
        var reboot_mark;

        this.WiDiReboot = function()
        {
            ns.DialogHeader("WiDiReboot");
            ns.Buttons("[reboot_now]", "", "[remind_later]");
            Wizard.Next.Enable();
            Wizard.Prev.Disable();
            Wizard.Cancel.Enable();
            ns.Stage(image_name);
            ns.WiDiReboot.Update();
            Wizard.Notify("title", "no-cancel-confirm");
            if(reboot_on_click)
                Wizard.Subscribe("finish_text", "OnClicked", reboot_on_click);
            if(reboot_mark)
                Wizard.Notify("finish_text", "mark link", reboot_mark);
            var r = Action.Dialog({name:"Finish", mode:"sync"});
            Wizard.Prev.Enable();
            return r;
        }

        this.WiDiReboot.Text = function(text)
        {
            if(text)
                reboot_text = text;
            else
                reboot_text = "";
        }

        this.WiDiReboot.Update = function()
        {
            Wizard.Notify("finish_text", "set rtf text", StringList.Format("[widi_text_template]", reboot_text));
        }

        this.WiDiReboot.Image = function(iname) {image_name = iname;}
        this.WiDiReboot.OnClick = function(cb) {reboot_on_click = cb;}
        this.WiDiReboot.Mark = function(m) {complete_mark = m;}

        this.WiDiEula = function()
        {
            ns.DialogHeader("WiDiEula");
            ns.Buttons("[i_agree]", "[Prev]", "[close]");
            Wizard.Next.Enable();
            Wizard.Prev.Disable();
            Wizard.Cancel.Enable();
            ns.Stage("widi.png");
            Wizard.Notify("pre_install/info", "set rtf text", "[eula_text]");
            return Action.Dialog({name:"pre_install", mode:"sync"});
        }

        ns.DialogHeader("WiDiWelcome", "[required_updates]");
        ns.DialogHeader("WiDiComplete", "[subtitle_complete]");
        ns.DialogHeader("WiDiReboot", "[subtitle_complete]");
        ns.DialogHeader("WiDiEula", "[subtitle_eula]");
    }
}

