
var echo = function(msg){WScript.Echo(msg);}

var usage = function()
{
    echo("Usage:");
    echo("  " + WScript.ScriptName + " -i msi_file_path [-o output_file_name] [-a alias] [-s subdir]");
    return;
}

var error = function(msg, ex)
{
    echo(msg);
    if(typeof(ex) != "undefined")
        WScript.Quit(ex);
    else
        WScript.Quit(1);
}

echo("Create Windows Installer object...");
var installer = new ActiveXObject("WindowsInstaller.Installer");

if(!installer)
    error("Failed to create Installer object");

var args = WScript.Arguments;

var msi;
var out;
var alias;
var subdir = "";

for(var i = 0; i < args.Length; i++)
{
    switch(args(i))
    {
    case "-i":
        msi = args(i + 1);
        i++;
        break;
    case "-o":
        out = args(i + 1);
        i++;
        break;
    case "-a":
        alias = args(i + 1);
        i++;
        break;
    case "-s":
        subdir = args(i + 1);
        i++;
        break;
    default:
        usage();
        WScript.Quit(1);
    }
}

if(!msi)
{
    usage();
    WScript.Quit(1);
}

if(!out)
{
    out = msi;
    out = out.replace("\.msi", ".xml");
}

echo("Database to process: " + msi);
echo("Output XML document: " + out);

echo("Open database...");
var db = installer.OpenDatabase(msi, 0);
echo("done.");

if(!db)
    error("Failed to open database: " + msi);

echo("Create view...");
view = db.OpenView("select Property, Value from Property");
if(!view)
    error("Failed to create view.");
echo("done.");

echo("Fetch view...");
view.Execute();
echo("done.");

echo("Create Msxml.DOMDocument object...");
var xml = new ActiveXObject("Msxml.DOMDocument");

var root = xml.createElement("component");

var type = xml.createAttribute("type");
type.text = "msi";
root.attributes.setNamedItem(type);

if(alias)
{
    var name = xml.createAttribute("alias");
    name.text = alias;
    root.attributes.setNamedItem(name);
}

var record;

while(record = view.Fetch())
{
    root.appendChild(xml.createTextNode("\n  "));
    var prop = xml.createElement("property");
    var name = xml.createAttribute("name");
    name.text = record.StringData(1);

    prop.attributes.setNamedItem(name);

    prop.text = record.StringData(2);
    root.appendChild(prop);
    //WScript.Echo(record.StringData(1) + " : " + record.StringData(2));
}

echo("Calculating package size...");

view = db.OpenView("select FileSize from File");
if(!view)
    error("Failed to calculate file size: failed to create view.");

view.Execute();
var size = 0;
while(record = view.Fetch())
    size += record.IntegerData(1);

root.appendChild(xml.createTextNode("\n  "));
var prop = xml.createElement("property");
var name = xml.createAttribute("name");
name.text = "size";
prop.attributes.setNamedItem(name);
prop.text = size;
root.appendChild(prop);

// write file information
root.appendChild(xml.createTextNode("\n  "));

var fs = new ActiveXObject("Scripting.FileSystemObject");
var directory = fs.GetFile(msi).ParentFolder;

var files = xml.createElement("files");
files.appendChild(xml.createTextNode("\n    "));
var key = xml.createElement("key");

var file = fs.GetFile(msi);
var size = file.Size;

var file_size = xml.createAttribute("size");
file_size.text = size;
key.attributes.setNamedItem(file_size);

key.text = subdir + fs.GetFileName(msi);
files.appendChild(key);

view = db.OpenView("select Cabinet from Media");
if(!view)
    error("Failed to get file content: failed to create view.");
view.Execute();
while(record = view.Fetch())
{
    var cab = record.StringData(1);
    if(cab.substring(0,1) != "#")
    {
        var size = fs.GetFile(directory + "\\" + cab).Size;
        var file = xml.createElement("file");
        file.text = subdir + cab;

        var file_size = xml.createAttribute("size");
        file_size.text = size;
        file.attributes.setNamedItem(file_size);

        files.appendChild(xml.createTextNode("\n    "));
        files.appendChild(file);
    }
}

files.appendChild(xml.createTextNode("\n  "));

root.appendChild(files);

root.appendChild(xml.createTextNode("\n"));
xml.appendChild(root);
xml.save(out);
