
new function()
{
    this.is_valid_config = function(cfg)
    {
        if(cfg)
        {
            var invalid = false;
            Log("Opened... processing query");
            var progress = Progress();
            Wizard.Notify("Progress_Splash", "connect", progress.id);

            var filter = function(nodes, message, cb)
            {
                if(nodes && nodes.length)
                {
                    progress.total = nodes.length;
                    for(var i in nodes)
                    {
                        progress.message =  message + ": " + i + " of " + nodes.length;
                        Log("Processing node: " + i);
                        cb(nodes[i]);
                        progress.Step();
                    }
                }
                else
                    Log("Empty nodes: " + message);
            }

            var make_subtag = function(n)
            {
                return function(name)
                {
                    var t = n.single(name);
                    if(t)
                        return t.text;
                    Log("No subtag: " + name);
                    invalid = true;
                    return null;
                };
            }

            var basecheck = function(n)
            {
                var subtag = make_subtag(n);

                if(!subtag("device_name") || !subtag("pci_device_id") || !subtag("os") ||
                        !subtag("bit_version") || !subtag("driver_version") ||
                        !subtag("driver_download_url"))
                    Log("Failed");
            }

            filter(cfg.select("/config/hd/row"), "HD", basecheck);

            filter(cfg.select("/config/wireless/row"), "Wireless", function(n)
                    {
                    basecheck(n);
                    var subtag = make_subtag(n);
                    if(!subtag("pci_subsystem_id") || !subtag("pci_subvendor_id") || !subtag("proset_version"))
                    Log("Failed");
                    });

            filter(cfg.select("/config/widi/row"), "HD", function(n)
                    {
                    var subtag = make_subtag(n);

                    if(!subtag("device_name") || !subtag("os") ||
                        !subtag("bit_version") || !subtag("driver_version") ||
                        !subtag("driver_download_url"))
                    Log("Failed");
                    });
            return invalid;
        }
        else
            return false;
    }
}

