
new function()
{
    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};
    var base = function(name) {return load("Base/" + name);};

    var ns_cinf = base("component_info.js");
    var helper = load("helper.js");

    var detect_oem = function(infname)
    {
        var infpath = GetOpt.GetDefault("inf-path", FileSystem.AbsPath(FileSystem.SpecialFolder.windows + "/inf", infname));
        Log("Processing inf file: " + infpath);

        if(FileSystem.Exists(infpath))
        {
            if(FileSystem.HasSignatureUtf16(infpath))
            {
                Log("File has UTF16 signature... processing it as UTF16 file");
                var text = FileSystem.ReadFileUTF16(infpath);
            }
            else
                var text = FileSystem.ReadFileUTF8(infpath);
            var lines = text.split(/\n+/g);

            var pattern_4id = /\%.+\%.*=.*pci\\ven_([0-9a-z]{4})&dev_([0-9a-z]{4})&subsys_([0-9a-z]{4})([0-9a-z]{4})/i;
            //var pattern_2id = /\%.+\%.*=.*pci\\ven_([0-9a-z]{4})&dev_([0-9a-z]{4})/i;

            return helper.filter(lines, function(line)
            {
                if(line.match(pattern_4id))
                {
                    Log("matched: ID4: " + line);
                    return true;
                }
            });
        }
        else
            Log("File doesn't exist");

        return false;
    }

    this.DetectHD = function(cfg, drivers, devices)
    {
        Log("HD detection starting...");

        var callbacks = {};
        callbacks.classfilter = function() {return /4D36E968-E325-11CE-BFC1-08002BE10318/i;}
        callbacks.xpath = function(pci)
        {
            var cond = "pci_device_id='[%s]'";
            var x = StringList.Format(cond, pci.id.toUpperCase());
            return "/config/hd/row[" + x + "]";
        }
        callbacks.fake = function(id, value) {return GetOpt.GetDefault("hd-" + id, value);}

        var data = helper.ScanHardware(cfg, devices, drivers, callbacks);
        Log("HD detection status:");
        helper.log_object(data);

        if(typeof(data.cmdline) == "undefined")
            data.cmdline = "-s -A -s";

        if(data.error)
        {
            if(data.no_devices)
                data.error_message = "[not_supported_graphic]";
            else // if(data.another_os)
                data.error_message = "[wrong_os_graphic]";
        }
        else if(data.inf && detect_oem(data.inf))
        {
            Log("Detected OEM specific driver. Disabling update");
            data.update = false;
            data.oem = true;
        }
		
        return data;
    }
}

