
new function()
{
    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};
    var base = function(name) {return load("Base/" + name);};

    var ns_ver  = base("version.js");

    this.OsInfo = function()
    {
        var osinfo = System.WindowsInfo();
        Log("OS Info: Major: " + osinfo.major + ", Minor: " + osinfo.minor);
        if(GetOpt.Exists("os-version"))
            var wver = ns_ver.Version(GetOpt.Get("os-version"));
        else
            var wver = ns_ver.Version([osinfo.major, osinfo.minor]);

        if(wver.gt("5.1") && wver.lt("6.0"))
            var osname = "XP";
        else if(wver.eq("6.0"))
            var osname = "Vista";
        else if(wver.eq("6.1"))
            var osname = "7";
        else if(wver.eq("6.2"))
            var osname = "8";
        else if(wver.eq("6.3"))
        {
            var osname = "8.1";
            var win81 = true;
        }
        else if (wver.eq("10.0")) {
            var osname = "10";
        }

        var osname = GetOpt.GetDefault("os-name", osname);

        Log("Os name: " + osname);
        if(System.ProcessorArch() == System.ProcessorArch.pa_x86)
            var bitnes = 32;
        else
            var bitnes = 64;

        if(GetOpt.Exists("os-bitnes"))
            bitnes = parseInt(GetOpt.Get("os-bitnes"));

        if(win81)
            Log("Windows 8.1 detected");

        return {name:osname, win81:win81, bitnes:bitnes, version:wver};
    }
}

