
new function()
{
    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};
    var base = function(name) {return load("Base/" + name);};

    this.Schedule = function(dumper)
    {
        var act = function()
        {
            Log("Checking for VAD driver installed");

            var check_entry = function(keyname)
            {
                Log("Looking for entry: " + keyname);
                var key = Registry("HKLM", keyname);
                if(key.Exists())
                {
                    Log("  Key exists");
                    var imagepath = key.Value("ImagePath");
                    if(imagepath)
                    {
                        Log("  ImagePath: " + imagepath);
                        var name = FileSystem.FileName(imagepath);
                        Log("  File name: " + name);
                        var path = FileSystem.AbsPath(FileSystem.SpecialFolder.system + "/drivers", name);
                        Log("  Image path to evaluate: " + path);
                        if(FileSystem.ExistsWow(path))
                        {
                            Log("  File exists");
                            return true;
                        }
                        else
                            Log("  File not found");
                    }
                    else
                        Log("  Value not found or not exists");
                }
                else
                    Log("  Key does not exist");
                return false;
            }


            if(check_entry("SYSTEM\\CurrentControlSet\\Services\\intaud_WaveExtensible") &&
               check_entry("SYSTEM\\CurrentControlSet\\Services\\iwdbus"))
            {
                Log("Ok, service installed");
            }
            else
            {
                Log("Processing VAD installation");
                var osinfo = load("detect_os.js").OsInfo();

                if(osinfo.bitnes == 32)
                    var iname = "IntelWiDiVad32.exe"
                else // (osinfo.bitnes == 64)
                    var iname = "IntelWiDiVad64.exe"

                var installer = FileSystem.AbsPath(FileSystem.SpecialFolder.system, iname);
                Log("Installer path: " + installer);

                if(FileSystem.ExistsWow(installer))
                {
                    var helper = load("helper.js");

                    var cmdline = helper.quote(installer) + " install";
                    Log("cmdline: " + cmdline);
                    var res = CreateProcess(null, cmdline, true, null, true);
                    Log("Result: ");
                    helper.log_object(res);
                }
                else
                    Log("File doesn't exist");
            }

            return Action.r_ok;
        }

        if(dumper)
            dumper.AddAction({Apply:act}, "VAD driver restore action");

        if(GetOpt.Exists("vad-run-now"))
            act();
    }
}

